;;;======================================================================
;;; -*- Mode:Lisp; Syntax:Common-Lisp; ; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB -  IDSIA  *
;;; ******************************
;;;
;;; Filename:    match.cl
;;; Short Desc:  Algorithms for match and unification
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   June 1991
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;



;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)
;;------------------------------------------------------
;; apply-sub   : S-EXPR x SUBSTITUTION ---> S-EXPR
;; Behavior    : Applies the substitution 'sigma' to 'exp'
;; Example     : (apply-sub '(p (f x)) '( ( x . 8))) = (p (f 8)) 

(defmethod  apply-sub (exp sigma)
       (let ((exp1 exp))
	 (cond ((null sigma) exp1)
	       (t (apply-sub
		   (subst (cdar sigma) (caar sigma) exp1)
		   (cdr sigma))))))


(defmethod apply-sub ((clause clause-class) sigma)
  (remake-clause (apply-sub (positive-atoms clause) sigma)
		 (apply-sub (negative-atoms clause) sigma)
		 clause))

;;----------------------------------------------------
;; compose     : SUBSTITUTION  x SUBSTITUTION ---> SUBSTITUTION  
;; Behavior    : computes the composition of two substitutions
;; Example     : (compose ((x . (f y)) ((y . a) (z . b))  ) =  ((x . (f a)) (z . b))

(defun compose (s1 s2)
    (add-consistent  (apply-sub s1 s2) s2))
(defun add-consistent (sub nsub &optional temp)
    (cond ((null nsub) (append sub  temp))
          ((eq   (cdar nsub) (car (assoc (cdar nsub) sub)))
                   (add-consistent sub (cdr nsub) temp))
          (t (add-consistent sub (cdr nsub) (cons (car nsub) temp)))))

(defun constant (x)
    (and (atom x) (not (is-int-var x))))

(defun occurs (v exp)
    (cond (( atom  exp) (eq v exp))
          (t (or (occurs v (car exp))
                 (occurs v (cdr exp))))))

(defun mguvar (var exp)
    (cond ((occurs var exp) 'fail)
          (t (list (cons var exp)))))


;;-----------------------------------------------------------------------
;; mgu         : TERM x TERM ---> SUBSTITUTIION
;; Behavior    : computes the most general unifier between two terms
;; Example     : (mgu (P x a)  (P b y)) = ((x . b) (y .a))
(defun mgu (x y)
  (incf $unification-attempts$)
  (mgu1 x y))

(defun mgu1 (x y)
  (let ((siggy nil))
    (cond 
     ((equal x y ) nil)
     ((and (listp x)(listp y)(eq-sym (car x) (car y)))
      (if (eq 'fail (setq siggy (mgu1 (cdr x) (cdr y))))
	  (mgu1 (cdr x)(list (caddr y) (cadr y)))
	siggy))
     ((is-int-var x) (mguvar x y)) 	
     ((is-int-var y) (mguvar y x)) 	
     ((or (atom x) (atom y)) 'fail)
     ((not (eq (length x)(length y))) 'fail)
     (t (let ((sub nil))
	  (do* ((g nil (compose g sub))
		(xx x  (cdr (apply-sub xx sub)))
		(yy y  (cdr (apply-sub yy sub))))
	      ( (null xx) g)
	    (setq sub (mgu1 (car xx)(car yy)))
	    (cond ((eq sub 'fail) (return 'fail)) (t))))))))

;;-----------------------------------------------------------------------
;; match       : TERM x TERM ---> SUBSTITUTIION
;; Behavior    : finds a substitution sigma such that sigma(tx) = tt
;; Example     : match( (p x) (p (f a)))  =  ( (x . (f a)))

(defun match (tx tt)
    (incf $unification-attempts$)
    (restore-sub  (match1 tx (to-ground tt))))
(defun match1 (tx tt)
  (let ((siggy nil))
    (cond
     ((equal tx tt) nil)
     ((and (listp tx)(listp tt)(eq-sym (car tx) (car tt)))
      (if (eq 'fail (setq siggy (match1 (cdr tx) (cdr tt))))
	  (match1 (cdr tx)(list (caddr tt) (cadr tt)))
      siggy))
     
     ((is-int-var tx)  (list (cons  tx tt)))
     ((or (atom-ground tx)(atom-ground tt)) 'fail)
     ((not (eq (length tx)(length tt))) 'fail)
     (t (let ((sig1))
	  (do* ((sigma nil (compose sigma sig1))
		(txx tx (cdr (apply-sub txx sig1)))
		(ttt tt (cdr ttt)))       
	      ((null txx) sigma)
	    (setq sig1 (match1 (car txx) (car ttt)))
	    (cond ((eq 'fail sig1) (return 'fail)) (t))
	    (cond ((eq 'fail sigma) (return 'fail)) (t))))))))
 
(defun eq-sym ( x y)
  (and (member  x '(= ->))
       (member  y '(= ->))))
  
	
	  
(defun to-ground (term)
  (cond ((is-int-var term) (list '% term))
	((atom term) term)
	(t (mapcar #'to-ground term))))
(defun restore-sub (s)
  (cond ((eq 'fail s) 'fail)
        ((null s) nil)
	(t (mapcar #'(lambda (pair) (cons ( car pair) (from-ground (cdr pair)))) s))))
(defun from-ground (term)
  (cond ((atom term) term)
	((is-ground-var term) (cadr term))
	(t (mapcar #'from-ground term))))
(defun is-ground-var (pair)
  (and (eq '% (car pair)) (numberp (cadr pair))))
(defun atom-ground (term)
  (or (atom term) (eq '% (car term))))



;;-------------------------------------------------------
;; n-match      :   N-TERM x N-TERM ---> SUBSTITUTION
;; Behavior     :   returns a substitution sigma such that sigma(ntx)
;;              :   is a subset of ntt.
;; Example      :   n-match( `((a x)(b x))  '((p a)(b b)(q y)(a b))) = ((x . b))



(defun n-match (ntx ntt) (restore-sub (n-match1 ntx (to-ground ntt)))) 
(defun n-match1 (ntx ntt)    
  (cond
   (( > (length ntx)(length ntt)) 'fail)
   ((null ntx) nil)
   (t (let ((s))
	(do* ((todo   ntt (cdr todo))
	      (todolist (first-match (car ntx ) todo)
			(first-match (car ntx ) todo)))
	    ((eq 'fail todolist)  'fail)
	  (cond ((not
		  (eq 'fail
		      (setq s (n-match1 (apply-sub (cdr ntx) (car todolist))
				       (del (cadr todolist) ntt)))))
		 (return (compose s (car todolist)))) (t))
	  (cond ((null todo) (return 'fail)) (t)))))))

 
(defun first-match (tx todo)
  (let ((s nil))
    (cond ((null todo) 'fail)
	  ((not (eq (setq s (match1 tx (car todo))) 'fail))
	   (list s (car todo) (cdr todo)))
	  (t (first-match tx (cdr todo))))))
  


;;-----------------------------------------------------------
;; overlap    : N-TERM x N-TERM ---> (SUBSTITUTION N-TERM)
;; Behavior   : computes a substitution sigma and a n-term nt such
;;            : that nt is the intersection between sigma(nt1) and sigma(nt2)
;; Example    : overlap( (A B(x) (P b)) (Q (P y) (B a)) =( ((x .a) (y .b))  ((B a) (P b))




(defun overlap( nt1 nt2 )
  (let ((res   (overlap1 nt1 nt2 nil nil)))
    (cond ((null (cadr res)) 'fail)
	  (t res))))
(defun overlap1 (nt1 nt2 sigma cp)
  (cond ((or (null nt1) (null nt2)) (list sigma (reverse cp)))
	(t (let (( res (first-mgu (car nt1) nt2)))
	     (cond ((eq 'fail res) (overlap1 (cdr nt1) nt2 sigma cp))
		   (t (let (( s (car res))
			    (st2 (cadr res)))
			(overlap1 (apply-sub (cdr nt1) s)
				  (del st2
					(apply-sub nt2 s))									     
				  (compose sigma s)
				  (cons st2 cp)))))))))
		 
(defun first-mgu (t1 nt2)
  (let ((s nil))
    (cond ((null nt2) 'fail)
	  ((not (eq (setq s (mgu t1 (car nt2))) 'fail))
	   (list s (apply-sub (car nt2) s)))
	  (t (first-mgu t1 (cdr nt2))))))
  



;=====================================================================
;  30-04-1990
;            Algorithms for unification with subterms
;=====================================================================

(defun first-deep-mgu (tm1 tm2list)
  (cond 
   ((null tm2list) 'fail)
   ((is-int-var (car tm2list))(first-deep-mgu tm1 (cdr tm2list)))
   ((not(eq 'fail (setq sigma (mgu tm1 (car tm2list)))))
    (cons sigma (append (sons (car tm2list)) (cdr tm2list))))
   (t (first-deep-mgu tm1 (append (sons (car tm2list))(cdr tm2list))))))

(defun sons (tm)
  (cond ((atom tm ) nil)
	(t (cdr tm))))

  
  
;;-------------------------------------------------
;; first-p-mgu  : ATOMICF X N-TERM ---> CONS(SUBSTITUTION,N-TERM) 
;; behavior     : finds the first atom of nt unifying with at returning
;;              : the mgu and the remaining part of nt.
;; side effects : none
;; example      : first-p-mgu( a(x) (p(a) a(b) a(c) b(y))) = (((x.b)) . (a(c) b(y)))

(defun first-p-mgu (at nt)
  (let ((s nil))
    (cond ((null nt) 'fail)
	  ((not (eq 'fail (setq s (mgu at (car nt)))))
	   (cons s (cdr nt)))
	  (t (first-p-mgu at  (cdr nt) )))))


 
