;;==================================================================
;; 21.02.1990
;; Generation of new Symbols
;;==================================================================

(in-package :atp)
(defun init-gsym ()
 (setq -sym-table (make-hash-table)))

(defun gsym (c)
    (let ((n  (gethash c -sym-table )))
    (cond ((null n)(setf (gethash c -sym-table) 0)
                   (build c 0))
          (t (setf (gethash c -sym-table)  (+ 1 n))
             (build c (+ 1 n))))))

(defun build (at n)
   (read-from-string (coerce (append (coerce (string at) 'list)
	                            (coerce  (int-string n) 'list)) 'string)))   

(defun int-string (n &optional temp)
   (let ((nn) (rest))
   (cond (( < n 10) (coerce (cons (digit-char n) temp) 'string))
        (t (multiple-value-setq (nn rest) (floor n 10))
           (int-string nn (cons (digit-char rest) temp))))))

 
