;;; -*- Mode: LISP; Package: RULES; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   backward-rules-dialog.cl
;;; Short Desc: dialog handling for Backward-Rules
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   24.1.92 DTA
;;; Author:     Mike Rosner
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentatioern.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
 

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rules)




;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================










;;==================================================================
;; The Backward-Rules Dialog

(defun start-backward-rules-dialog (&optional (from-button nil))
  (setq *demo-in-execution* nil)
  (format nil "rules: ~a - ~a" planning::*verbose*
	  (not (typep planning::*verbose-disp* 'gin::scroll-display)))
  (if (and planning::*verbose* (not (typep planning::*verbose-disp* 'gin::scroll-display)))
      (progn  (setf planning::*verbose-disp* (make-instance 'scroll-display
						 :title "Backward-Rules:Verbose Comments"
						 :width 580
						 :height 150
						 :borders 1
						 :active nil
						 :left 500
						 :bottom 375))
	      
	      (setf planning::*verbose* planning::*verbose-disp*)
	      )
    (setf planning::*verbose-disp* planning::*verbose*))
;  (deactivate-display pail-lib::*main-window*) ; especially during
					;  debugging, I don't
					;  recommend this. -dta
  (let* ((disp (make-instance 'display :title "Backward-Rules:Main Window"
			     :width 300
			     :height 150
			     :borders 1
			     :left (+ (width pail-lib::*main-window*) (left pail-lib::*main-window*))
			     :bottom (bottom pail-lib::*main-window*)))
	 (menu-button (make-instance 'pop-up-button
			:label "Demos"
			:width 100))
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (make-instance 'help-button
			:technical (add-path "backward-rules-desc.tec" *backward-rulespath*)
			:general (add-path "backward-rules-desc.gen" *backward-rulespath*)
			:subject "Backward-Rules"))
	 (tool-button (make-instance 'push-button :label "Tool" :width 100))
	 (menu (make-instance 'menu
		 :items  (let ((mlist nil))
			   (dotimes (i *number-of-demos* (nreverse mlist))
			     (setf mlist 
			       (cons (list (format nil "Demo ~a" (1+ i)) 
					   `(lambda () 
					      (demo ,(1+ i) ,menu-button ,exit-button)) 
					   (make-title (1+ i)))
				     mlist))))
		 
       		 :query " DEMOS ")))
    
    (setf (menu menu-button) menu)

    
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))
    
;    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
;    (write-display disp
;		   "Welcome to ..."
;		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (cw:open-font :courier :italic 45 :weight :bold))
    (write-display disp
		   "Backward-Rules"
		   (/ (width disp) 12)
		   (- (height disp) 40 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda nil
			   (close-display ,disp)
			   (close-display planning::*verbose-disp*)
			   (close-display planning::*planner-window*)
			   (close-display planning::*node-info-window*)
;			   (activate-display pail-lib::*main-window*)
;			   (sleep 1)
			   
			   
			   (if ,from-button (reset-button ,from-button))))
    
    (set-button tool-button disp
		:left (/ (- (width disp) (width menu-button)) 2)
		:bottom 15
		:action `(lambda nil 
;			   (disable-button ,exit-button)
			   (disable-button ,menu-button) 
;			   (deactivate-display ,disp)
			   (backward-rules-tool  ,tool-button) 
			   (setq  *execution-terminated* nil)
			   (mp:process-wait "running" 
					    '(lambda nil *execution-terminated*))  
			   (activate-display ,disp)(sleep 1)
			   (reset-button ,tool-button)
;			   (enable-button ,exit-button)
			   (enable-button ,menu-button)))
    

    (set-button help-button disp :left 15 :bottom 15)
    
    (set-button menu-button disp 
		:left (/ (- (width disp) (width menu-button)) 2)
		:bottom 45)
    exit-button))





(defun make-title (nr)
  (format nil "~:R Demo on~%~%   Backward-Rules~%" nr))

(defun make-title-w (nr)
  (format nil "~:R Demo on Backward-Rules" nr))


(defun demo (nr menu-button other-exit-button)
  (disable-button menu-button)
  (disable-button other-exit-button)
  (let ((disp (make-instance 'display :title (concatenate 'string "Backward-Rules:" (make-title nr))
			    :width 800
			    :height 200
			    :borders 1
			    :left 185
			    :bottom 610))
	(exit-button (make-instance 'push-button :label "Exit" :width 180))
	(help-button (make-instance 'help-button
		       :width 180
		       :subject (concatenate 'string "BACKWARD-RULES:" (make-title nr))
		       :technical (add-path
					"demo-desc.tec"
					*backward-rulespath*)
		       :general (add-path
					(concatenate 'string
					  "demo" (write-to-string nr) "-desc.gen")
					*backward-rulespath*) ))
	(start-button (make-instance 'push-button :label "Start" :width 180))
	(cont-button (make-instance 'push-button :label "Continue" :width 180))
	
	
	
	)

    (if planning::*verbose*
	(progn  (setf planning::*verbose-disp* (make-instance 'scroll-display
						   :title "Backward-Rules:Verbose Comments"
						   :width 580
						   :height 150
						   :borders 1
						   :active t
						   :left 500
						   :bottom 375))
	      
		(setf planning::*verbose* planning::*verbose-disp*)
		)
      (setf planning::*verbose-disp* planning::*verbose*))
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)


    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15) 
		:bottom 15
		:action `(lambda ()
			   (close-display planning::*verbose-disp*)
			   (close-display planning::*planner-window*)
			   (close-display planning::*node-info-window*)
			   (setf *quit* t)
			   (enable-button ,menu-button)
			   (enable-button ,other-exit-button)
			   (close-display ,disp)))

    (set-button help-button disp :left 15 :bottom 15)
    

    (set-button start-button disp 
		:left (round (+ 15
				(width start-button)
				(/ (- (width disp)
				      30
				      (* 4 (width start-button)))
				   3)))
		:bottom 15
		:action
		#'(lambda ()
		    (disable-button exit-button)
		    (dialog-handler nr disp start-button cont-button exit-button)))
		
    (set-button cont-button disp 
		:left (round (+ 15
				(* 2 (width start-button))
				(* 2 (/ (- (width disp) 
					   30 
					   (* 4 (width start-button)))
					3))))
		:bottom 15
		:action 
		#'(lambda ()
		    (disable-button exit-button)
		    (setf *pause* (not *pause*))))
    (disable-button cont-button)

    
    
    
		    
    
    ))



(defun dialog-handler (nr parent start-button cont-button exit-button)
  (let ((text-disp (make-instance 'scroll-display
                                  :title "BACKWARD-RULES:Comments"
				  :font (open-font-named "fixed")
				  :parent parent
				  :width 300
				  :height 100
				  :borders 1
				  :left 400
				  :bottom 60))
	
	(problem-disp (make-instance 'scroll-display
                                  :title "Backward-Rules: sample problem"
				  :font (open-font-named "fixed")
				  :width 480
				  :height 400
				  :borders 1
				  :left 600
				  :bottom 190)))
    (labels ((clean-up ()
	       (close-display text-disp)
	       (close-display problem-disp)
	       
	       
	       
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (format-display text-disp "~&~%[Press <Continue> Button]")
	  (mp:process-wait "wait-on-click" (function (lambda () (or *quit* *pause*))))
	  ;(do () ((or *quit* *pause*)))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol (symbol-name (read-from-string (format nil "dialog-~a" nr))) :planning)))
	(if fun-sym
	    (funcall fun-sym text-disp nil problem-disp)
	  (format t "Demo not implemented")))
      (wait)
      (clean-up))))







;; ==============

;;; provisional tool to test saving to pool (feel free to edit this as
;;; often and as much as you like).






(defclass backward-rules-tool-display (display)
	  ((plannerw :accessor plannerw
		     :initarg :plannerw
		     :initform nil)
	   (nifw :accessor nifw
		 :initarg :nifw
		 :initform nil)
	   
	   (param :accessor param
		  :initarg :param
		  :initform nil)
	   (help-button :accessor help-button
		  :initarg :help-button
		  :initform nil)))

(defmethod close-display :before ((disp backward-rules-tool-display))
  (close-display (plannerw disp))
  (close-display (nifw disp))
  (close-display (param disp))
  (close-display (technical-window (help-button  disp)))
  (close-display (general-window (help-button  disp)))
  )


(defun backward-rules-tool (&optional (from-button nil))
  (setf  planning::*verbose* planning::*verbose-default*)
  (setf *bc-loaded* t)
  (setf planning::*verbose-disp* (make-instance 'scroll-display
				     :title "Verbose Comments"
				     :width 480
				     :height 200
				     :borders 1
				     :active planning::*verbose*
				     :left 500
				     :bottom 375))

  (setf *trace-stream* planning::*verbose-disp*)
  (let* ((disp (make-instance
		 'backward-rules-tool-display
		:title "BACKWARD-RULES: Search Spaces"
		:width 500
		:height 270
		:left 300
		:bottom 580
		:borders 1))
	 
	 
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (make-instance 'help-button
			:technical (add-path "tool-desc.tec" *backward-rulespath*)
			:general (add-path "tool-desc.gen" *backward-rulespath*)))
	 (run-button (make-instance 'push-button :label "Run" :width 70))
	 (stop-button (make-instance 'push-button :label "Stop" :width 70))
	 (param-button (make-instance 'push-button :label "Parameters" :width 100))
	 (verb-button (make-instance 'radio-button :label "Verbose mode" :status planning::*verbose*))
	 (file-button (make-instance 'file-button
			:w-directory *rulespath*))
	 (limit-button (make-instance 'value-button :name "Search Limit:" :width 75 
				      :numeric t :value *limit*))
	 (menu-button-ops (make-instance 'pool-button
			    :name "Rule Set:"
			    :value ""
			    :width 250
			    :target-class 'pail-lib::bc-set
			    :pool *pail-pool*
			    :border t
			    :show-function #'(lambda (item)
					       (documentation-print (dump-editable item )))
			    ))
	 (menu-button-wms (make-instance 'pool-button
			    :name "Facts:"
			    :pool *pail-pool*
			    :value ""
			    :width 250
			    :target-class 'rules::working-memory
			    :border t
			    ))
	 (goal-button (make-instance 'pool-button
			:name "Goal:"
			:pool *pail-pool*
			:value ""
			:width 250
			:target-class 'rules::working-memory
			:border t
			)))	
    (setf (help-button disp) help-button)
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (width *pail-logo*) 15)
	       (- (height disp) (height *pail-logo*) 15))
    (set-button file-button disp
		:left (- (width disp) (width file-button) 7)
		:bottom (- (height disp) (height file-button) (cw:bitmap-height *pail-logo*) 20))
    (setf (font disp) (open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (open-font :courier :italic 45 :weight :bold))
    (write-display disp
		   "Backward Chaining Tool"
		   (/ (width disp) 10)
		   (- (height disp) 40 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    (set-button help-button disp :left 15 :bottom 15)
    (set-button run-button disp 
		:left (+  (width help-button) 15 20)
		:bottom 15
		:action `(lambda nil
			   (cond ((null (start-object (button-value ,menu-button-ops)))
				  (display-error "Please specify a rule set."))
				 (t (let ((goal (assertions
						 (start-object (button-value ,goal-button)))))
				      (setf *backward-chainer* t)
				      (use-planner planning::*which-planner*)
				      (use-ops (start-object (button-value ,menu-button-ops)))
				      (setf *limit* (button-value ,limit-button))
				      (if (and (eq 1 (length goal))
					       (has-var goal))
					  (setf *multiple-value-goal* (car goal))
					(setf *multiple-value-goal* nil))
				      (setf *multiple-values* nil)
				      (multiple-value-bind (plan planning-tree)

					  (solve (assertions (start-object (button-value ,menu-button-wms)))
						 (assertions (start-object (button-value ,goal-button))))
					(if *multiple-values*
					    (documentation-print (remove-duplicates
								  *multiple-values* :test #'equal))
					  (documentation-print (final-solution plan)))
					
					(draw-tree planning-tree
						 
						   )
					
					))))
				    (reset-button ,run-button)
				    ))

    (set-button stop-button disp 
		:left (+  (width run-button) (left run-button)  20)
		:bottom 15
		:action `(lambda nil
			   (setf search::*user-stop* t)
			   (reset-button ,stop-button)
			   ))
    (set-button param-button disp 
		:left (+  (width stop-button) (left stop-button)  20)
		:bottom 15
		:action `(lambda nil
			   
			   (get-parameter-settings ,param-button)
			   ))


  
    (set-button menu-button-ops disp 
		:left (- (width disp) (width menu-button-ops) 60)
		:bottom 55

		)
    
    (set-button menu-button-wms disp 
		:left (- (width disp) (width menu-button-ops) 60)
		:bottom (+ 55 (height menu-button-ops))

		)
    (set-button goal-button disp
		:left (- (width disp) (width menu-button-ops) 60)
		:bottom (+ 55 (* 2 (height menu-button-ops)))
		 )

    

    (set-button verb-button disp
		:left (- (width disp) (width menu-button-ops) 60)
		:bottom (+ 15 (bottom goal-button) (height goal-button))
		:action #'(lambda nil (setf planning::*verbose* (not planning::*verbose*))
				  (if planning::*verbose* (activate-display planning::*verbose-disp*)
				    (deactivate-display planning::*verbose-disp*))))

    

    

    (set-button limit-button disp
		:left (- (width disp) (width menu-button-ops) 60)
		:bottom (+ (bottom verb-button) 5 (height verb-button)))


    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda nil
			   (setf *bc-loaded* nil)
			   (setf (nifw ,disp) planning::*node-info-window*)
			   (setf (param ,disp) planning::*param-display*)
			   (setf (plannerw ,disp) planning::*planner-window*)

			   (if (not planning::*planning-loaded*)
			       (close-display planning::*verbose-disp*))
			   (close-display ,disp)
			   (setf *execution-terminated* t)
			   ))
    ))


(defun final-solution (plan)
  (if (null (strips::plan-pending-goals plan))
	     (reverse (strips::plan-steps-taken-stack plan))
	   "No solution found."))



;;; ==========================================================================
;;; Setup of the search control to be used. 
;;; ==========================================================================

(defclass parameter-display (display)
	  ((help-button :accessor help-button
			:initform nil
			:initarg :help-button)))
			

(defmethod close-display :before ((disp parameter-display))
  (close-display (technical-window (help-button disp)))
  (close-display (general-window (help-button disp))))


(defun get-parameter-settings (called-by-button)
  
  (let* (
	 
	
	 (help-button (make-instance 'help-button
			:technical (add-path "backward-rules-p.tec" *backward-rulespath*)
			:general (add-path "backward-rules-p.gen" *backward-rulespath*)
			:subject "Backward-Rules Parameters"))
	 (depth-button (make-instance 'radio-button :label "Depth First"
				      :status (equal planning::*which-search* search::*depth-first-search*)))
	 (breadth-button (make-instance 'radio-button :label "Breadth First"
					:status (equal planning::*which-search* search::*breadth-first-search*)))
	 (best-button (make-instance 'radio-button :label "Best First"
				     :status (equal planning::*which-search* search::*best-first-search*)))
	 #| (limit-button (make-instance 'value-button :name "Search Limit:" :width 75 
				      :numeric t :value *limit*)) |#
	 window-height
	 (vb-height (+ 3 (height depth-button)))
	 (lineheight (font-character-height *default-font*))
	 (rb-height (max (height help-button) (font-character-height *default-font*))))

    

    
    (setf *parameter-done* (make-instance 'push-button :label "Exit"))
    (setf *new-f* (make-instance 'push-button :label "New"))
    (setf *defined-f* (make-instance 'select-button :label "Rank functions"
				     :exclusive t
				     
				     :width 110 :height 90
				     :action `(lambda ()
						(change-ff (item-label)))
				     :items (mapcar #'(lambda (s) (format nil "~a" s))
						    *known-rank-fns*)))
    (setf window-height (+ (* 5 vb-height) 
			   (height *defined-f*) (* 9 lineheight) 10))
    (setf *param-display*
      (make-instance 'parameter-display  :title "BACKWARD-RULES:Parameters"

		     :left 800 :bottom (- 850 window-height)
		     :width (+ (font-string-width *default-font* "Plan Representation")  10)
		     :height window-height
		     :borders 1))

    (setf (help-button *param-display*) help-button)

    (write-display *param-display*
		   "Plan Representation"
		    5  (- window-height lineheight))
		   

    


    



    (write-display *param-display*
		   "Search Strategy"
		   5  (- window-height (* 2 lineheight) (* 3 vb-height)))
    
    (set-button depth-button *param-display*
		:left 10
		:bottom (- window-height (* 2 lineheight) (* 4 vb-height) 8)
		:action #'(lambda nil (setf planning::*which-search* search::*depth-first-search*)
				  (setf (planner-default-search-fn planning::*which-planner*)
				    planning::*which-search*)))
    (set-button breadth-button *param-display*
		:left 10
		:bottom (- window-height (* 2 lineheight) (* 5 vb-height) 8)
		:action #'(lambda nil (setf planning::*which-search* search::*breadth-first-search*)
				  (setf (planner-default-search-fn planning::*which-planner*)
				    planning::*which-search*)))
    (set-button best-button *param-display*
		:left 10
		:bottom (- window-height (* 2 lineheight) (* 6 vb-height) 8)
		:action #'(lambda nil (setf planning::*which-search* search::*best-first-search*)
				  (setf (planner-default-search-fn planning::*which-planner*)
				    planning::*which-search*)))


    (set-exclusive best-button breadth-button depth-button)

    
    

    (draw-line *param-display* 0 (- (bottom best-button) 5)
	       (width *param-display*) (- (bottom best-button) 5))
    (draw-line *param-display* 0 (+ rb-height 10) (width *param-display*) (+ rb-height 10))
    

    (set-button *defined-f* *param-display*
		:left 5
		:bottom (+ 16 (height *parameter-done*)))
    (set-button *new-f* *param-display*
		:left (- (width *param-display*) (width *new-f*) 5)
		:bottom (bottom *defined-f*)
		:action `(lambda () (new-ff)))
    (if planning::*which-rank* (dolist (i (items *defined-f*) t)
			     (if (equal (write-to-string (intern planning::*which-rank*)) (label i))
				 (unless (status i) (toggle-button i))
			       (clear-button i))))
    (set-button *parameter-done* *param-display*
		:left (- (width *param-display*) 5 (width *parameter-done*))
		:bottom 5
		:action `(lambda nil
			   (close-display ,*param-display*)
			   (reset-button ,called-by-button)))
    (set-button help-button *param-display* :left 5 :bottom 5)
    ))

(defun change-ff (function-name)

  (setf planning::*which-rank* (loop for fn in *known-rank-fns*
      thereis (if (equal function-name (format nil "~a" fn)) fn)))
  (setf (planner-default-rank-fn planning::*which-planner*) planning::*which-rank*)
  
  )

(defun new-ff ()
  (let ((function-name (ask "What is the name of the new function? ")))
    (if (not (fboundp (intern function-name :planning)))
	(display-error (format nil
			       "The Function `~a' is not defined~
                  ~&in the Planning Package."
			       (intern function-name)) :wait nil)
      (progn
	(push (intern function-name :planning) (planner-rank-fns planning::*which-planner*))
	(push (intern function-name :planning) *known-rank-fns*)
	(add-item  *defined-f* function-name :action (action *defined-f*))
      ))
  (reset-button *new-f*)
  ))


(defun auto-handler (nr parent start-button cont-button exit-button)
  (let ((text-disp (make-instance 'scroll-display
                                  :title "BACKWARD-RULES:Comments"
				  :font (open-font-named "fixed")
				  :parent parent
				  :width 300
				  :height 100
				  :borders 1
				  :left 400
				  :bottom 60))
	
	(problem-disp (make-instance 'scroll-display
                                  :title "Backward-Rules: sample problem"
				  :font (open-font-named "fixed")
				  :width 480
				  :height 400
				  :borders 1
				  :left 600
				  :bottom 190)))
    (labels ((clean-up ()
	       (close-display text-disp)
	       (close-display problem-disp)
	       
	       
	       
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (format-display text-disp "~&~%[Press <Continue> Button]")
	  (sleep 1)
	  (software-push cont-button)
	  (mp:process-wait "wait-on-click" (function (lambda () (not pail-lib::*pause-demo*))))
	  (if pail-lib::*stop-demo* (setq *quit* t))
	  ;(do () ((or *quit* *pause*)))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol (symbol-name (read-from-string (format nil "dialog-~a" nr))) :planning)))
	(if fun-sym
	    (funcall fun-sym text-disp nil problem-disp)
	  (format t "Demo not implemented")))
      (wait)
      (clean-up))))

(defun auto-demo (nr  )
  (let ((disp (make-instance 'display :title (concatenate 'string "Backward-Rules:" (make-title nr))
			    :width 800
			    :height 200
			    :borders 1
			    :left 185
			    :bottom 610))
	(exit-button (make-instance 'push-button :label "Exit" :width 180))
	(help-button (make-instance 'help-button
		       :width 180
		       :subject (concatenate 'string "BACKWARD-RULES:" (make-title nr))
		       :technical (add-path
					"demo-desc.tec"
					*backward-rulespath*)
		       :general (add-path
					(concatenate 'string
					  "demo" (write-to-string nr) "-desc.gen")
					*backward-rulespath*) ))
	(start-button (make-instance 'push-button :label "Start" :width 180))
	(cont-button (make-instance 'push-button :label "Continue" :width 180))
	
	
	
	)


    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)


    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15) 
		:bottom 15
		:action `(lambda ()
			   (deactivate-display planning::*verbose-disp*)
			   (close-display planning::*planner-window*)
			   (close-display planning::*node-info-window*)
			   (setf *quit* t)
			   (close-display ,disp)))

    (set-button help-button disp :left 15 :bottom 15)
    

    (set-button start-button disp 
		:left (round (+ 15
				(width start-button)
				(/ (- (width disp)
				      30
				      (* 4 (width start-button)))
				   3)))
		:bottom 15
		:action
		#'(lambda ()
		    (disable-button exit-button)
		    (auto-handler nr disp start-button cont-button exit-button)))
		
    (set-button cont-button disp 
		:left (round (+ 15
				(* 2 (width start-button))
				(* 2 (/ (- (width disp) 
					   30 
					   (* 4 (width start-button)))
					3))))
		:bottom 15
		:action 
		#'(lambda ()
		    (disable-button exit-button)
		    (setf *pause* (not *pause*))))
    (disable-button cont-button)

    
    (setf pail-lib::*stop-demo* nil)
    (software-push start-button)
    (software-push exit-button)
    
		    
    

    ))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
