;;; -*- Mode: LISP; Package: RULES; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   backward-rules-init.cl
;;; Short Desc: initialize global variables for bc
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   18.6.92
;;; Author:     FFA and DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
 

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rules)

;(defvar *movie-window* nil)
(defvar *param-display* nil)
(defvar *execution-terminated* nil)
;(defvar *multiple-value-goal* nil)
;(defvar *multiple-values* nil)

(defparameter *limit* 400)
(defparameter *default-planner-font* (open-font-named "5x8"))

(defvar *known-rank-fns* '(norank))
(defvar *backward-chainer* t)
(defvar *planner-window* nil)
(defvar *node-info-window* nil)
(defvar *bc-loaded* nil)

(defparameter *backchainer*
    (planning:make-planner
     :next-states-fn 'strips::achieve-one-goal-bc
     :goal-p-fn 'strips::complete-plan-p
     :plan-init-fn 'strips::init-bc-proof
     :default-search-fn search::*depth-first-search*
     :graph-fn 'strips::display-backchain-proof
     :rank-fns '(strips::norank)
     :default-rank-fn 'strips::norank))

(setq planning::*current-planner* *backchainer*)


(setq snlp::*tweak-planner* nil)




(defvar planning::*verbose* *verbose-default*)
(defvar planning::*verbose-disp* nil)
(defvar planning::*which-planner* *backchainer*)
(defvar planning::*which-rank* nil)
(defvar planning::*which-search* search::*depth-first-search*)
(defvar planning::*planning-loaded* nil)
(defvar planning::*param-display* nil)
(defvar planning::*world* nil)
(defvar planning::*movie-window* nil)

(setq planning::*which-planner* *backchainer*)
(setq planning::*which-rank* nil)
(setq planning::*which-search* search::*depth-first-search*)
(setq planning::*known-rank-fns* '(norank))
;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
