;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   cky-demo1.cl
;;; Short Desc: First demo on chart parsing
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :cky)


;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defun demo-1 ( )
  (setq *open-windows* nil)
  (setq *demo-in-execution* 1)
  (setq *grammar* nil)
  (setq *lexicon* '(nil))
  (format-display-fill demo-text-disp  (format nil
					       "This is the first CKY demo based on the example 
given in \"Preliminary Analysis of a Breadth-First 
Parsing algorithm: Theoritical and Experimental Results\" by
Martin, Church, and Patil."))
  (when (wait)
    (format-display-fill demo-text-disp (format nil
						"A CKY parser is
a context-free parser which takes as input a grammar and a sentence
and produces as output a chart of labeled phrases."))
    (when (wait)
      (format-display-fill demo-text-disp (format  nil 
						   "A labeled phrase is a sequence of words delimited by two brackets and labeled
 with a category symbol. Let the triple <i,j,c> denote a phrase of category
c spanning the words between ith position and the jth position. This triple
 will be represented in a two-dimensional matrix in which the entry
i,j contains the category symbol c."))
      (when (wait)
	(format-display-fill demo-text-disp (format  nil  "
To run the CKY parser we need to load the CKY tool."))
	(when (wait)
	  (parser-tool)
	  (push *cky-disp* *open-windows*)
	  (protect-display *cky-disp* t)
	  (format-display-fill demo-text-disp  (format nil  "The sentence we want to parse 
is \"They are flying planes\". To parse a sentence we have to load a grammar first.
We do this by clicking on the <<Grammar Tool>> button"))
	  (when (wait)
	    (my-software-push *grammar-tool* *cky-disp*)
	    (push *gram-disp* *open-windows*)
	    (protect-display *gram-disp* t)
	    (format-display-fill demo-text-disp (format nil  "We load the grammar stored
in the file g0"))
	    (when (wait)
	      (my-software-push *load-grammar* *gram-disp*)
	      (format-display-fill demo-text-disp (format nil  "By clicking on the grammar tool <<OK>> button 
we acknowledge the selection made. The grammar tool is used to maintain grammars. "))
	      (when (wait)
		(my-software-push *exit-grammar* *gram-disp*)
		(format-display-fill demo-text-disp (format nil  "We then load the lexicon
which provides a mapping between words and categories."))
		(when (wait)
		  (my-software-push *lexicon-tool*  *cky-disp*)
		  (push *lex-disp* *open-windows*)
		  (protect-display *lex-disp* t) 
		  (format-display-fill demo-text-disp (format nil  "We load the lexicon stored
in the file l0"))
		  (when (wait)
		    (my-software-push *load-lexicon* *lex-disp*)
		    (format-display-fill demo-text-disp (format nil  "Now we close the lexicon tool. Remember
that if you want to make any changes to the lexicon file you should use this tool."))
		    (when (wait)
		      (my-software-push *exit-lexicon*  *lex-disp*)
		      (format-display-fill demo-text-disp (format nil  "As you may suspect there are many
options to the parser which are intended to give information on the execution of the algorithm. After clicking the 
<<Options>> button we select the <<Tracing Mode>>, <<Show Parse Tree>>, and <<Show Graphic Chart>>"))
		      (my-software-push *options* *cky-disp*)
		      (push *options-disp* *open-windows*)
		      (sleep 2)
		      (my-software-push *show-chart-but*  *options-disp*)
		      (my-software-push *show-trees-but*  *options-disp*)
		      (when (wait)
			(my-software-push *options-exit* *options-disp*)
			(format-display-fill demo-text-disp (format  nil  "Now, we click on parse sentence. On the scrollable
parser tool window you will see the trace of the matching activity. The chart window will contain a graphical representation of
the matrix. Each cell contains the possible reductions. The results, if any, will be displayed in the cell chart[0,length of string], in this
case then in cell chart[0,4].
~%
You will guide the algorithm by clicking on the active words.
~%
After clicking on the last word the parser returns two solutions which are then diplayed in the form of a parse tree. Both
the chart cells and scrollable display show the possible combinations of the substrings (subsentences)."))
			(when (wait)
			  (setq *current-sentence* '(they are flying planes))
			  (my-software-push *parse-sentence* *cky-disp*)
			  (push  *graph-chart-disp*   *open-windows*)
			  (format-display-fill demo-text-disp  (format nil  "That's all folks!!!"))
			  (when (wait) 
			    (close-browsers)
			    (close-display  *graph-chart-disp*)
			    (my-software-push *exit-cky* *cky-disp*)
			    (close-display *cky-disp*)))))))))))))))


