;;; -*- Mode: LISP; Package: cky; Parstax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   cky-parser-dialog.cl
;;; Short Desc: CKY parser: user interface
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   18.7.92 - FB
;;; Author(s):  Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; Rod Johnson wrote a character oriented version of the interface
;;; Fabio Baj  wrote  the graphic user interface
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :cky)

;;GUI variables-------------------------------
;;==============================================================
(defvar *cky-disp*) (defvar *cky-msg-disp*)    (defvar *cky-subdisp*)        
(defvar *grammar-tool*)    (defvar *lexicon-tool*)  (defvar   *exit-cky* )  
(defvar *new-sentence*)    (defvar *parse-sentence*)     
(defvar *options*)    (defvar *choose-parser*)     
(defvar *send-to-file*)    (defvar *help-parser*)  
(defvar *env-info*)   
(defvar *next-step*) (defvar *open-browsers*)
(defvar *cky-disp-width*)(defvar *cky-disp-height*)
(defvar *cky-disp-left*)(defvar *cky-disp-bottom*)
(defvar *cky-subdisp-width*)(defvar *cky-subdisp-height*)
(defvar *cky-msg-disp-width*)(defvar *cky-msg-disp-height*)
(defvar *cky-subdisp-left*)(defvar *cky-subdisp-bottom*)
(defvar *sentence-but-list* )
(defvar *button-count*)
(defvar *button-step*)
(defvar *all-msg-subdisp-height* )
(defvar *open-windows*)

;;--------



;;=============   CKY PARSE TREES =========================
(defclass parse-tree (tree) ())

(defmethod label ((tree  parse-tree))(content tree))

 (defun sexpr-to-parse-tree (sexpr)
  (if (atom sexpr)
      (make-instance 'parse-tree :content sexpr)
    (make-instance 'parse-tree
      :content (car sexpr)
      :descendants (mapcar (function sexpr-to-parse-tree) (cdr sexpr)))))

(defun prtree (CkyTable)
  (let ((n 0))
    (setq *open-browsers* nil)
    (mapcar 
     #'(lambda (parse)
	 (incf n)
	 (push 
	  (make-instance 'browser
	   :title (format nil "Parse ~D" n)
	   :starting-tree (sexpr-to-parse-tree parse)
	   :left (+ (scalew  100) (* (scalew 40) n))
	    :bottom (* (scaleh 40) n))
	  *open-browsers*))
     CkyTable)))

(defun close-browsers()
  (mapcar #'(lambda (b)(close-browser b)) *open-browsers*))

;;=============   CKY variables =========================
(defvar *gfile*)(defvar *parser*) (defvar *previuo (setq *open-browsers* nil)s-parser*)
 (defvar *pars-features* nil) (defvar lookahead) 
(defvar *current-sentence*)(defvar *quiet*)


(defun init-parser-tool()
  (init-sizes)
  (setq *open-browsers* nil)
   (setq *open-windows* nil)
    (setq gin::*default-display-border* 1)
  (if (not (boundp '*parser* )) (setq *parser* "cky"))
  (setq *previous-parser*  *parser*)
  (choose-parser-init)
  (if (not (boundp '*grammar*))  (setq *grammar* nil))
  (if (not (boundp '*lexicon* )) (setq *lexicon* '(nil)))
  (if (not (boundp '*current-sentence*))(setq *current-sentence* nil))
  (if (not (boundp '*quiet*)) (setq *quiet* nil))
  (if (or (not (boundp '*initial*)) (null *initial*))
      (setq *initial* (list 's)))
  (setf *cky-disp-width*  (if (small-screen) (scalew 850)(scalew 650)))  
  (setf *cky-disp-height* (scaleh 450))
  (setf *cky-disp-left*  (scalew 340))   (setf *cky-disp-bottom* (scaleh 100))
  (setf *cky-subdisp-width*   (if (small-screen)(scalew 650)(scalew 450)))
  (setf *cky-msg-disp-width*  *cky-disp-width* )  (setf *cky-msg-disp-height* (scaleh 50))
  (setf *cky-subdisp-height* (- *cky-disp-height* (+ 36 *cky-msg-disp-height*)))
  (setf *cky-subdisp-left*   (- *cky-disp-width*  *cky-subdisp-width*) )
  (setf *cky-subdisp-bottom* (+ 18 *cky-msg-disp-height* ))
  (setf *left-of-buttons* (scalew  20)) (setf *size-of-buttons* (scalew 160))
  (setf *grammar-tool* (make-instance 'push-button :font (my-findfont 13)
				      :width *size-of-buttons* :label "Grammar Tool"))
  (setf *env-info* (make-instance 'push-button :font (my-findfont 13)
				  :width *size-of-buttons* :label "Information"))
  (setf *lexicon-tool* (make-instance 'push-button :font (my-findfont 13)
				      :width *size-of-buttons* :label "Lexicon Tool"))
  (setf *new-sentence* (make-instance 'push-button :font (my-findfont 13)
				      :width *size-of-buttons* :label "New Sentence"))
  (setf *parse-sentence* (make-instance 'push-button :font (my-findfont 13)
					:width *size-of-buttons* :label "Parse Sentence"))
  (setf *options* (make-instance 'push-button :font (my-findfont 13)
				 :width *size-of-buttons* :label "Options"))
  (setf *exit-cky* (make-instance 'push-button :font (my-findfont 13)
				  :width *size-of-buttons* :label "Exit"))
  (setf *choose-parser* (make-instance 'push-button :font (my-findfont 13)
				       :width *size-of-buttons* :label "Choose Parser"))
  (setf *send-to-file* (make-instance 'push-button :font (my-findfont 13)
				      :width *size-of-buttons* :label "Send to File"))
  (setf *help-parser*  (make-instance 'help-button :width *size-of-buttons*
				      :label "Help" :font (my-findfont 13)
				      :subject "Chart Parsing" 
				      :technical
				      (add-path "cky-help1.tec" (add-subdir *pail-path* "cky"))
				      :general 
				      (add-path "cky-help1.gen" (add-subdir *pail-path* "cky"))))
  )
	

(defun parser-tool()
  (init-parser-tool) (option-menu-init)
  (setf *cky-disp* (make-instance 'display :title "CKY: Parser Tool" :width *cky-disp-width* :height  *cky-disp-height* 
				 :font (my-findfont 13)   :left *cky-disp-left* :bottom *cky-disp-bottom*))
  (push *cky-disp* *open-windows*)
  (setf *cky-subdisp* (make-instance 'scroll-display  :parent *cky-disp*  :font (my-findfont 10) 
				     :title (concatenate 'string
					      "Using Parser: " *parser*)
				     :width *cky-subdisp-width* :height  *cky-subdisp-height* 
				     :left *cky-subdisp-left*  
				     :bottom  *cky-subdisp-bottom*))
  (setf *cky-msg-disp* (make-instance 'scroll-display  :parent *cky-disp* :font (my-findfont 10) 
				      :title "CKY: Messages " :width *cky-msg-disp-width* 
				      :height  *cky-msg-disp-height* 
				      :left 0
				      :bottom 0 ))
  (loadparser)
  
  (reset-b-f 10 (height *cky-subdisp*))
  (set-button *env-info* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f) :action '(lambda nil 
						(protect-display  *cky-disp* t)
						(env-info)
						(reset-button *env-info*) 
						(protect-display  *cky-disp* nil)
				      ))
 
 (set-button *help-parser* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f))
  (set-button *exit-cky* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f) :action '(lambda nil (close-display *cky-disp*) 
				      (setq  *execution-terminated* t)
				      (mapcar #'(lambda (d)(close-display d))
							*open-windows*)))
 ; (set-button *send-to-file* *cky-disp* :left  *left-of-buttons*
	;      :bottom (b-f) :action '(lambda nil ()))
  (set-button *choose-parser* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f) :action '(lambda nil 
				      (protect-display  *cky-disp* t)
					       (if (eq (choose-parser) 'parser-changed)
						   (loadparser))
					       (initialise)
					       (reset-button *choose-parser*) 
				      (protect-display  *cky-disp* nil)
				      ))
  
  (set-button *options* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f) :action '(lambda nil 
					       (protect-display  *cky-disp* t)
					       (options-menu)
					       (protect-display  *cky-disp* nil)
					       (reset-button *options*)))
  (set-button *parse-sentence* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f) :action'(lambda nil 
				     (protect-display  *cky-disp* t)
				     (if(and (boundp '*gram-disp*) (active *gram-disp*)) 
					 (protect-display  *gram-disp* t))
				       (if (and (boundp '*lext-disp*)(active *lex-disp*))
					   (protect-display  *lex-disp* t))
				     (clear-scroll *cky-subdisp*)
				     (initialise)
				     (if(and  *show-chart* *current-sentence*
					 *parse-sentence* *grammar* *lexicon* *parser*)
					 (graph-chart-init))
				     (analyse *current-sentence*)
				     (reset-button *parse-sentence*)
				     (protect-display  *cky-disp* nil)
				     (if (and (boundp '*gram-disp*)(active *gram-disp*))
					  (protect-display  *gram-disp* nil))
				     (if  (and (boundp '*lex-disp*)(active *lex-disp*))
					 (protect-display  *lex-disp* nil))))
  
  (set-button *new-sentence* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f)
	      :action '(lambda ()(get-new-sentence)
			(reset-button *new-sentence* )))
  (set-button *grammar-tool* *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f )
	      :action '(lambda nil 
			;(protect-display  *cky-disp* t)
			(grammar-tool)
			(reset-button *grammar-tool*)
			;(protect-display  *cky-disp* nil)
			))
  (set-button *lexicon-tool*  *cky-disp* :left  *left-of-buttons*
	      :bottom (b-f) :action '(lambda nil
					       ;(protect-display  *cky-disp* t)
					       (lexicon-tool)(reset-button *lexicon-tool*)
					      ; (protect-display  *cky-disp* nil)
))
  
  (if (boundp '*parser*) (progn (clear-scroll *cky-subdisp*))))


;;;===========================================================================



;;========================================================
;; This routine reads  new sentence from the user

(defun get-new-sentence ()
  (let ((new-sent  (ask  "Please enter a new sentence:
"                        :font (my-findfont 13)
			 :title "CKY" :left (scalew 200) :bottom (scaleh 400)

			 :width (scalew 600)
			 :height (scaleh  150)))
	)
    (if (not (string= "" new-sent))
	(progn
	  (setq *current-sentence* 
	    (mapcar #'(lambda (x)(to-symbol x)) (scan-string new-sent)))))))
 

;;;;=============================================================
		


;;;===========================================================================
;; DIALOG BOX TO SELECT A  PARSING ALGORITHM
;; DECLARATIONS

(defvar *using-parser-cky*)(defvar *using-parser-ckydot*)
(defvar *using-parser-ckyre*)(defvar *using-parser-ckypr*)
(defvar *using-parser-ckyla*)(defvar *using-parser-ckypl*)


;;Assume che la variabile *parser* sia gia` inizializzata 
(defun update-parser-variables()
  (if    (string= *parser* "cky")   (setq  *using-parser-cky* t  ))
  (if    (string= *parser* "ckydot") (setq  *using-parser-ckydot* t ))
  (if    (string= *parser* "ckyre")  (setq  *using-parser-ckyre* t))
  (if    (string= *parser* "ckypr")  (setq  *using-parser-ckypr* t))
  (if    (string= *parser* "ckyla")  (setq  *using-parser-ckyla* t))
  (if    (string= *parser* "ckypl")  (setq  *using-parser-ckypl* t)))

(defun choose-parser-init ()
  (setq *using-parser-cky* nil)   (setq *using-parser-ckydot* nil)
  (setq *using-parser-ckyre* nil)  (setq *using-parser-ckypr* nil) 
  (setq *using-parser-ckyla* nil) (setq *using-parser-ckypl* nil)
  (update-parser-variables)
  (setq *previous-parser* *parser*))


(defvar *exit-choose-parser* nil)
(defvar *using-parser-cky-button* nil)
(defvar *using-parser-ckydot-button* nil)
(defvar *using-parser-ckyre-button* nil)
(defvar *using-parser-ckypr-button* nil)
(defvar *using-parser-ckyla-button* nil)
(defvar *using-parser-ckypl-button* nil)
(defvar *choose-parser-disp* nil)

(defun choose-parser ()
  (choose-parser-init)
  (let ((choose-parser-done nil))
    (setq *choose-parser-disp* 
      (make-instance 'display   :font (my-findfont 13)
		     :height (scaleh  250) :width (scalew 550)
		     :left *cky-disp-left* :bottom *cky-disp-bottom*
		     :title "Available Parsing Algorithms"))
    (setq *exit-choose-parser* 
      (make-instance 'push-button :font (my-findfont 13)
		     :width *size-of-buttons* :label " OK "))
    (setq *using-parser-cky-button* 
      (make-instance 'radio-button  :font (my-findfont 13)
		     :value nil :status *using-parser-cky*  :label "Basic CKY parser"))
    (setq *using-parser-ckydot-button* 
      (make-instance 'radio-button  :font (my-findfont 13)
		     :value nil :status *using-parser-ckydot*  :label "With Dotted Rules"))
    (setq *using-parser-ckyre-button* 
      (make-instance 'radio-button :font (my-findfont 13)
		     :value nil :status *using-parser-ckyre* :label "With Dotted Rules and REGEXP rhs"))
    (setq *using-parser-ckypr-button* 
      (make-instance 'radio-button :font (my-findfont 13)
		     :value nil :status *using-parser-ckypr* :label "With Earley-style Prediction"))
    (setq *using-parser-ckyla-button* 
      (make-instance 'radio-button  :font (my-findfont 13)
		     :value nil :status *using-parser-ckyla* :label "With Lookahead"))
    (setq *using-parser-ckypl-button* 
      (make-instance 'radio-button  :font (my-findfont 13)
		     :value nil :status *using-parser-ckypl* :label "With Earley-style prediction and lookahead"))
    (push *choose-parser-disp*  *open-windows*)
    
    (put-contextual-help-button *choose-parser-disp*  )
    
    (set-button *exit-choose-parser* *choose-parser-disp* 
		:left  (- (width *choose-parser-disp*) *size-of-buttons*  *left-of-buttons*)
		:bottom (scaleh  10)
 :action #'(lambda nil(close-display *choose-parser-disp*)(setf choose-parser-done t)))
    ;;
 ;;; RADIO BUTTONS============================================================
    (reset-b-f 6 (- (height *choose-parser-disp* )(scaleh 100)))
    (set-button *using-parser-ckypl-button* *choose-parser-disp*
		:left (scalew 10)
		:bottom (b-f)
		:action #'(lambda nil
			    (if (status *using-parser-ckypl-button*)
				(progn  (update-contextual-help "ckypl" *choose-parser-disp*)(setq *parser* "ckypl")))
			    (setf *using-parser-ckypl*
			      (status *using-parser-ckypl-button*))))
    (set-button *using-parser-ckyla-button* *choose-parser-disp*
		:left (scalew  10)
		:bottom (b-f)
		:action #'(lambda nil
			    (if (status *using-parser-ckyla-button*)
				(progn 
				  (update-contextual-help "ckyla" *choose-parser-disp*)(setq *parser* "ckyla")))
			    (setf *using-parser-ckyla*
			      (status *using-parser-ckyla-button*))))
    (set-button *using-parser-ckypr-button* *choose-parser-disp*
		:left (scalew  10)
		:bottom (b-f)
		:action #'(lambda nil
			    (if (status *using-parser-ckypr-button*)
				(progn 
				  (update-contextual-help "ckypr" *choose-parser-disp*)(setq *parser* "ckypr")))
			    (setf *using-parser-ckypr*
			      (status *using-parser-ckypr-button*))))
    (set-button *using-parser-ckyre-button* *choose-parser-disp*
		:left (scalew  10)
		:bottom (b-f )
		:action #'(lambda nil
			    (if (status *using-parser-ckyre-button*)
				(progn
				  (update-contextual-help "ckyre" *choose-parser-disp*) (setq *parser* "ckyre")))
			    (setf *using-parser-ckyre*
			      (status *using-parser-ckyre-button*))))
    (set-button *using-parser-ckydot-button* *choose-parser-disp*
		:left (scalew  10)
		:bottom (b-f)
		:action #'(lambda nil
			    (if (status *using-parser-ckydot-button*)
				(progn 
				  (update-contextual-help "ckydot" *choose-parser-disp*)(setq *parser* "ckydot")))
			    (setf *using-parser-ckydot*
			      (status *using-parser-ckydot-button*))))
    (set-button *using-parser-cky-button* *choose-parser-disp*
		:left (scalew  10)
		:bottom (b-f)
		:action #'(lambda nil
			    (if (status *using-parser-cky-button*)
				(progn 
				  (update-contextual-help "cky" *choose-parser-disp*)(setq *parser* "cky")))
			    (setf *using-parser-cky* (status *using-parser-cky-button*)))) 
    
    (disable-button *using-parser-ckyre-button*) 
    (disable-button *using-parser-ckypr-button*  )
    (disable-button *using-parser-ckyla-button*  ) 
    (disable-button *using-parser-ckypl-button* )
    
    (set-exclusive *using-parser-cky-button* *using-parser-ckydot-button* 
		   *using-parser-ckyre-button*  *using-parser-ckypr-button*
		   *using-parser-ckyla-button* *using-parser-ckypl-button*)
    (unless *demo-in-execution*
      (mp:process-wait " OK-choosen "   #'(lambda nil choose-parser-done)))
    (if (not (string= *parser* *previous-parser*)) 'parser-changed)))
      

(defun loadparser ()
  (setf (title *cky-subdisp* )
	(concatenate 'string  "Using Parser: " *parser*)))


(defun put-contextual-help-button(d)
  (setf *choose-parser-help*
	  (make-instance 'help-button :label "Help"
			 :width *size-of-buttons*   :font (my-findfont 13)
			 :subject "Chart Parsing"
		   	 :technical
			 (add-path "choose-help.tec" (add-subdir *pail-path* "cky"))
			 :general 
			 (add-path (doc-file-of-parser *parser*) (add-subdir *pail-path* "cky"))))
  (set-button *choose-parser-help* d
	      :left  *left-of-buttons* :bottom (scaleh 10)))
	     
(defun doc-file-of-parser(parser)
  (if    (string= parser "cky") "ckyAlg.gen"
    (if    (string= parser "ckydot")  "ckydotAlg.gen"
      (if    (string= parser "ckyre") "ckyreAlg.gen"
	(if    (string= parser "ckypr")  "ckyprAlg.gen"
	  (if    (string= parser "ckyla")  "ckylaAlg.gen"
	    (if    (string= parser "ckypl")  "ckyplAlg.gen")))))))

(defun update-contextual-help( parser d )
 (if (not (string= *parser* parser))
     (let ((filename (doc-file-of-parser parser))) 
       (unset-button   *choose-parser-help*)
       (setf *choose-parser-help*
	 (make-instance 'help-button :label "Help"  :font (my-findfont 13)
			:width *size-of-buttons* 
			:subject "Chart Parsing"
			:technical (add-path "cky-help1.tec" (add-subdir *pail-path* "cky"))
			:general     (add-path filename (add-subdir *pail-path* "cky"))))
       (set-button *choose-parser-help* d
		   :left  *left-of-buttons* :bottom 10))))     
;;=============================================================

(defun analyse (sent)
  (cond ((not (and sent *grammar* *lexicon* *parser*))
         (cond ((null sent) 
		(acknowledge-dialog
		 (format nil "First type in a sentence~% (use New Sentence)"))))
         (cond ((equal *lexicon* '(nil))
		(acknowledge-dialog  "There is nothing in the lexicon")))
	 (cond ((null *grammar*)
		(acknowledge-dialog "There are no grammar rules"))))
       	(t
	 (format-display *cky-subdisp* "STARTING PARSER ~%")
	 (setq *chart* nil)
	 (let ((CkyTable nil))
	   (parse sent)
	   (setq CkyTable (cky-answer))
	   (cond ((not *quiet*)
		  (format-display *cky-subdisp* "NUMBER OF PARSES: ~D" (length CkyTable))
		  (cond ((> (length CkyTable) 0)  (if *show-trees* (prtree CkyTable))))))
	   (chartstats)
	   (if(not *demo-in-execution*)(progn 
	   (if (and  *show-trees* *show-chart* )
	       (acknowledge-dialog  " Closing Parse Trees and Chart ")
	     (progn
	       (if *show-trees* (acknowledge-dialog  " Closing Parse Trees"))
	     (if *show-chart* (acknowledge-dialog  " Closing Chart"))))
	   (if *show-trees*  (close-browsers))
	   (if *show-chart* (close-display  *graph-chart-disp*))
	   ))))))
;;;====================================================================


;;;==================================================



;;===================================================


;;============================================
;; CKY PARSER OPTIONS MENU
(defvar *options-disp*)
(defvar *options-disp-h*)
(defvar *options-disp-w*)
(defvar *options-disp-l*)
(defvar *options-disp-b*)

(defvar *options-exit*)
(defvar *options-help*)
(defvar *treat-input-but*)
(defvar *verbose-but*)
(defvar *trace-but*)
(defvar *show-trees*)
(defvar *show-chart*)
(defvar *trace*)
(defvar *treat-input-as-char*)


(defun option-menu-init ()
 (setf *options-disp-h* (scaleh 300))
  (setf *options-disp-w* (scalew 400))
  (setf *options-disp-l* (scalew  200))
  (setf *options-disp-b* (scaleh 300))
  (setf *treat-input-as-char* nil)
  (setf *verbose* nil)(setf *show-trees* nil)
  (setf  *options-exit* (make-instance 'push-button  :font (my-findfont 13) :width *size-of-buttons*  :label " OK "))
  (setf  *options-help* (make-instance 'help-button :width *size-of-buttons*
				      :label "Help" :font (my-findfont 13)
				      :subject "Chart Parsing Options" 
				      :technical
				      (add-path "cky-help2.tec" (add-subdir *pail-path* "cky"))
				      :general 
				      (add-path "cky-help2.gen" (add-subdir *pail-path* "cky"))))
	
 (setf *show-chart* nil)(setf *trace* nil)
  (setf *treat-input-but* 
    (make-instance 'radio-button :label "Treat input as character string"  
		   :font (my-findfont 13)  :status *treat-input-as-char*  :value nil))
  (setf *trace-but* 
    (make-instance 'radio-button :label "Trace Execution"  
		    :font (my-findfont 13) :status *trace*  :value nil))
  (setf *show-chart-but* 
    (make-instance 'radio-button :label "Show graphic Chart"  
		    :font (my-findfont 13) :status *show-chart*  :value nil))
 (setf *show-trees-but* 
    (make-instance 'radio-button :label "Show Parse Trees"  
		   :font (my-findfont 13)  :status *show-trees*  :value nil))
  (setf *verbose-but* (make-instance 'radio-button :label "Verbose Output"  
		    :font (my-findfont 13)   :status *show-chart*  :value nil)))

(defun options-menu()
  (let ((done nil))
    (setf *options-disp* 
      (make-instance 'display  :title "CKY: Tool Options"
		    :font (my-findfont 13)   :width *options-disp-w* :height  *options-disp-h* 
		    :left  *options-disp-l* :bottom *options-disp-b*))
    (push *options-disp* *open-windows*)
(reset-b-f 5(- (height    *options-disp* ) 90))
  (set-button *treat-input-but*  *options-disp* :left 10 :bottom ( b-f)
		:action '(lambda nil  (setf *treat-input-as-char* (status *treat-input-but* ))) )
    (set-button *show-chart-but*   *options-disp* :left 10 :bottom ( b-f)
		:action #'(lambda nil
			    (if (and (status *show-chart-but* )
				     (not (status *trace-but* )))
				(toggle-button *trace-but*))
			    (setf *show-chart* (status *show-chart-but* ))))
    (set-button *show-trees-but*   *options-disp* :left 10 :bottom ( b-f)
		:action #'(lambda nil  (setf *show-trees* (status *show-trees-but* ))))
    (set-button *trace-but*   *options-disp* :left 10 :bottom ( b-f)
		:action #'(lambda nil 
			     (if  (and (not (status *trace-but* ))
				       (status *show-chart-but*))
				 (toggle-button *show-chart-but*))
			     (setf *trace* (status *trace-but* ))))
    (set-button *verbose-but*   *options-disp* :left 10 :bottom ( b-f)
		:action #'(lambda nil  (setf *verbose* (status *verbose-but* ))))
    (set-button *options-help* *options-disp* :left 10 :bottom 10)
    (set-button *options-exit* *options-disp* 
		:left (- *options-disp-w* *size-of-buttons* 10) :bottom 10
		:action #'(lambda nil 
			    (close-display  *options-disp* )
			    (setf done t)))
    (if (not *demo-in-execution*) (mp:process-wait "Exit"   #'(lambda nil done)))))




;;;;=============================================================

(defun env-info()
  (let* ((r-disp (make-instance 'display   :left (scalew 450) :bottom (scaleh 500)
				:width (scalew 500) :height (scaleh 200)   :font (my-findfont 10)
				:title "CKY: Current Environment"))
	 (ok (make-instance 'push-button   :font (my-findfont 13) :label "   OK   "))
	 (done nil)
	 (h (height r-disp))
	 (stringlist
	  (list 
	   (concatenate 'string "Parsing Algorithm...... "
			(cond (*using-parser-cky* (format nil "Basic CKY parser"))
			      ( *using-parser-ckydot*(format nil "CKY with Dotted Rules"))
			      ( *using-parser-ckyre*(format nil "Dotted Rules + Regular Expressions rhs"))
			      (*using-parser-ckypr*(format nil "CKY with Earley-style prediction"))
			      (*using-parser-ckyla*(format nil "CKY with Lookahead"))
			      (*using-parser-ckypl*(format nil "Earley-style + Lookahead"))))
	   (concatenate 'string "Current Grammar........ "(if *grammar* *grammar-filename* "None"))
	   (concatenate 'string "Current Lexicon........ "(if (equal *lexicon* '(nil))
							      "None" *lexicon-filename*))
	   (concatenate 'string "Current Sentence....... "
			(if *current-sentence*  (s-t-str   *current-sentence* )  "None"))
	   (concatenate 'string "Parse Trees Display.... "(if *show-trees* "Enabld" "Disabled"))
	   (concatenate 'string "Tracing................ "(if *trace* "Enabled" "Disabled"))
	   (concatenate 'string "Graphic Chart.......... "(if *show-chart* "Enabled" "Disabled")))))
    (dolist (s stringlist)
      (write-display    r-disp s (scalew 5) (setq h(- h (scaleh 20)))))
    (set-button ok r-disp :left(- ( width r-disp) (scalew 100)) :bottom (scaleh 10) 
		:action (function (lambda ()(setf done t)
					  (close-display r-disp))))
    (mp:process-wait "Exit1"   #'(lambda nil done)))
)

(defun s-t-str (l)
  (trunk-string
    (string-trim "()" (format nil  "~A" l )) 25))

  (defun trunk-string (s n)
  (let ((sl (coerce s 'list)))
    (if (> (length s) n)
     (concatenate 'string
       (coerce (trunc-stl sl (- n 3)  nil) 'string)
       "...")
     (coerce (trunc-stl sl n  nil) 'string))))
 
(defun trunc-stl (sl n result)
  (if (or (null sl)(zerop n))(reverse result)
    ( trunc-stl (cdr sl) (1- n) (cons (car sl )result)))) 
     
