
(defun dest-insert (elem list fun flag )
  (cond ((null list) (list elem))
	(t (d-insert elem list fun ) list)))
 
(defun d-insert (elem list fun)
  (cond ((null (cdr list))
	 (cond  ((not(funcall fun  elem (car list)))
		 (setf (cdr list)(list elem)))
		(t (setf (cdr list)(list (car list)))
		   (setf (car list) elem))))
	((funcall fun  elem (cadr list))
	 (setf (cdr list) (copy-tree list))
	 (setf (car list) elem))
	(t (d-insert elem (cdr list) fun ))))


(defun assq (x y)(assoc x y :test #'eq))

(defun aexplodec (a)(coerce (string a) 'list))
(defun ucons (element set)
  (cond ((member element set)
         set)
        (t (cons element set))))

(defun alphalessp (x y)(char< x y))

     

(defun scan-string (st)
  (delall-cky   "" (scan-aux-cky (coerce st 'list) nil)))
(defun delall-cky (x l)
    (cond ((null l) nil)
          ((string=  x (car l)) (delall-cky x (cdr l)))
          (t(cons (car l) (delall-cky x (cdr l))))))



(defun word-cky (lch)
   (trim-word-cky lch nil))

(defun trim-word-cky (lch  aux)
  (cond ((null lch)
	 (list (coerce (reverse aux) 'string)))
	((member (car lch)  *separators*)		
	 (cons (coerce (reverse aux) 'string) (cdr lch )))
	(t (trim-word-cky (cdr lch) (cons (car lch) aux)))))


(defun scan-aux-cky (lch aux)
    (cond ((null lch) (reverse aux))
          (t (let (( next-token  (word-cky lch)))
	       (scan-aux-cky (cdr next-token) 
			 (cons (car next-token) aux))))))


(defun no-blanks (s)
  (coerce (remove #\ (coerce s 'list)) 'string))


;;;+++++++++++++++++++++++++++++++++++++++=
;; Graphics


(defun acknowledge-dialog (query &key (title "Please Click"))
  (let* ((font (my-findfont 13))
	 (dw (make-instance 'display  :font font  
	       :width (if (> (cw::font-string-width font  query)(scalew  185))
			  (+ (cw::font-string-width font  query)(scalew 20))(scalew  205))
	       :left (scalew 100)
	       :bottom (scaleh 500)
	       :height (scaleh 160)
	       :title title))
	 (done nil)
	 (yb (make-instance 'push-button :label "   OK   " :font font  )))
    (write-display dw query (scalew 10)(scaleh  90))
    (set-button yb dw :left (- (width dw) (scalew 120)) :bottom (scaleh 4 ):action (function (lambda (&rest cw-internals)
											       (declare (ignore cw-internals))
											       (setf done 'continue))))
    (mp:process-wait "exit"   #'(lambda nil done)) 
    (close-display dw)
    done))

	     
(defun reset-b-f(n hei)
  (setf *button-count* 0)
  (setf *button-step* (floor  (/ hei n))))

(defun b-f()
  (incf  *button-count*)
  (+ *all-msg-subdisp-height*   (* *button-step* *button-count*)))
