;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-dialog.cl
;;; Short Desc: dialog handling for Coinstraint Propagation
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.92 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
 
;;; --------------------------------------------------------------------------
 

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :csp)



;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================



(defparameter *number-of-demos* 2)
(defvar *verbose-disp* nil)
(defvar *execution-terminated* nil)
(defvar *demo-in-execution*)

;;--------------------------------
(defvar *csp-main-window*)
(defvar *csp-mw-width*)
(defvar *csp-mw-height*)
(defvar *csp-mw-left*)
(defvar *csp-mw-bottom*)

(defvar *but-width*)
(defvar *but-height*)
(defvar *gph-left*)
(defvar *gph-bottom*)
(defvar *gph-width*)

(defvar *rd-but-width*)
(defvar *rd-but-height*)

(defvar *out-win*)
(defvar *out-win-height*)
(defvar *out-win-width*)
(defvar *out-win-left*)
(defvar *out-win-bottom*)

(defvar *domain-loaded*)
(defvar *open-windows* nil)

;;-----------------------------This holds the main network
(defvar *main-network*)
;;-----------------------------This holds the current net during search
(defvar  *searching-network*)
;;-----------------------------This is useful to close everything
(defvar *open-displays-list*)
(defvar *open-display-nets*)

;;----------This states wether there is a graphical interface
(defvar *csp-interface*)
;;------------------------------variables for radio buttons
(defvar *graphics*)
;;------------------------------variables for stepping
(defvar *stop-at-arc*)
(defvar *stop-at-sol*)
(defvar *stop-at-prop*)
(defvar *aborted*)
(defvar *paused*)
;;----------------------------Push buttons
(defvar *exit-button*)
(defvar *help-button*)
(defvar *continue-button*)
(defvar *clear-button*)
(defvar *solutions-button*)
(defvar *pause-button*)
(defvar *run-button*)
(defvar *abort-button*)
(defvar *load-button*)
(defvar *edit-button*)
;;----------------------------Radio buttons
(defvar *stop-at-arc-button*)
(defvar *stop-at-prop-button*)
(defvar *stop-at-sol-button*)
(defvar *verbose-button*)
(defvar *graph-button*)
(defvar *adv-button*)





;;==================================================================
;; THE CSP dialog


(defun init-sizes()
;;;Useful for testing:
;;; 2073x1687 to resize for a 600x480 screen
;;; 1670x1375 to resize for a screen less than 800x600
  (setq *original-screen-width* 1152)
  (setq *original-screen-height* 900)
;;------------------------------
  (setq *gph-left* 300)
  (setq *gph-bottom* 50)
  (setq *csp-mw-width*  600) 
  (setq *csp-mw-height* 500)
  (setq *csp-mw-left*  540) 
  (setq *csp-mw-bottom* 350)
  (setq *but-width* 86)
  (setq *but-height* 20)
  (setq *rd-but-width* 250)
  (setq *rd-but-height* 8)
  (setq *out-win-height*
    (round (* 0.7  *csp-mw-height*)))
  (setq *out-win-width* *csp-mw-width*)
  (setq *out-win-left* 0)
  (setq *out-win-bottom* (- *csp-mw-height* *out-win-height* 19)))


(defun start-csp-dialog (&optional (from-button nil))
   (init-sizes)
  (setq *demo-in-execution* nil)
  (excl:chdir *csp-path*)
  (let* ((disp (make-instance 'display :title "CSP:Main Dialog"
			      :width (scaleh 600)
			      :height (scaleh 250)
			      :borders 1
			      :left (scalew 200)
			      :bottom (scaleh 480)))
	 (menu-button (make-instance 'pop-up-button
			:label "Demos"
			:font (my-findfont 13)
			
			:width (scaleh 100)))
	 (exit-button (make-instance 'push-button :label "Exit" :font (my-findfont 13) :width (scaleh 70)))
	 (help-button (make-instance 'help-button :label "Help" :font (my-findfont 13) :width (scaleh 70)
				     :subject "CSP Module"
				     :technical (add-path "csp-desc-tec.asc" *csp-path*)
				     :general (add-path "csp-desc.asc" *csp-path*)))
	 (tool-button (make-instance 'push-button :label "Tool" :font (my-findfont 13) :width (scaleh 100)))
	 (menu (make-instance 'menu
		 :items  (let ((mlist nil))
			   (dotimes (i *number-of-demos* (nreverse mlist))
			     (setf mlist 
			       (cons (list (format nil "Demo ~a" (1+ i)) 
					   `(lambda () 
					      (demo ,(1+ i) ,menu-button 
						    ,exit-button ,tool-button ,disp))
					   (make-title (1+ i)))
				     mlist))))
		 
		 :font (my-findfont 13) :query " DEMOS ")))
    
    (setf (menu menu-button) menu)
    
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) (scalew 15))
	       (- (height disp) (cw:bitmap-height *pail-logo*) (scaleh 15)))
    
    (setf (font disp) (my-findfont 16.5 ))
    (write-display disp
		   "Welcome to ..."
		   (scalew 15) (- (height disp) (scaleh 15) (cw:font-ascent (font disp))))
    (setf (font disp)  (my-findfont  22))
    (write-display disp
		   "Constraint Propagation"
		   (scalew 20)
		   (- (height disp) (scaleh 80) (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) (scalew 15))
		:bottom (scaleh 25)
		:action `(lambda nil
			   (close-display ,disp)
			   (close-display *verbose-disp*)
			 ;  (sleep 1)
			   (if ,from-button (reset-button ,from-button))))
    
    (set-button tool-button disp
		:left (round  (/ (- (width disp) (width menu-button)) 2))
		:bottom (scaleh 25)
		:action `(lambda nil 
			   (disable-button ,exit-button)
			   (disable-button ,menu-button) 
			   (deactivate-display ,disp)            
			   (cspw) ;;this starts the CSP tool
			   (setq  *execution-terminated* nil)
			   (mp:process-wait "running" 
					    '(lambda nil *execution-terminated*))  
			   (activate-display ,disp)
			   ;(sleep 1)
			   (reset-button ,tool-button)
			   (enable-button ,exit-button)
			   (enable-button ,menu-button)))
    
    
    (set-button help-button disp
		:left (scalew 15) 
		:bottom (scaleh 25))
    
    
    (set-button menu-button disp 
		:left (round  (/ (- (width disp) (width menu-button))  2))
		:bottom (scaleh 65))
    disp))





;;====================================================================

