
(in-package :csp)

;;-------PRimitives for the graphic turtle

(defvar *angle* 0)
(defvar *pen* 'down)
(defvar *x* 0)
(defvar *y* 0)
(defvar *k*)
(defvar *x-o*)(defvar *y-o*)
(defconstant 2pi (* 2 pi))


(defun cls(disp) 
    (clear-display disp))

(defun set-scale (disp height x y)
  (setq *k*( / (height disp) height))
  (setq *x-o* (* *k*  x))
  (setq *y-o* (* *k* y)))
  

(defun move-to (disp  x y)
  (let ((old-x  *x*) 
	(old-y *y*))
    (setq  *x* (x x))
    (setq  *y* (y y))
    (if (eq *pen* 'down)(draw-line  disp   old-x old-y   (x x) (y y)))))
 ;;   (setq *angle* (atan (- old-x x) (- old-y y)))))

(defun move (disp length)
   (let ((old-x *x*)
	(old-y *y*)
	(t-length (* *k* length)))
     (setq  *x* (+ old-x (* t-length (cos *angle*))))
     (setq  *y* (+ old-y (*  t-length (sin *angle*))))
     (if (eq *pen* 'down)(draw-line disp   old-x  old-y *x*  *y*))))

(defun turn-to (angle)
  (setq *angle* angle))

(defun turn(angle)
  (setq *angle* (+ angle *angle*))
  (if( > *angle* ( * 2 pi))
      (setq *angle* (- *angle* (* 2 pi)))))


(defun penup()
  (setq *pen* 'up))

(defun pendown()
  (setq *pen* 'down))

    
(defun jump-to (disp x y)
  (penup)
  (move-to disp  x y)
  (pendown))
  
(defun jump (disp x)
  (penup)
  (move disp  x)
  (pendown))

(defun home()
  (setq *x* *x-o*)
   (setq *y* *y-o*)
  (turn-to 0))

(defun x (x)
  (+ (* *k* x) *x-o*)) 
(defun y (y)
  (+ (* *k* y) *y-o*))


;;;------------
;; Routines to draw pieces for the puzzle example

(defun goto-level( disp from to)
  (cond ((< from to)(turn (/ pi 2))
	 (move  disp (abs (- from to)))
	 (turn (-(/ pi 2))))
	((> from to)(turn (-(/ pi 2)))
	 (move disp (abs (- from to)))
	 (turn (/ pi 2)))))

(defun draw-side(disp pattern)
  (let ((cur-level 0))
    (move disp 2)
    (dolist (to-level pattern)
      (goto-level disp cur-level to-level)
      (move disp 1)
      (setq cur-level to-level))
    (goto-level disp cur-level 0)
    (move disp 2)))

(defun draw-piece (disp piece)
  (dolist (side (pattern piece))
    (draw-side disp side)
    (turn (- (/ pi 2)))))


	;;Provvisorio OKKIO
	; (car (possible-values (find-node (puzzle-variable-name row col)))))))))

(defun draw-piece-at(disp row col piece large)
 (jump-to  disp (gp-col disp col piece disp large)(gp-row disp row piece disp large))
  (turn-to 0)(draw-piece disp piece))
    
(defun gp-row (disp r  piece disp large)
  (let* ((distance(if large 5 2)) 
	 (p-sz (+ distance (length (pattern piece)))))
    (- (/(height disp)*k*) (* p-sz   r))))
(defun gp-col (disp c piece disp large)
  (let* ((distance(if large 5 2)) 
	 (p-sz (+ distance (length (pattern piece)))))
    (* p-sz  c)))

(defun puzzle-variable-name(row col)
  (intern (format nil "POS~A-~A" row col) :csp))
;;------------------------------------------------------------
;; This randomly 
(defun shuffle(l)
  (let ((list (copy-tree l)))
    (dotimes (x(length list) list) 
      (exchange list
		(random (length list))
		(random (length list))))))

(defun exchange (l p1 p2)
  (let  ((tmp (nth p1 l)))
    (setf (nth p1 l) (nth p2 l))
    (setf (nth p2 l)  tmp)))
    



;;--------------------------------
(defun pieces-per-side (pieces)
  (round (sqrt (length pieces))))

(defvar *piece-size* 50)

(defun piece-size(large)
  (if large (* (/ 9 6)*piece-size*)
   *piece-size*))

(defun piece-size-scaled(large)
  (if large 9 6))
;;;---------------------------------------

(defun fill-puzzle(disp pieces large)
  (let ((dimension 5)
	(result nil))
    (do ((row 1 (+ row 1)))
	((= row (1+ dimension)))
      (do ((col 1 (+ col 1)))
	  ((= col (1+ dimension)))
	(draw-piece-at  disp
	 row col 
	(pop pieces)
	large)))))

;;-----------------------------------------

(defun draw-puzzle (pieces large)
  (let ((disp
	 (make-instance 'display
	   :height (* (+ 2 (pieces-per-side pieces)) (piece-size large))
	   :width (* (+ 2 (pieces-per-side pieces)) (piece-size large))
	   :bottom 50 :left 200 :title "A Sample puzzle"))
	(puzzle-exit-button (make-instance 'push-button :label "Cancel")))
    (set-scale disp (* (piece-size-scaled large) (+ 2(pieces-per-side pieces))) 0 0)
    (fill-puzzle disp pieces large)
    (set-button puzzle-exit-button disp :left 20 :bottom 10
		:action #'(lambda nil(close-display disp)))))



;;-----------------------------------------

;;INTERFACE FUNCTIONS
;;-----------------------------------------

;;This shows an unsolved puzzle

(defun display-puzzle-to-do (pieces)
   (draw-puzzle (shuffle pieces) t))

;;--------------------------------------------------
;; this is the standard user-definable display-solutions
;; a solution is a constraint network
;;--------------------------------------------------
(defun DOMAIN-DEPENDENT-SHOW-SOLUTION (solution)
  (let* ((dimension (round (sqrt (length (nodes solution)))))
	 (pieces nil))
    (do ((row 1 (+ row 1)))
	((= row (1+ dimension)))
      (do ((col 1 (+ col 1)))
	  ((= col (1+ dimension)))
	(push
	 (car (possible-values
	       (find-node (puzzle-variable-name row col) solution)))
	 pieces)))
    (draw-puzzle (reverse pieces) nil)))
