;;; -*- Mode:Lisp; Package: PAIL-LIB; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; **************************************************************************
;;;                            EXPLANATION BASED LEARNING
;;; **************************************************************************
;;;
;;; Filename:   ebg-classes.cl
;;; Short Desc: Classes for EBG
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   
;;; Author:     DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;
;;; ==========================================================================


(in-package :pail-lib)

(export '(ebg-tree substitutions fact uid
	  ))

;(setq *readable* t)
;(setq *readable* nil)


;;; ==========================================================================
;;; CLASSES AND STRUCTURES - Definitions and Access Functions
;;; ==========================================================================


;;; --------------------------------------------------------------------------
;;; EBG TREE CLASS
;;; --------------------------------------------------------------------------

(defvar *EBG-tree-ctr* 0)

(defclass ebg-tree (tree)
  ((fact             :accessor fact
                     :initarg :fact
                     :initform nil
                     :type list)
   (substitutions    :accessor substitutions
                     :initarg :substitutions
                     :initform nil
                     :type list)
   (uid              :accessor uid	; unique identifier for ebg-tree instances
		     :initarg :uid
		     :initform (format nil "EBG~a" (setf *EBG-tree-ctr*  (1+ *EBG-tree-ctr*)))) )
  (:documentation "The ebg tree class"))




(defmethod change-type ((a ebg-tree) (b ebg-tree)) a)

(defmethod print-object ((ebg-tree ebg-tree) stream)
  (if ;(setq *readable* t)
    ;(setq *readable* nil)
    *readable*
    (print-ebg-tree ebg-tree stream)
    (print-unreadable-object 
      (ebg-tree stream :type t :identity t))))


(defmethod print-ebg-tree ((ebg-tree ebg-tree) &optional (stream t) (level 0))
  ;(format stream "~%")
  (if (null (content ebg-tree))
    (progn
      (format stream "~%")
      (dotimes (dummy level) (format stream "  "))
      (format stream "~a" (content ebg-tree)))
    (print-rule (content ebg-tree) stream level))
  (dolist (desc (descendants ebg-tree) t)
    (print-ebg-tree desc stream (1+ level))))

;(print-object *gen-ebg-tree* t)
;(print-tree *gen-ebg-tree*)
;(print-ebg-tree *gen-ebg-tree*)
;(content *gen-ebg-tree*) ;nothing
;(content *gen-ebg-tree*)
;(descendants *gen-ebg-tree*)


;;; ==========================================================================
;;; * END OF FILE *
;;; ==========================================================================
