;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;; **************************************************************************
;;;                            EXPLANATION BASED LEARNING
;;; **************************************************************************
;;;
;;; Filename:   ebg-doc.txt
;;; ==========================================================================


#|

The *RULE-SET*
==============
The rule input of an inference engine:
Remarks: ?x = the ? denotes a variable

(rule-a
 (IF (volume ?p1 ?v1)
   (density ?p1 ?d1))
 (THEN (weight ?p1 (LISP (* ?v1 ?d1)))))

(rule-b
 (IF (weight ?p1 ?w1)
   (less ?w1 ?w2)
   (weight ?p2 ?w2))
 (THEN (lighter ?p1 ?p2)))

(rule-c
 (IF (isa ?p1 endtable))
 (THEN (weight ?p1 5)))

(rule-d
 (IF t)
 (THEN (less .1 5)))

;or there is a LISP predicate - or is it a fact!?
;(rule-d
; (IF (LISP (< ?p1 ?p2)))
; (THEN (less ?p1 ?p2)))

(rule-e
 (IF (lighter ?p1 ?p2))
 (THEN (safe-to-stack ?p1 ?p2)))


Facts:

(on obj1 obj2)
(isa obj1 box)
(isa obj2 endtable)
(color obj1 red)
(color obj2 blue)
(volume obj1 1)
(density obj1 1)


The proof chain of rules (from the proof tree)

([rule-e] 
   ([rule-b] 
      ([rule-a] 
         ([fact] 
          [fact]))
      ([rule-c]
         ([fact]))
      ([rule-d])))


This tree (list) could be an output of the inference engine 
(the proof tree):
Remarks: the brackets enclose the rule-name e.g.  [rule-x]
Syntax of the tree list: (root (descendent1) (descendent2))

(safe-to-stack obj1 obj2 [rule-e]
               (lighter obj1 obj2 [rule-b]
                        (weight obj1 .1 [rule-a]
                                (volume obj1 1 [fact])
                                (density obj1 .1 [fact]))
                        (less .1 5 [rule-d])
                        (weight obj2 5 [rule-c]
                                (isa obj2 endtable [fact]))))
NIL

The *GEN-PROOF-TREE*
====================

Phase 1: The generalized tree:

(safe-to-stack ?p1 ?p2 [rule-e]     ;introduced ?p1 ?p2
   (lighter ?p1 ?p2 [rule-b]))

   (lighter ?p1 ?p2 [rule-b]
      (weight ?p1 ?w1 [rule-a]      ;introduced ?w1
      (weight ?p2 ?w2 [rule-c]      ;introduced ?w2
      (less ?w1 ?w2 [rule-d]))))

      (weight ?p1 (LISP (* ?v1 ?d1)) [rule-a] 
                                    ;introduced (LISP (* ?v1 ?d1))
                                    ;replaced (?w1 (LISP (* ?v1 ?d1)))
         (volume ?p1 ?v1 [fact])
         (density ?p1 ?d1 [fact]))

      (weight ?p2 5 [rule-c]        ;replaced (?w2 5) 
                                    ;introduced 5
         (isa ?p2 endtable [fact])) ;introduced endtable

      (less ?w1 ?w2 [rule-d])
NIL


or directly:

(safe-to-stack ?p1 ?p2 [rule-e]     ;reintroduced (?obj1 ?p1) (?obj2 ?p2)
   (lighter ?p1 ?p2 [rule-b]
      (weight ?p1 (LISP (* ?v1 ?d1)) [rule-a] 
                                    ;reintroduced (.1 (LISP (* ?v1 ?d1)))
         (volume ?p1 ?v1 [fact])    ;(1 ?v1)
         (density ?p1 ?d1 [fact]))  ;(.1 ?d1
      (weight ?p2 5 [rule-c]        ;reintroduced 5
         (isa ?p2 endtable [fact])) ;reintroduced (?obj2 endtable)
      (less (LISP (* ?v1 ?d1)) ?5 [rule-d]))) ;?
NIL


Phase 2: The regressed tree:

(safe-to-stack ?x ?y [rule-e]       ;(?x ?p1) (?y ?p2)
   (lighter ?x ?y [rule-b]          ;(?x ?p1) (?y ?p2)
      (weight ?y ?w1) [rule-a]      ;         (?y ?p2) (?w1 (LISP (* ?v1 ?d1)))   
         (volume ?x ?v1 [fact])     ;(?x ?p1) (?y ?p2)
         (density ?x ?d1 [fact]))   ;(?x ?p1) (?y ?p2)
      (weight ?y ?w2 [rule-c]       ;         (?y ?p2)                   (?w2 5)
         (isa ?y endtable [fact]))  ;         (?y ?p2)
      (less ?w1 ?w2 [rule-d]))      ;           (?w1 (LISP (* ?v1 ?d1))) (?w2 5)

Special case: a dangling leave: 
(push down to deepest level and substitute again):
      -> (less (LISP (* ?v1 ?d1)) 5 [rule-d] ;  (?w1 (LISP (* ?v1 ?d1))) (?w2 5)
NIL


The output rule collected from the leaves:

(rule-ebg1
 (IF ((volume ?x ?v1)
      (density ?x ?d1)
      (isa ?y endtable)
      (less (LISP (* ?v1 ?d1)) 5))  ;or: (LISP (< (* ?v1 ?d1) 5)
   (THEN (safe-to-stack ?x ?y))))

|#

#| ---------------------------------------------------------------------------
;;; SAFE-TO-STACK-Tests
;;; ===================
(setq *var-counter* 0)
(setq goal-concepts nil)
(setq substitutions nil)

;rule-e, level 0:
;-----------------
(setq goal-concept0 (new-term '(safe-to-stack ?p1 ?p2)))

;process all consequents of rule-e, level 0
(setq substitution0 (unify goal-concept0 '(safe-to-stack ?p1 ?p2)))
(setq goal-concepts (rename-term '((lighter ?p1 ?p2)) substitution0))

;rule-b is level 1
;-----------------
(setq goal-concept1 (car goal-concepts))
(setq substitution1 (unify goal-concept1 '(lighter ?p1 ?p2)))
(setq goal-concepts (rename-term '((weight ?p1 ?w1) (weight ?p2 ?w2) (less ?w1 ?w2))
                                 substitution1))

;process all consequents of rule-b, level 1
(setq goal-concept11 (car goal-concepts))
(setq substitution11 (unify goal-concept11 '(weight ?p1 ?w1)))

(setq goal-concept12 (cadr goal-concepts))
(setq substitution12 (unify goal-concept12 '(weight ?p2 ?w2)))

(setq goal-concept13 (caddr goal-concepts))
(setq substitution13 (unify goal-concept13 '(less ?w1 ?w2)))

;rule-a is first on level 2
;--------------------------
(setq substitution2 (unify goal-concept11 '(weight ?p1 (LISP (* ?v1 ?d1)))))
(setq goal-concepts (rename-term '((volume ?p1 ?v1) (density ?p1 ?d1))
                                 substitution2))

;process all consequents of rule-b, level 2
(setq goal-concept21 (car goal-concepts))
(setq substitution21 (unify goal-concept21 '(volume ?p1 ?v1)))
;leave!
(rename-term goal-concept21 substitution21)

--------------------------------------------------------------------------- |#


;;; ==========================================================================
;;; * END OF FILE *
;;; ==========================================================================

