;;; -*- Mode: LISP; Package: EBG; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;; PORTABLE AI LAB - UNI ZH
;;; ************************************************************************
;;;
;;; Filename:   ebg-ex1
;;; Short Desc: An implementation of Mitchells EBG-Method
;;; Version:    1.0
;;; Status:     Final Beta
;;; Author:     Stefan Keller
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; ------------------------------------------------------------------------
;;; Change History:
;;; 25.11.91  SK First code
;;; 29.01.92  SK More clickable look and feel 
;;; 9.9.92    DTA active browsers, new EBG algorithm
;;; ========================================================================


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :ebg)


;;; ==========================================================================
;;; PARAMETERS
;;; ==========================================================================


(load-file-no-questions (add-path "stackebg" (add-subdir *pail-path* "ebg")))

(defun demo-dialog-1 (guide-disp trace-disp rule-disp cont-button exit-button)
  (let* ((*default-font* (findfont (width *root-window*) 1140 13))
	 (rule-set
	  (pool-find-object *pail-pool* "stackrules"))
	 (gen-ebg-tree
	  (pool-find-object *pail-pool* "stacktree"))
	 (new-ebg-rule nil)
	 (proof-disp nil)
	 (*readable* t)
	 (*verbose-stream* trace-disp)
	 start b1 b2 b3 w2 mult next lighter 
	 )
    ;; show first all available data
    (format-display-fill
     guide-disp
     "In the Rules window you see the given rule set.
      In the Browser window you see the resulting
      generalised proof tree produced by RULES, and
      the Trace output window will show the EBG algorithm
      processing  top down.")


    (format-display rule-disp "~a" rule-set)
    (setf proof-disp (make-instance 'ebg-browser 
		       :starting-tree gen-ebg-tree
		       :verbose t
		       :font *default-font*
		       :left (round (width *root-window*) 3) :bottom 5))
    (setf (left proof-disp) (- (width *root-window*) (width proof-disp) 5))
    (setf start (starting-tree proof-disp))

    ;; Demo flow starts here ...
    (enable-button cont-button)

    ;; Click 1
    (when (clicked-on-continue cont-button exit-button guide-disp)
      (format-display guide-disp "~%Now trying to find an EBG rule...")
      
      ;;; *** Main call to EBG ***
      (setf new-ebg-rule (ebg-m gen-ebg-tree rule-set))

      (if new-ebg-rule
	  (let ((*readable* t))
	    (format-display trace-disp
			    "~%~%...Following rule found: ~%~a~%*end*" 
			    new-ebg-rule))
	(format-display trace-disp 
			"~%...no new rule found. Please check original proof tree.~2%~
                       -*-~%"))
      (format-display guide-disp "~%EBG Done.")
      (format-display guide-disp "~%Look at the Trace output window where the new")
      (format-display guide-disp "~&rule found by EBG is being displayed.")
      (format-display guide-disp "~%Let's see how this happened.")

      ;; Click 2
      (when (clicked-on-continue cont-button exit-button guide-disp)
	(format-display-fill
	 guide-disp
	 "The tree shows a generalized trace of the rules that were fired.  
         Each rule appears with the same variable names as appeared in the 
         rule set that generated the solution.  For example, rule-b appears 
         in the middle of the reasoning chain.")
	(highlight-rule proof-disp 'dump::rule-b)
	
	;; Click 3
	(when (clicked-on-continue cont-button exit-button guide-disp)
	  (reset-highlights proof-disp)
	  (format-display-fill
	   guide-disp
	   "The algorithm begins by generalizing the variable names in the top 
            level predicate.  The algorithm chooses ?p10 and ?p1 for the two
            unbound variables.  This binding is propagated through that rule to
            its `if parts'.")
	  (reshow-item proof-disp start "(safe-to-stack ?p10 ?p1)")
	  (setf next (car (pail-lib::find-descendants proof-disp start)))
	  (reshow-item proof-disp next "(lighter ?p10 ?p1)")
	  


	;; Click 4
	(when (clicked-on-continue cont-button exit-button guide-disp)
	  (format-display-fill
	   guide-disp
	   "Now the if part of this rule is unified with the then part of the
            chaining rule, which was rule-b shown before.  This unifies 
            ?p10 with ?p1, ?p1 with ?p2.  This unification is propagated 
            throughout the rule.")
	  (setf lighter (car (descendants next)))
	  (reshow-item proof-disp lighter "(lighter ?p10 ?p1)")
	  (setf b1 (first (pail-lib::find-descendants proof-disp lighter)))
	  (setf b2 (second (pail-lib::find-descendants proof-disp lighter)))
	  (setf b3 (third (pail-lib::find-descendants proof-disp lighter)))


	  (reshow-item proof-disp b1 "(weight ?p10 ?w1)")
	  (reshow-item proof-disp b2 "(weight ?p1 ?w2)")
;	  (reshow-item proof-disp b3 "(lisp < ?w1 ?w2)")
	  
	  
	  
	  ;; Click 5
	  (when (clicked-on-continue cont-button exit-button guide-disp)
	    (format-display-fill
	     guide-disp
	     "The next rule to be unified is rule-a.  Notice that ?p10
              is propagated down through this rule, but that ?w1, which was 
              introduced by rule-b, will be given a binding (* ?v1 ?d1).  
              This binding must be propagated back through rule-b")
	    (highlight-rule proof-disp 'dump::rule-a)
	    (when (clicked-on-continue cont-button exit-button guide-disp)
	      (reset-highlights proof-disp)
	      (setf mult (car (descendants b1)))
	      (reshow-item proof-disp mult "(weight ?p10 (* ?v1 ?d1))")
	      (loop for d in (pail-lib::find-descendants proof-disp  mult)
		   as string in (list
				 "(volume ?p10 ?v1)"
				 "(density ?p10 ?d1)")
		   do (reshow-item proof-disp d string))
	      (reshow-item proof-disp b1 "(weight ?p10 (* ?v1 ?d1))")
	      (reshow-item proof-disp b3 "(< (* ?v1 ?d1) ?w2)")
	      (when (clicked-on-continue cont-button exit-button guide-disp)
		(format-display-fill
		 guide-disp
		 "The remaining rule is treated in a similar fashion, binding
                  ?w2 to the constant 5.  Notice that the variable ?p1 in this 
                  rule is unified to ?p1, while ?p1 was bound to ?p10 before.")
		(setf w2 (car (descendants b2)))
		(reshow-item proof-disp b2 "(weight ?p1 5)    ")
		(reshow-item proof-disp w2 "(weight ?p1 5)    ")
		(reshow-item proof-disp (car (pail-lib::find-descendants proof-disp w2)) "(isa ?p1 table)")
		(reshow-item proof-disp b3 "(< (* ?v1 ?d1) 5)    ")
		
		(format-display-fill
		 guide-disp
		 "The leaves of the tree correspond to the original data.  The deepest
                  generalized nodes are gathered into the rule given in the EBG Trace 
                  Output window.")

	    (clicked-on-continue cont-button exit-button guide-disp)
	    )))))))
      ;; collect all click parentheses before this
    (clean-up proof-disp)
    ;; exit
    ))


;;; ==========================================================================
;;; * END OF FILE *
;;; ==========================================================================

