;;; -*- Mode: LISP; Package: EBG; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;; PORTABLE AI LAB - UNI ZH
;;; ************************************************************************
;;;
;;; Filename:   ebg-ex2
;;; Short Desc: Suicide example for EBG
;;; Version:    1.0
;;; Status:     Final Beta
;;; Author:     Dean Allemang
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; ------------------------------------------------------------------------
;;; Change History:
;;; 25.11.91  SK First code
;;; 29.01.92  SK More clickable look and feel 
;;; 9.9.92    DTA active browsers, new EBG algorithm
;;; ========================================================================


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :ebg)


;;; ==========================================================================
;;; PARAMETERS
;;; ==========================================================================


(load-file-no-questions (add-path "suicide" (add-subdir *pail-path* "ebg"))) 

(defun demo-dialog-2 (guide-disp trace-disp rule-disp cont-button exit-button)
  (let* ((*default-font* (findfont (width *root-window*) 1140 13))
	 (rule-set
	  (pool-find-object *pail-pool* "suicide-rules"))
	 (gen-ebg-tree
	  (pool-find-object *pail-pool* "whyohwhy"))
	 (new-ebg-rule nil)
	 (proof-disp nil)
	 (*readable* t)
	 (*verbose-stream* trace-disp)
	 start b1 b2 b3 w2 mult next lighter 
	 )
    ;; show first all available data
    (format-display-fill
     guide-disp
     "Some tricky problems can happen with EBG.  What happens if two 
      variables that are introduced are bound to the same thing?")


    (format-display rule-disp "~a" rule-set)
    (setf proof-disp (make-instance 'ebg-browser 
		       :starting-tree gen-ebg-tree
		       :verbose t
		       :font *default-font*
		       :left (round (width *root-window*) 3) :bottom 5))
    (setf (left proof-disp) (- (width *root-window*) (width proof-disp) 5))
    (setf start (starting-tree proof-disp))

    ;; Demo flow starts here ...
    (enable-button cont-button)

    ;; Click 1
    (when (clicked-on-continue cont-button exit-button guide-disp)
      (format-display-fill guide-disp
			   "In this example, we have a rule set that tells us
                            that people with weapons kill people they hate.  But
                            depressed people hate themselves.  We would like to 
                            conclude that depressed people with guns will kill themselves. 
                            This is what happened to John in the example.")
      
      ;;; *** Main call to EBG ***
      (setf new-ebg-rule (ebg-m gen-ebg-tree rule-set))

      (format-display trace-disp
		      "~%~%...Following rule found: ~%~a~%*end*" 
		      new-ebg-rule)

	    
	    
	

      ;; Click 2
      (when (clicked-on-continue cont-button exit-button guide-disp)
	(format-display-fill guide-disp
			    "The problem is, that the conclusion begins with 
                             two distinct variables, ?a and ?b.  We have to go into more
                             detail about the algorithm to see how this is resolved. ")
	(format-display-fill guide-disp
                             "The system begins by
                             generating two dummy variables, ?var1 and ?var2 to take the
                             place of ?a and ?b.  These are bound to ?a and ?b for the first
                             rule.  This binding can be reviewed by selecting `Show Bindings'
                             on the (kills ?a ?b) entry in the explanation tree.  A unique
                             identifier is appended to the variables to avoid name collisions.")
	
	
	;; Click 3
	(when (clicked-on-continue cont-button exit-button guide-disp)
	  (format-display-fill
	   guide-disp
	   "We begin by propagating ?var1 and ?var2 through this rule, as before.")
	  (reshow-item proof-disp start "(kills ?var1 ?var2)")
	  (setf next (pail-lib::find-descendants proof-disp start))
	  (reshow-item proof-disp (nth 0 next) "(hates ?var1 ?var2)")
	  (reshow-item proof-disp (nth 1 next) "(possesses ?var1 ?w)")
	  (reshow-item proof-disp (nth 2 next) "(weapon ?w)")
	  


	;; Click 4
	(when (clicked-on-continue cont-button exit-button guide-disp)
	  (format-display-fill
	   guide-disp
	   "When we do the next binding, between (hates ?var1 ?var2) and
            (hates ?self ?self), ?var1 and ?var2 are bound to the same thing.
            This should be propagated through the rest of the tree.  This is
            done by using the most recent name for every variable, in this case,
            self.  Examine the binding of the  highlighted node to see the binding.")
	  (setf lighter (car (pail-lib::find-descendants proof-disp (car next))))
	  (pail-lib::highlight-item proof-disp lighter)
	  
	  ;; Click 5
	  (when (clicked-on-continue cont-button exit-button guide-disp)
	    (reset-highlights proof-disp)
	    (format-display-fill
	     guide-disp
	     "Now we have to change all the ?var1 and ?var2 to the same thing. 
              That thing will be ?self (in reality, with its unique tag)")
	    (reshow-item proof-disp start "(kills ?self ?self)")

	    (reshow-item proof-disp (nth 0 next) "(hates ?self ?self)")
	    (reshow-item proof-disp (nth 1 next) "(possesses ?self ?w)")
	    (reshow-item proof-disp (nth 2 next) "(weapon ?w)")

	    (when (clicked-on-continue cont-button exit-button guide-disp)
	      (format-display-fill
	       guide-disp
	       "Now we do the next unification, between (possesses ?self ?w)
                  and (possesses ?s ?object).  The algorithm uses the most recent name, 
                  so all occurences of ?self are changed to ?s.")
	      (reshow-item proof-disp start "(kills ?s ?s)       ")

	      (reshow-item proof-disp (nth 0 next) "(hates ?s ?s)             ")
	      (reshow-item proof-disp (nth 1 next) "(possesses ?s ?object) ")
	      (reshow-item proof-disp (nth 2 next) "(weapon ?t)")

	      (setf mult (car (pail-lib::find-descendants proof-disp (nth 0 next))))
	      (reshow-item proof-disp mult "(hates ?s ?s)      ")
	      (reshow-item proof-disp (car (pail-lib::find-descendants proof-disp mult)) "(depressed ?s)        ")
	      
	      (when (clicked-on-continue cont-button exit-button guide-disp)
		(format-display-fill
		 guide-disp
		 "The rest of the processing is simple;  ?object is bound to ?thing,
                  and this is propagated througout the tree.")
		(setf w2 (car (pail-lib::find-descendants proof-disp (nth 1 next))))
		(reshow-item proof-disp w2 "(possesses ?s ?thing) ")
		(reshow-item proof-disp (nth 1 next) "(possesses ?s ?thing) ")
		(reshow-item proof-disp (nth 2 next) "(weapon ?thing) ")
		(setf b2 (car (pail-lib::find-descendants proof-disp w2)))
		(reshow-item proof-disp b2 "(buys ?s ?thing) ")
		(format-display-fill
		 guide-disp
		 "Now the leaves correspond to the generated rule, and the unification
                  has been propagated back to the root. ")

		(clicked-on-continue cont-button exit-button guide-disp)
		))))))
      ;; collect all click parentheses before this
    (clean-up proof-disp)
    ;; exit
    )))


;;; ==========================================================================
;;; * END OF FILE *
;;; ==========================================================================

