
;;; INTEFACCIA CON GNU-EMACS

;;;===========================================================================
;;; variabili
;;;===========================================================================

(setq window-setup-hook 'start-emacs) ;;e' chiamata alla fine del load

;;; per i tasti Lx Fx.. e Rx

(defvar sun-raw-map (make-sparse-keymap) "*Keymap per la tastiera")

;;=============
;;da dot.emacs
;;=============

;; turn on superkeys in subprocess modes
;;
(setq-default fi:subprocess-enable-superkeys t)

;; the following causes fi:common-lisp to give the inferior Common
;; Lisp, by default, a command line argument of `+ipc':
;;

(setq fi:common-lisp-image-arguments '("+ipc"))

;; This redefines `kill-emacs' so that transaction files in /tmp are
;; removed emacs is killed:
;;
(setq fi:subprocess-enable-superkeys t)

(fset 'old-kill-emacs (symbol-function 'kill-emacs))

;;=============
;; lisp name
;;=============


(defun clx()
  (setq fi:common-lisp-image-arguments nil)
  (setq inferior-lisp-program "/usr/local/bin/clx4.1")
  (setq fi:common-lisp-image-name "/usr/local/bin/clx4.1"))

(defun clx-qq()
  (setq fi:common-lisp-image-arguments (list "-qq"))
  (setq inferior-lisp-program "/usr/local/bin/clx4.1")
  (setq fi:common-lisp-image-name "/usr/local/bin/clx4.1"))

(defun cl()
  (setq fi:common-lisp-image-arguments nil)
  (setq inferior-lisp-program "/usr/local/bin/cl4.1")
  (setq fi:common-lisp-image-name "/usr/local/bin/cl4.1"))


(defun lisp-name (name)
  (setq inferior-lisp-program name)
  (setq fi:common-lisp-image-name name))


;;;===========================================================================
;;; funzioni                                                          generali
;;;===========================================================================


(defun start-emacs ()
  (interactive "p")
  (setq fi:lisp-comment-indent-specification '(0 t nil 0))
  (define-key mouse-map x-button-right 'x-cut-text-l)
  (define-key mouse-map x-button-left 'x-mouse-blink))

(defun x-mouse-blink (arg)
  (x-mouse-set-point arg)
  (blink-parent-point)
  )

(defun blink-parent-point ()
  (cond ((not (= (point)(point-max)))
	 (forward-char)
	 (if (/= (char-syntax (point)) ?\\ )
	     (blink-matching-open))
	 (backward-char))))

(defun scroll-one-line-up (arg)
  (interactive "p")
  (scroll-up 1))

(defun scroll-one-line-down (arg)
  (interactive "p")
  (scroll-down 1))

(defun scroll-one-line-down (arg)
  (interactive "p")
  (scroll-down 1))

;; mette la linea dove sei in al top della pagina

(defun recenter0 (arg)
  (interactive "p")
  (recenter 0))

(defun rerun-prev-command ()
  "Repeat Previous-complex-command."
  (interactive)
  (eval (nth 0 command-history)))

;; basta con yes no .... !!!

(defun kill-emacs-no-question (arg) 
  (interactive "p")	
  (kill-emacs t))


;;==============
;; lisp
;;==============

(defun compile-defun-in-lisp-package (arg)
  (interactive "P")
  (setq fi:tmp-package fi:package)
  (setq fi:package (fi::symbol-value-in-buffer 'fi:package (get-buffer "*common-lisp*")))
  (fi:lisp-eval-defun t)
  (setq fi:package fi:tmp-package))


(defun compile-buffer-in-lisp-package (arg)
   (setq fi:tmp-package fi:package)
  (setq fi:package (fi::symbol-value-in-buffer 'fi:package (get-buffer "*common-lisp*")))
  (fi:lisp-eval-current-buffer t)
  (setq fi:package fi:tmp-package))

(defun compile-defun (arg)
  (interactive "P")
  (fi:lisp-eval-defun t))


(defun compile-buffer (arg)
  (interactive "P")
  (fi:lisp-eval-current-buffer t))


(defun fi:remote-lisp (&optional host buffer-number)
  (let ((proc (fi::make-subprocess
	       buffer-number (concat "remote-common-lisp " host) 
	       'fi:inferior-common-lisp-mode
	       fi:common-lisp-prompt-pattern
	       "rsh"
	       (append (list host fi:common-lisp-image-name)
		       fi:common-lisp-image-arguments))))
    (setq fi::freshest-common-sublisp-name (process-name proc))
    proc))

;; serve ad avere la history con R8 e R14 in lisp

(defun lisp-history()
  (define-key fi:inferior-common-lisp-mode-map "\C-p" 'fi:pop-input)	
  (define-key fi:inferior-common-lisp-mode-map "\C-n" 'fi:push-input)
  (setq fi::input-ring '("---->" "")))

(defun tcp-history ()
  (define-key fi:tcp-common-lisp-mode-map "\C-p" 'fi:pop-input)	
  (define-key fi:tcp-common-lisp-mode-map "\C-n" 'fi:push-input)
  (setq fi::input-ring '("---->" "")))


(defun load-lisp (arg)
  (load-library "fi/site-init.el")
  (setq fi:common-lisp-directory default-directory)
  (put 'defself fi:lisp-indent-hook
       (quote (if (fi:lisp-atom-p 2)
                  ((1 3 lambda-list) (0 t 3))
                ((1 2 lambda-list) (0 t 2)))))
  (put 'defmethod 'fi:lisp-indent-hook  
       (quote (if (fi:lisp-atom-p 2)
                  ((1 3 lambda-list) (0 t 3))
                ((1 2 lambda-list) (0 t 2)))))
  (put 'defself 'fi:lisp-indent-hook '((1 2 lambda-list) (0 t 2)))
  (interactive "p")
  (fi:common-lisp)
  (lisp-history))

(defun load-tcp (arg)
  (interactive "p")
  (fi:tcp-common-lisp)
  (tcp-history))

(defun fi:lisp-mode-newline ()
  (interactive)
  (newline)
  (fi:lisp-indent-line))

(defun complete-lisp-symbol ()
  (interactive)
  (fi:lisp-complete-symbol)
  (cond ((get-buffer "*Help*")
	 (read-char)
	 (kill-buffer "*Help*"))))

;;==============
;; mouse
;;==============

(defun indent-defun (arg)
  (interactive "p")
  (mark-defun)
  (indent-region (region-beginning) (region-end) nil))

;; inverte gli up con i lowcase

(defun case-flip-region (beg end)
  "change the case of the character under the cursor.
accepts a prefix argument of the number of characters to invert."
  (interactive "p")
  (goto-char beg)
  (let ((num (- end beg)))
    (while (> num 0)
      (funcall (if (<= ?a (following-char))
		   'upcase-region 'downcase-region)
	       (point) (1+ (point)))
      (forward-char 1)
      (setq num (1- num)))))

;; la parte selezionata si inverte

(defun x-cut-text-l (arg &optional kill)
  "COPY text betn point and mouse position into window system cut buffer.
save in emacs kill ring also."
         (if (coordinates-in-window-p arg (selected-window))
      (save-excursion
        (let ((opoint (point))
              beg end)
          (x-mouse-set-point arg)
          (setq beg (min opoint (point))
                end (max opoint (point)))
          (x-store-cut-buffer (buffer-substring beg end))
          (copy-region-as-kill beg end)
	  (case-flip-region beg end)
	  (sit-for 1)
	  (case-flip-region beg end)
          (if kill (delete-region beg end))))
      (message "mouse not in selected window")))


(defun x-cut-word-l (arg &optional kill) 
  "COPY text betn point and mouse position into window system cut buffer.
save in emacs kill ring also."
;         (if (coordinates-in-window-p arg (selected-window)))
      (save-excursion
        (let (beg end)
          ;(x-mouse-set-point arg)
	  (backward-word 1)
          (setq beg (point))
	  (forward-word 1)
          (setq end (point))
          (x-store-cut-buffer (buffer-substring beg end))
          (copy-region-as-kill beg end)
	  (case-flip-region beg end)
	  (sit-for 1)
	  (case-flip-region beg end)
          (if kill (delete-region beg end))))
      (message "mouse not in selected window"))


(defun load-pail (arg)
  (interactive "p")
  (clx)
  (load-lisp t))

	      
(defun load-lisp-qq (arg)
  (interactive "p")
  (clx-qq)
  (load-lisp t))
  
;;;===========================================================================
;;; key bindings
;;;===========================================================================


(define-key global-map "\e-" 'load-pail)
(define-key global-map "\e=" 'load-lisp-qq)
(define-key global-map "\e|" 'load-tcp)
(define-key global-map "\ei" 'indent-defun)
(define-key global-map "\e1" 'repeat-matching-complex-command)
(define-key global-map "\C-x\C-z" 'kill-emacs-no-question)


;; binding per Lx e Rx

(define-key sun-raw-map "211z" 'scroll-one-line-up)     ; R4
(define-key sun-raw-map "212z" 'recenter0)              ; R5
(define-key sun-raw-map "213z" 'scroll-one-line-down)   ; R6
(define-key sun-raw-map "214z" 'beginning-of-buffer)    ; R7
(define-key sun-raw-map "216z" 'scroll-down)            ; R9
(define-key sun-raw-map "218z" 'recenter)               ; R11
(define-key sun-raw-map "220z" 'end-of-buffer)          ; R13
(define-key sun-raw-map "222z" 'scroll-up)              ; R15

(define-key sun-raw-map "192z" 'compile-defun)               ;; L1
(define-key sun-raw-map "193z" 'compile-buffer)              ;; L2
(define-key sun-raw-map "194z" 'undo)                        ;; L3
(define-key sun-raw-map "195z" 'rerun-prev-command)          ;; L4
(define-key sun-raw-map "196z" 'fi:lisp-delete-pop-up-window);; L5
(define-key sun-raw-map "197z" 'complete-lisp-symbol)        ;; L6

(define-key sun-raw-map "198z" 'shrink-window-horizontally)  ;; L7
(define-key sun-raw-map "199z" 'enlarge-window-horizontally) ;; L8
(define-key sun-raw-map "200z" 'shrink-window)               ;; L9
(define-key sun-raw-map "201z" 'enlarge-window)              ;; L10
(define-key sun-raw-map "202z" 'x-cut-word-l)               ;; HELP

(define-key sun-raw-map "224z" 'compile-defun-in-lisp-package);; F1
(define-key sun-raw-map "225z" 'compile-buffer-in-lisp-package);; F2
(define-key sun-raw-map "231z" 'fi:clman)                    ;; F8
(define-key sun-raw-map "232z" 'manual-entry)                ;; F9
 
;; sistema la mappa della tastiera

(define-key esc-map "[" sun-raw-map)

;;;===========================================================================
;;; put del sistema
;;;===========================================================================

	    
(defun insert-item (arg)
  (interactive "p")
  (insert-string "\\item {}")
  (backward-char))

(put 'eval-expression 'disabled nil)
