;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:RULES; Base:10; -*-
;;; ************************************************************************
;;; WIN-SHELL
;;; ************************************************************************
;;;
;;; Filename:   win-fun
;;; Short Desc: WIN-SHELL - a tiny shell from the WINSTON-HORN book
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:    5.11.90 15:00:00 SK
;;; Author:     WINSTON, typed in: Hauser-Fischer
;;;
;;; ------------------------------------------------------------------------
;;; Change History:
;;; HF  11.11.87  first code, debugged
;;; SK  16.10.89  improved
;;; SK   5.11.90  some pail standards applied
;;; ------------------------------------------------------------------------
;;;
;;; DESCRIPTION
;;; -----------
;;; Call to the unifier to do pattern matching

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------


(in-package :rules)




;***************************************************************************
;
;                         MATCHING
;
;***************************************************************************


(defun match (p d assignments)
  (prog (answer)
    (setq answer (unify (replace-pattern-variables p assignments)
			(replace-pattern-variables d assignments)))
    (return (cond ((equal answer 'fail) nil)
		  ((null answer)
		   (cond
		    ((null assignments) t)
		    (t assignments)))
		  (t (append assignments answer))))))



;---------------------------------------------------------------------------
; end of file
;---------------------------------------------------------------------------
