
;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;; WIN-SHELL
;;; ************************************************************************
;;;
;;; Filename:   win-intf
;;; Short Desc: WIN-SHELL - a tiny shell from the WINSTON-HORN book
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:    5.11.90 15:00:00 SK
;;; Author:     WINSTON, typed in: Hauser-Fischer
;;;
;;; ------------------------------------------------------------------------
;;; Change History:
;;; HF  11.11.87  first code, debugged
;;; SK  16.10.89  improved
;;; SK   5.11.90  some pail standards applied
;;; ------------------------------------------------------------------------
;;;
;;; DESCRIPTION
;;; -----------
;;; Allegro Common Lisp functions ***ONLY*** for the MAC-interface
;;; ------------------------------------------------------------------------

(in-package :rules)

;(setq *lisp-dialect* 'AllegroCL122)
;(setq *lisp-dialect* 'XLisp20)
(setq *lisp-dialect* 'CommonLisp)

(defun cls ()	             ;clears the screen
  (format t "***CLS***")
  nil)

(defun mydialog (dialogfact)
  (cond ((equal *lisp-dialect* 'AllegroCL122)
         (gin:y-or-n-dialog (princ-to-string dialogfact)))
        (t
	 (format t "~%Is ~a true? [Y/n] " dialogfact)
         (cond ((equal (read) 'y) t) (t nil)))
        )
  )
