;-*- Mode:  LISP; Syntax: Common-lisp; Package: GTRE -*- 

(in-package :gtre)

;;The following solves the problem of evaluating lisp expressions generated
;;as argument in an assertion.

(defun process-argument (argument)
  (if (and (listp argument) (every #'numberp (cdr argument)))
      (eval argument)
      argument))

(excl:advise assert! :before check_args nil
	(setf (first excl:arglist)
	      (mapcar #'process-argument (first excl:arglist))))

;just call (unadvise 'rassert!) at the end of the processing.
