;;; -*- Mode: LISP; Package: GTRE-EXAMPLE; Syntax: Common-lisp; -*-
;;;
;;; *******************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; *******************************************************
;;;
;;; Filename:   ebl-gtre.cl
;;; Short Desc: Interface to make rules in EBL format 
;;;             understandable to the TMS modules.
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   15.07.91 - Fatma FEKIH-AHMED
;;; Author:     Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log$
;;; -------------------------------------------------------
 
(in-package pail-lib)
(export '(translate-rule-set))

(defvar *testvars* nil)
(defvar *vars* nil)

;;;effective interface.

;;the translate-rule-set function takes a list of rules in ebl format as an
;;argument to return the list of corresponding rules in jtre format.
;
(defmethod translate-rule-set ((rules rule-set))
  (let ((result nil))
    (dolist (elt (rule-set-part rules) (reverse result))
      (push (translate-rule elt) result))))

#| (defmethod translate-rule-set ((ruleset rule-set))
  `(progn ,@ (let ((result nil))
    (dolist (elt (rule-set-part ruleset) (reverse result))
      (push (translate-rule elt) result))))) |#

;;the following translate-rule function takes a rule in ebl format as an input
;;and returns a call to the rule macro as done when using jtre as an output.
;;
;;when the rule to translate is a simple assertion, the result must take the 
;;form of a simple assertion that means we have to translate the rule into 
;;a simple call to the assert! function with the then-part as a body.
;:
(defmethod translate-rule ((rule rule))
  (setf *vars* nil)
  (setf *testvars* nil)
  (if (null (if-part rule))
      (list 'gtre::assert!			;in fact, rule is an assertion.
	    (then-part rule))
    `(gtre::rule				;else, rule is really a "rule".
	  ,(translate-if-part (if-part rule))
	  ,@(translate-then-part  rule))))
 
;;translate-if-part takes the if-part of a rule in ebl format and returns a 
;;list of triggers corresponding to jtre syntax as an output.
;;an if-part consists in a list of s-expressions. they have to be translated 
;;into a list of triggers.
;;we can divide the s-expressions in the ebl format for rules into two
;;categories:
;;
;;  - those which form is (<predicate> <list of variables>) could be 
;;    translated into an (:intern (<predicate> <list of variables>))
;;
;;  - those which form is (lisp <lisp-expression>) correspond to the
;;    :test <lisp-expression> that can figure in a given trigger.
;;    to translate them, we can simply append such a translation to the
;;    the last (:intern ...) form generated.
;
(defun translate-if-part (if-p)
  (let ((triggers nil))
    (dolist (expression if-p (reverse triggers))
      (if (equal (string-downcase (symbol-name (car expression))) "lisp")
	  (prog1 (push (append (pop triggers) (list ':test (cdr expression))) triggers)
		 (push (cdr expression) *testvars*))
	
	(push `(:in ,expression :var ,(newvar)) triggers)))))
 



(defun newvar ()
  (let ((sym (intern (concatenate 'string "?" (symbol-name (gensym))))))
    (push sym *vars*)
    (car (push sym *testvars*))))


;;translate-then-part takes the then-part of a rule in ebl format and returns
;;the corresponding rule body in jtre format.
;;the body takes the form of some lisp code including especially some calls
;;to the rassert! macro.
;
(defun translate-then-part (rule)
  `((gtre::rassert! ,(then-part rule) (rule ,@(reverse *vars*)))
    (gtre::rassert! (ebg ,(then-part rule))
		    (rule ,@(mapcar 'wrapebg (reverse *testvars*))))))
  
  
(defun wrapebg (assertion) (list 'ebg assertion))
 
;;some useful functions.
 
(defun neq (arg1 arg2)
  (not (eql arg1 arg2))) 
 
