;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:HOPFIELD; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   good.cl
;;; Short Desc: basic hopfield network class
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   Apr 22 1992
;;; Author:     Erik Vinkhuyzen

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================



;;;============================
;;; These are test set-ups
;;;============================

;;(defmethod height ((w cw::root-window)) 600)
;;(defmethod width ((w cw::root-window)) 800)

(in-package :hopfield)

;;; ==========================================================================
;;; unit
;;; ==========================================================================

(defclass unit ()
	  ((hopfield-network :initarg :hopfield-network
			     :accessor hopfield-network
	                     :type hopfield-network)
	   (temporary  :initarg :temporary
		       :accessor temporary
		       :initform 0
		       :type float)
	   (activation :initarg :activation
		       :accessor activation
		       :initform 0
		       :type float)
	   (connections :initarg :connections
			 :accessor connections
			 :initform nil)
	   (index        :initarg :index
			 :accessor index
			 :type integer)
	   (radio-button :initarg :radio-button
			 :accessor radio-button
			 :type radio-button-for-activations-window)
	   (stable       :accessor stable
			 :initform nil))) 

(defmethod initialize-instance :after ((u unit) &key)
  (setf (radio-button u) (make-instance 'radio-button-for-activations-window
				     :label ""
				     :x (index u)))
  (setf (activation u) 0)
  (setf (action (radio-button u))
    `(lambda () (if (= (new-activation ,u) 1)
		    (when (not (status (radio-button ,u))) ; If the radio-button is white, blink
			(black (radio-button ,u))
			(mp:process-wait-with-timeout "" 1 #'(lambda () ()))
			(white (radio-button ,u)))
		  (when (status (radio-button ,u)) ; If the radio-button is black, blink
		    
		    (white (radio-button ,u))
		    (mp:process-wait-with-timeout "" 1 #'(lambda () ()))
		    (black (radio-button ,u)))))))


(defmethod new-activation ((u unit))
  (let ((tr (threshold (hopfield-network u))))
    (if (<= tr 
	    (loop for i in (connections u)
		     sum (compute-incoming-activation i u)))
	1
    -1)))


		   


(defmethod reset ((u unit))
  (setf (activation u) 0)
  (setf (stable u) nil)
  (loop for i in (connections u)
    unless (= (weight i) 0)
    do (reset i)))


(defmethod (setf activation) :after (activation (u unit))
  (if (= activation (activation u))
      (setf stable t))
  (if (= activation 1)
      (if (display (radio-button u)) 
	  (setf (status (radio-button u)) t) ; change colour and status
	(setf (slot-value (radio-button u) 'status) t)) ;present colour o.k. just change the status
    (if (display (radio-button u))
	(setf (status (radio-button u)) nil)
      (setf (slot-value (radio-button u) 'status) nil))) 
  )

(defmethod (setf stable) :after (stable (u unit))
  (if *debug* (if stable 
		  (format t "Set to true~%")
		(format t "Set to nil~%"))))


#|(defmethod compute-new-weight ((u unit) lr decay n)
  (loop for i in (connected-to u)
    for a = (- (/ (* lr (activation u) (activation (first i))) 
		  n)
	       (* decay 
		  (weight (second i))))
    unless (=  0 a)
    do (progn (setf (weight (second i)) (+ a (weight (second i))))
	      (white (second i))
	      (draw-square (second i) a))))|#
    

(defmethod compute-new-activation-asynchronously ((u unit)  treshold)
  (when (and (< 20 (random 100))
	     (not (stable u)))
	(let ((a (loop for i in (connections u)
		     sum (compute-incoming-activation i u))))
	  (if (<= treshold a)
	      (setf (activation u) 1)
	    (setf (activation u) -1)))))

(defmethod compute-new-activation-synchronously ((u unit)  treshold)
  (setf (temporary u)
      (loop for i in (connections u)
	    sum (compute-incoming-activation i u))))



(defmethod compute-new-activation ((u unit) asynchronous treshold)
  (if asynchronous
      (compute-new-activation-asynchronously u treshold)
    (compute-new-activation-synchronously  u treshold)))
    
	     
      

#|(defmethod compute-new-activation ((u unit))
  (if (asynchronous u) 
      (loop for i in (connected-to u)
	  do (progn (setf (temporary u) (+ (temporary u)
				     (* (activation (first i))
					(weight (second i)))))
	      (setf (temporary (first i)) (+ (temporary (first i))
				     (* (activation u)
					(weight (second i)))))))))|#




(defmethod determine-new-activation ((u unit) tr)
  (cond ((< (temporary u) tr)
	 (setf (activation u) -1)
	 (setf (temporary u) 0))
	(t 
	 (setf (activation u) 1)
	 (setf (temporary u) 0))))


#|(defmethod compute-energy ((u unit))
  (loop for i in (connected-to u)
    sum (* (activation u) (activation (first i)) (weight (second i)))))|#


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; connection
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defclass connection ()
	  ((first-unit :initarg :first-unit
		       :accessor first-unit
		       :type unit)
	   (second-unit :initarg :second-unit
			:accessor second-unit
		       :type unit)
	   (weight     :initarg :weight
		       :accessor weight
		       :initform 0
		       :type float)
	   (radio-button :initarg :radio-button
			 :accessor radio-button
			 :type radio-button-for-weight-window)
	   (hopfield-network
	               :initarg :hopfield-network
		       :accessor hopfield-network
		       :type hopfield-network)))

(defmethod initialize-instance :after ((c connection) &key)
  (setf (radio-button c) (make-instance 'radio-button-for-weight-window
			   :label ""
			   :weight (weight c))))

(defmethod (setf weight) :after (w (c connection))
;;; Here I should change the code for when the weight-window
;;; is not displayed.
  (unless (no-weight-window (hopfield-network c))
    (setf (weight (radio-button c)) w)))

(defmethod update-weight-window ((c connection))
  (setf (weight (radio-button c)) (weight c)))


(defmethod compute-new-weight ((c connection) lr decay n)
  (let ((a (- (/ (* lr (activation (first-unit c)) (activation (second-unit c))) 
		  n)
	       (* decay 
		  (weight c)))))
    (when (not (= a 0))
      (setf (weight c) (+ a (weight c))))))

(defmethod compute-incoming-activation ((c connection) unit)
  (if (eq unit (first-unit c))
      (* (activation (second-unit c))
	 (weight c))
    (* (activation (first-unit c))
       (weight c))))
	
			 
(defmethod reset ((c connection))
  (setf (weight c) 0))

(defmethod compute-energy ((c connection))
  (* (activation (first-unit c)) (activation (second-unit c)) (weight c)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; hopfield-network
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass hopfield-network ()
	 ((units        :initarg :units
			:accessor units
			:initform (make-array '0 
					      :adjustable t
					      :element-type 'unit))
	  (connections  :initarg :connections
			:accessor connections
			:initform nil)
	  (asynchronous :initarg :asynchronous
			:accessor asynchronous
			:initform nil)
	  (energy       :accessor energy
			:initform 0
			:type float)
	  (learning-rate 
	                :accessor learning-rate
			:initform 1
			:type float)
	  (decay        :accessor decay
			:initform 0
			:type float)
	  (cycles       :initarg :cycles
			:accessor cycles
			:initform 1
			:type integer)
	  (size         :initarg :size
			:initform 25
			:accessor size
			:type integer)
	  (threshold     :initarg :threshold
			:accessor threshold
			:initform 0
			:type float)
	  (output-window
	                :initarg :output-window
			:accessor output-window
			:type output-window)
	  (input-window
	                :initarg :input-window
			:accessor input-window
			:type input-window)
	  (no-weight-window
	                :initarg :no-weight-window
			:accessor no-weight-window
			:initform nil)
	  (weight-window
	                :initarg :weight-window
			:accessor weight-window
			:type weight-window)
	  (parameter-window
	                :accessor parameter-window
			:initarg :parameter-window
			:type parameter-window)
	  (hopfield-data     :initarg :hopfield-data
			      :accessor hopfield-data
			      :initform (make-instance 'pail::hopfield-data))))


(defmethod initialize-instance :after ((hn hopfield-network) &key)
  (adjust-array (units hn) (size hn) 
		:initial-contents (loop for i from 0 to (- (size hn) 1)
				    collect (make-instance 'unit
				      :hopfield-network hn
				      :index i)))
  (setf (connections hn)
    (loop for i from 0 to (- (size hn) 1)
      append (loop for j from (+ i 1) to (- (size hn) 1)
		 for first-unit = (aref (units hn) i)
		 for second-unit = (aref (units hn) j)
		 for k = (make-instance 'connection
			   :first-unit first-unit
			   :second-unit second-unit
			   :hopfield-network hn)
		 do (progn (setf (connections first-unit) (cons k (connections first-unit)))
			   (setf (connections second-unit) (cons k (connections second-unit))))
		 collect k)))
  
  
  ;(if *debug* (format t "the units: ~a~%" (describe (units hn))))  
  
  (setf (output-window hn) (make-instance 'output-window 
			     :width (- (floor (/ (* 2 (width *root-window*)) 3)) 30)
			     :height (- (floor (/ (height *root-window*) 3)) 30)
			     :left 5
			     :bottom (* 2 (floor (/ (height *root-window*) 3)))
			     :title "Hopfield Network Output"
			     :hopfield-network hn))
  (setf (input-window hn) (make-instance 'input-window 
			    :width (- (floor (/ (* 2 (width *root-window*)) 3)) 30)
			    :height (- (floor (/ (height *root-window*) 3)) 30)
			    :left 5
			    :bottom (floor (/ (height *root-window*) 3))
			    :title "Hopfield Network Input"
			    :hopfield-network hn))
  (unless (no-weight-window hn)
    (setf (weight-window hn) (make-instance 'weight-window
			       :width (- (floor (/ (* 2 (width *root-window*)) 3)) 30)
			       :height (- (floor (/ (height *root-window*) 3)) 30)
			       :bottom 5
			       :left 5
			       :title "Hopfield Network Weights"
			       :hopfield-network hn)))
  (setf (parameter-window hn) (make-instance 'parameter-window
				:title "Parameter Window"
				:hopfield-network hn
				:width (- (floor (/ (width *root-window*) 3)) 10)
				:height 360
				:left (+ 15 (floor (/ (* 2 (width *root-window*)) 3))) 
				:bottom (- (height *root-window*) 380))))


(defmethod defaults ((hn hopfield-network))
  (setf (threshold hn) 0)
  (setf (button-value (threshold-button (parameter-window hn))) 0)
  (setf (decay hn) 0)
  (setf (button-value (decay-button (parameter-window hn))) 0)
  (setf (learning-rate hn) 1)
  (setf (button-value (lrate-button (parameter-window hn))) 1)
  (setf (cycles hn) 1)
  (setf (button-value (cycle-button (parameter-window hn))) 1)
  (setf (energy hn) 0)
  (setf (asynchronous hn) nil)
  (when (string= (label (asynchronous-button (parameter-window hn))) " Asynchrone ")
      (software-push (asynchronous-button (parameter-window hn)))))
  
  


(defmethod (setf size) :after (size (hn hopfield-network))
; Not finished yet!!!!!!!!!!!!!!!!!
  (adjust-array (units hn) size
		:initial-contents (loop for i from 0 to (- size 1)
				    collect (make-instance 'unit
				      :hopfield-network hn
				      :index i)))
  (setf (connections hn)
    (loop for i from 0 to (- size 1)
      append (loop for j from (+ i 1) to (- size 1)
		 for first-unit = (aref (units hn) i)
		 for second-unit = (aref (units hn) j)
		 for k = (make-instance 'connection
			   :first-unit first-unit
			   :second-unit second-unit
			   :hopfield-network hn)
		 do (progn (setf (connections first-unit) (cons k (connections first-unit)))
			   (setf (connections second-unit) (cons k (connections second-unit))))
		 collect k)))
  (setf (energy hn) 0)
  (renew-display (input-window hn))
  (renew-display (output-window hn))
  (unless (no-weight-window hn)
    (renew-display (weight-window hn))))
  

(defmethod (setf no-weight-window) :after (value (hn hopfield-network))
  (if *debug* (format t "(setf no-weight-window) to: ~a ~%" value))
  (cond (value
	 (close-display (weight-window hn))
	 (if *debug* (format t "(close-display (weight-window hn)) ~%")))
	((not value) 
	 (if *debug* (format t "make new instance of the weight-window ~%"))
	 (setf (weight-window hn) (make-instance 'weight-window
			       :width (- (floor (/ (* 2 (width *root-window*)) 3)) 30)
			       :height (- (floor (/ (height *root-window*) 3)) 30)
			       :bottom 5
			       :left 5
			       :title "Hopfield Network Weights"
			       :hopfield-network hn))
	 (update-weight-window hn))))

(defmethod update-weight-window ((hn hopfield-network))
  (loop for i in (connections hn)
    do (update-weight-window i)))


(defmethod reset ((hn hopfield-network))
  (loop for i from 0 to (- (size hn) 1)
    do (reset (aref (units hn) i))))

(defmethod exit ((hn hopfield-network))
  (close-display (output-window hn))
  (close-display (input-window hn))
  (unless (no-weight-window hn)
    (close-display (weight-window hn)))
  (close-display (parameter-window hn))
  (setf (hopfield-network *hop*) nil)
  (excl::gc))

(defmethod update-energy ((hn hopfield-network))
  (setf (energy hn) (compute-energy hn)))




(defmethod (setf energy) :after (energy (hn hopfield-network))
;; Here a link should be made with the display for the energy
  (update (energy-window (output-window hn)) energy))



(defmethod compute-new-weights ((hp-net hopfield-network))
  (loop for i in (connections hp-net)
    do (compute-new-weight i (learning-rate hp-net) (decay hp-net) (size hp-net))))
  
    

(defmethod describe-all-weights ((hp hopfield-network))
  (loop for i in (connections hp)
    collect (weight i)))

	      

(defmethod test ((hp-net hopfield-network))
  (compute-new-activations hp-net))

(defmethod clamp ((hp-net hopfield-network) activs)
  (loop for i from 0 to (- (size hp-net) 1)
    do (progn (setf (activation (aref (units hp-net) i)) (aref activs i))
	      (setf (stable (aref (units hp-net) i)) nil))))


(defmethod step-test ((hp-net hopfield-network))
  (loop repeat (size hp-net)
      with gen = (make-instance 'generator :lower 0 :upper (- (size hp-net) 1))
      for j = (getr gen)
      do (progn (if *debug* (format t "generated: ~a" j))
		(compute-new-activation (aref (units hp-net) j) (asynchronous hp-net) (threshold hp-net))))
  (if (not (asynchronous hp-net))
      (loop for i from 0 to (- (size hp-net) 1)
	do (determine-new-activation (aref (units hp-net) i) (threshold hp-net))))
  (update-energy hp-net))

	

(defmethod compute-new-activations ((hp-net hopfield-network))
  (loop repeat 6
    do (progn (loop repeat (size hp-net)
		with gen = (make-instance 'generator :lower 0 :upper (- (size hp-net) 1))
		for j = (getr gen)
		  do (progn (compute-new-activation (aref (units hp-net) j) (asynchronous hp-net) (threshold hp-net))
			    (if *debug* (format t "j: ~a" j))))
	      (if (not (asynchronous hp-net))
		  (loop for i from 0 to (- (size hp-net) 1)
		      do (determine-new-activation (aref (units hp-net) i) (threshold hp-net))))
	      (update-energy hp-net))))




(defmethod hopfield-learn ((hp-net hopfield-network) &optional (cycles 1 cycle-flag))
  (if cycle-flag
      (loop for i from 1 to cycles
	  do (progn (when *debug* (format t "cycle ~a" i))
		    (update-cycle-button (output-window hp-net) i)
		    (compute-new-weights hp-net)))
    (loop for i from 1 to (cycles hp-net)
	do (progn (when *debug* (format t "cycle ~a" i))
		  (update-cycle-button (output-window hp-net) i)
		  (compute-new-weights hp-net)))))


(defmethod hopfield-learn-more-patterns (activation-pattern-list (hp-net hopfield-network))
  (loop for i from 1 to (cycles hp-net)
    do (loop for j in activation-pattern-list
	 do (hopfield-learn hp-net i 1))))


(defmethod compute-energy ((hp-net hopfield-network))
  (- (/ (loop for i in (connections hp-net)
	  sum (compute-energy i))
	2)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;     Some defuns to change arrays
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun make-array-into-square-array (array)
  (let ((sq (floor (sqrt (length array)))))
    (make-array (list sq sq)
		:initial-contents
		(loop for i from 0 to (- sq 1)
		    collect (loop for j from 0 to (- sq 1)
			     collect  (aref array (+ (* i sq) j)))))))
  

(defun make-one-dimensional-list-from-two-dimensional-array (array size)
  (loop for i from 0 to (- size 1)
    append (loop for j from 0 to (- size 1)
	       collect (aref array i j))))


  
(defun make-large-activation-array (array)
  ; This function makes from a one-dimensional array of size q
  ; a two-dimensional array of size (q x q).
  (make-array (list (length array) (length array))
	      :initial-contents 
	      (loop for i from 0 to (- (length array) 1)
		collect (loop for j from 0 to (- (length array) 1)
			  collect (if (= i j) 0
				      (aref array j))))))
    

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;     generator
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass generator ()
  ((ar :accessor ar
       :type array)
   (len :accessor len
	:type integer)
   (lower :accessor lower 
	  :initarg :lower
	  :type integer)
   (upper :accessor upper 
	  :initarg :upper
	  :type integer)))



(defmethod initialize-instance :after ((gen generator) &key)
; First the array must be intialized.
; Then the length of the array should be initialized
  (let ((l (1+ (- (upper gen) (lower gen)))))
    (setf (ar gen) (make-array l :initial-contents
			       (loop for x from (lower gen) to (upper gen)
				   collect x)
			       :element-type 'integer))
    (setf (len gen) l)))


    
(defmethod getr ((gen generator))
; The getr function choses a random number under the (len gen)
; then it changes the value of the (ar gen) at this number
; and then changes the (len gen)
  (declare (optimize (safety 0)(speed 3)))
  (let* ((l (1- (len gen)))
	 (a (random (1+ l)))
	 (b (aref (ar gen) a)))
    (setf (aref (ar gen) a) (aref (ar gen) l))
    (setf (len gen) l)
    b))

(defmethod getr-all ((gen generator))
  (declare (inline getr)
	   (optimize (safety 0)(speed 3)))
  (loop repeat (len gen)
    collect (getr gen)))
    

	      
	      

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;     Some test commands
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;     Still needs to be done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; There need to be implemented some consistency checking:
; After methods on "setf activations" only possible if the number of weights is also updated
; After methods on "setf weights" only possible if the number of activations is also updated
