;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-ex2.cl
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)

(defun dialog-2 (text-disp table-disp rule-disp)
  (let ((exm (make-table
	      :attributes '(profit      age         competition type)
	      :rows      '((down        old         no          software)
			   (down        midlife     yes         software)
			   (up          midlife     no          hardware)
			   (down        old         no          hardware)
			   (up          new         no          hardware)
			   (up          new         no          software)
			   (up          midlife     no          software)
			   (up          new         yes         software)
			   (down        midlife     no          hardware)
			   (down        old         yes         software))))
	(attribute 'profit)
	(*readable* t)
	(dtree nil)
	(*default-font* (findfont (width *root-window*) 1140 13)))
    (deactivate-display rule-disp)
    (table-edit exm :font *default-font* :left 10 :bottom (+ 5 (round (height *root-window*) 2))
		:title "ID3:examples")
    (format-display text-disp "~%In the <Examples> window you can see")
    (format-display text-disp "~&the table of examples. These are the")
    (format-display text-disp "~&examples of demo 1 except that the")
    (format-display text-disp "~&second last has a 'no' for")
    (format-display text-disp "~&competition. This clashes with")
    (format-display text-disp "~&example 3")
    (when (wait)
      (format-display text-disp "~%Now trying to find rules in data.")
      (format-display text-disp "~&Target attribute for classifying is")
      (format-display text-disp "~&~a ..." attribute)      (setf dtree (classify attribute exm))
      (if (and (not *accept-clashes*)
	       (plusp (clash-p exm attribute)))
	  (progn
	    (format-display text-disp "~%Generated a decision tree.")
	    (format-display text-disp "~&(see <Decision tree> window)")
	    (format-display text-disp "~&There were clashes!"))
	(progn
	  (format-display text-disp "~%Generated a decision tree.")
	  (format-display text-disp "~&(see <Decision tree> window)")))
      (setf browse (make-instance 'browser
		     :starting-tree dtree
		     :title "ID3:Decision tree"
		     :left (round (width *root-window*) 2)
		     :bottom 0
		     :font *default-font*))
      (setf (left browse) (- (width *root-window*) (width browse) 5))
      (when (wait)
	(format-display text-disp "~%Experiment with 'Accept Clashes'")
	(format-display text-disp "~&flag.")
	(format-display text-disp "~%End of demo."))
      (close-display (display browse)))
    (close-table-edit exm)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
