;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-ex5.cl
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)

(defun dialog-5 (text-disp table-disp rule-disp)
  (let ((exm (make-table
	      :attributes '(profit      age         competition type)
	      :rows      '((down        20          no          software)
			   (down        8           yes         software)
			   (up          5           no          hardware)
			   (down        18          no          hardware)
			   (up          1           no          hardware)
			   (up          2           no          software)
			   (up          6           no          software)
			   (up          3           yes         software)
			   (down        5           yes         hardware)
			   (down        15          yes         software))))
	(newexm nil)
	(attribute 'profit)
	(browse1 nil)
	(browse nil)
	(*readable* t)
	(dtree nil)
	(*default-font* (findfont (width *root-window*) 1140 13)))
    (deactivate-display rule-disp)
    (table-edit exm :font *default-font* :left 10 :bottom (+ 5 (round (height *root-window*) 2))
		:title "ID3:examples")
    (format-display-fill text-disp "In the <Examples> window you can see
                             a table of examples. Note that the
                             values for the attribute age are
                             numeric.")
    (when (wait)
      (format-display-fill text-disp (format nil "Now trying to find rules in data.
                     Target attribute is ~a ..." attribute))
      (setf dtree (classify attribute exm))
      (if (and (not *accept-clashes*)
	       (plusp (clash-p exm attribute)))
	  (format-display-fill text-disp "Generated a decision tree.
                   (see <Decision tree> window)
                   There were clashes!")
	(progn
	  (format-display text-disp "~%Generated a decision tree.")
	  (format-display text-disp "~&(see <Decision tree> window)")))
      (setf browse1 (make-instance 'browser
		      :starting-tree dtree
		      :title "ID3:Decision tree"
		      :left (round (width *root-window*) 2)
		      :bottom 0
		      :font *default-font*))
      (setf (left browse1) (- (width *root-window*) (width browse1) 5))
      (when (wait)
	(format-display-fill text-disp "The problem seems that each number
	is a distict value.  Instead we cluster
	the values into three groups,
	low medium and high.")
	(setf newexm (cluster  (copy exm) :clusters 3 :attribute 'age))
	(when (wait)
	  (format-display-fill text-disp "You see the new table in the
	  <Examples> window. Numbers have been
	  replaced!")
	  (close-table-edit exm)
	  (table-edit newexm :font *default-font* :left 10 :bottom (+ 5 (round (height *root-window*) 2))
		:title "ID3:examples")
	  (when (wait)
	    (setf dtree (classify attribute newexm))
	    (if (and (not *accept-clashes*)
		     (plusp (clash-p newexm attribute)))
		(format-display-fill text-disp "Generated a decision tree.
		  (see <Decision tree> window)
		  There were clashes!")
	      (progn
		(format-display text-disp "~%Generated a decision tree.")
		(format-display text-disp "~&(see <Decision tree> window)")))
	    (setf browse (make-instance 'browser
			   :starting-tree dtree
			   :title "ID3:Decision tree"
			   :left (round (width *root-window*) 2)
			   :bottom 0
			   :font *default-font*))
	    (setf (left browse) (- (width *root-window*) (width browse) 5))
	    (when (wait)
	      
	      (format-display text-disp "~%End of demo."))
	    (close-display (display browse)))))
      (close-display (display browse1)))
    (close-table-edit exm)
    (close-table-edit newexm)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
