;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-make.cl
;;; Short Desc: Compile & load code & documentation
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   25.4.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; Build id3
;;;


(in-package :id3)

(defvar *number-of-demos* 0)
(defvar *verbose* nil)
(defparameter *id3path* (add-subdir *pail-path* "id3"))
(defparameter *libpath* (add-subdir *pail-path* "pail-lib"))
(ensure-loaded (add-path "file-browser" *libpath*))

(ensure-loaded (add-path "rules" *libpath*))
(ensure-loaded (add-path "tables" *libpath*))
(ensure-loaded (add-path "trees" *libpath*))
(ensure-loaded (add-path "tre2rul" *libpath*))
(ensure-loaded (add-path "id3-lib" *id3path*))
(ensure-loaded (add-path "id3" *id3path*))

(if *gin-p*
    (progn
      (ensure-loaded (add-path "browser" *libpath*))
      (ensure-loaded (add-path "table-ed" *libpath*))
      (ensure-loaded (add-path "id3-dialog" *id3path*))

      (setq *number-of-demos*
	  (do* ((i 1 (1+ i))
		(name (make-pathname :name (format nil "id3-ex~a" i)
				     :type *sourcefile-type*)
		      (make-pathname :name (format nil "id3-ex~a" i)
				     :type *sourcefile-type*)))
	      ((not (probe-file (add-path name *id3path*))) (1- i))
	    (ensure-loaded (add-path name *id3path*)))))
  (ensure-loaded (add-path "id3-ascii-dialog" *id3path*)))


(format *standard-output* "~%ID3 routines loaded.~%")

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
