;;; -*- Mode: LISP; Package: GTRE; Syntax: Common-lisp;                 -*-
;;;
;;; **********************************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; **********************************************************************
;;;
;;; Filename:   jtms-dialog.cl
;;; Short Desc: "File manager" for JTMS (Taken from LEN-filemgr.cl)
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   06.02.92 - Fatma FEKIH-AHMED
;;; Author:     Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;
;;; =======================================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================================

(in-package :gtre)

(setq gi::*max-select-items* 24)

(defvar *choose-done* nil)
(defvar *canceled* nil)
(defvar *fdisp* nil)
(defvar *ex-dir-list* nil)
(defvar *files-button* nil)


(defun make-directory ()
  (setq
      *ex-dir-list* 
    (remove-if #'(lambda (fn)
		   (not  (terminates-with "-ex" fn))) 
	       (sort
		(mapcar #'file-namestring
			(directory (namestring   (excl:current-directory))))
		#'(lambda (x y) (string< x y)))))
  (if (not (null *ex-dir-list*))
      (progn 
	(documentation-print "")
	(setq *files-button* (make-instance 'select-button :label ""
					    :items *ex-dir-list* 
					    :height 400
					    :width 240
					    :exclusive t))
	(set-button *files-button* *fdisp* :left 30 :bottom 40 ))
    (progn (setq *files-button* (make-instance 'select-button :label ""
					       :items '("Sorry! No example files here")
					       :action '(lambda () (documentation-print "SORRY! NO JTMS EXAMPLES IN THIS DIRECTORY"))
					       :height 530
					       :width 240
					       :exclusive  t))
	   (set-button *files-button* *fdisp* :left 30 :bottom 40 ))))
 
(setq *fixed-font*  (cw::open-font-named "fixed"))

(defmethod choose-file-dialog ()
  (let ((dir-button       (make-instance 'push-button     :label "CHANGE DIRECTORY"))
	(copy-button       (make-instance 'push-button     :label "     COPY       "))
	(refresh-button       (make-instance 'push-button     :label "     REFRESH    "))
	(edit-file-button (make-instance 'push-button     :label "      EDIT      "))
	(view-file-button (make-instance 'push-button     :label "      VIEW      "))
	(cancel-button    (make-instance 'push-button     :label "     CANCEL     "))
	;;modifier le help-button en push-button permettant l'acces a un
	;;help-display (Cf tms-browser.cl)
	(help-button      (make-instance 'help-button     :label "      HELP      "
			    :width 140
			    :technical (add-path "jtms-view-doc.tec" pail::*jtmspath*)
			    :general (add-path "jtms-view-doc.gen" pail::*jtmspath*)
			    :subject "VIEW")))
    (setq *canceled* nil)
    (setq *choose-done* nil)
    (setq *fdisp* (make-instance 'display :height 500 :width 560
				:left 200 :bottom 100 :title "Select a file, please"))
    (make-directory)
    (set-button dir-button *fdisp* :left 330 :bottom 420
		:action `(lambda () 
			   (change-directory) 
			   (make-directory)
			   (reset-button ,dir-button)))
    (set-button refresh-button *fdisp* :left 330 :bottom 360
		:action `(lambda () 
			   (make-directory)
			   (reset-button ,refresh-button)))
    (set-button copy-button *fdisp* :left 330 :bottom 300
		:action `(lambda () 
			   (make-copy)
			   (make-directory)
			   (reset-button ,copy-button)))
    (set-button edit-file-button *fdisp* :left 330 :bottom 240
		:action `(lambda () 
			   (user::run-shell-command
			   (concatenate 'string pail-lib::*edit-command*
					(choosen-file *files-button*))
			   :wait t)
			   (reset-button ,edit-file-button)))

    (set-button cancel-button *fdisp* :left 330 :bottom 180
		:action  `(lambda nil 
			    (setq *canceled* t)
			    (deactivate-display  *fdisp*)
			    (setf *choose-done* t)
			    ))
    
    (set-button view-file-button *fdisp* :left 330 :bottom 120
		:action 
		(function (lambda nil
			    (let 
				((ch-f (choosen-file *files-button*)))
			      (if ch-f (progn 
					 (setf hh
					   (make-instance 'help-display
							 :filename (concatenate 'string
								     (namestring (excl:current-directory))
								     ch-f)
							 :from-button view-file-button
							 :bottom 100 :left 200
							 :width 700
							 :title    ch-f
							 :button-region t
							 :font *fixed-font*))
					 ))
			      (reset-button  view-file-button )))))

    (set-button help-button *fdisp* :left 330 :bottom 60)
    (mp:process-wait "waiting to exit "   #'(lambda nil *choose-done*))
    (if *canceled* "Canceled"
      (choosen-file *files-button*))))

(defun make-copy ()
  (let* ((path (ask (format nil "Enter name of new file ~%(`-ex' will be added automatically): "
			      ))
	      )
	(new-dir (pathname-directory path))
	(new-file (pathname-name path)))
    (if (directory (make-pathname :directory (reverse (cdr (reverse new-dir)))
				  :name (car (last new-dir))))
	(progn
	  (setf new-file (format nil "~a-ex" new-file))
	  (user::run-shell-command (format nil "cp ~a/~a ~a/~a"
					   (namestring (excl:current-directory))
					   (choosen-file *files-button*)
					   (namestring (make-pathname :directory new-dir))
					   new-file))
	  (user::run-shell-command (format nil "cp ~a/~a.hd ~a/~a.hd"
					   (namestring (excl:current-directory))
					   (choosen-file *files-button*)
					   (namestring (make-pathname :directory new-dir))
					   new-file))
	  (user::run-shell-command (format nil "cp ~a/~a.pail ~a/~a.pail"
					   (namestring (excl:current-directory))
					   (choosen-file *files-button*)
					   (namestring (make-pathname :directory new-dir))
					   new-file))
	       )
      (display-error
       (format nil "Directory not found - ~a" (namestring (make-pathname :directory new-dir))))
    )))
    

(defmethod choosen-file ((sb select-button))
  (let ((result (the-first-such-that #'status (items sb))))
    (if result (label result)
      result)))

(defun the-first-such-that ( pred  lis )
  (cond ((null lis) nil)
	((funcall pred (car lis)) (car lis))
	(t (the-first-such-that  pred  (cdr lis)))))

(defun complete-dirname (dirname)
  (if (terminates-with "/" dirname) dirname
    (concatenate 'string dirname "/")))

(defun terminates-with (substr str)
 (head-equal  (reverse (coerce str 'list))
	      (reverse (coerce substr 'list))))

(defun head-equal (list sublist)
  (cond ((null sublist) t)
	( (null list) nil)
	((equal (car list) (car sublist)) (head-equal (cdr list)( cdr  sublist)))))

(defun change-directory ()
  (let ((new-dir (ask (format nil "Enter directory (formerly ~a): "
			      (namestring (excl:current-directory))))))
    (if (directory (pathname new-dir))
	(excl:chdir new-dir)
      (progn
	(mp:process-wait "Directory not found"
			 #'(lambda ()
			     (eq 'Continue
				 (ack-dialog "No such file or directory"
					     :title "JTMS: Error"))))
	(excl:current-directory)))))

(defun ack-dialog (query &key (title "Please Click"))
  (let ((dw (make-instance 'display   
	     :width (if (> (cw::font-string-width *default-font* query) 185)
			(+ (cw::font-string-width *default-font* query) 20)
		      205)
	     :left 100
	     :bottom 500
	     :height 100
	     :title title))
	(done nil)
	(yb (make-instance 'push-button :label "Continue")))
    (write-display dw query 10 50)
    (set-button yb dw 
		:left (- (width dw) 100) 
		:bottom 4 
		:action (function (lambda (&rest cw-internals)
				    (declare (ignore cw-internals))
				    (setf done 'Continue))))
     (mp:process-wait "Exit"   #'(lambda nil done)) 
    (cw:flush (window dw))
    done))
    
;;; =======================================================================
;;; END OF FILE
;;; ======================================================================= 


