;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;;
;;; WIN-SHELL
;;;
;;; ************************************************************************
;;;
;;; Filename:   nmjtms-make.cl
;;; Short Desc: NMJTMS and NMJTRE from Lausanne
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   06.02.92  Fatma FEKIH-AHMED
;;; Author:     Dean ALLEMANG
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log$
;;; -------------------------------------------------------

;;; DESCRIPTION
;;; ------------------------------------------------------------------------
;;; Make file to load the entire module (code, documentation, examples...)
;;; ------------------------------------------------------------------------


(in-package :pail)

(eval-when (compile load eval)
 (ensure-loaded (add-path "global" pail-lib::*pail-lib-dir*)))

;;; ------------------------------------------------------------------------
;;; PARAMETERS
;;; ------------------------------------------------------------------------

(defparameter *gtrepath* (add-subdir *pail-path* "gtre"))
(defparameter *nmjtmspath* (add-subdir *pail-path* "nmjtms"))
 
;;; load sks-shell...
(ensure-loaded (add-path "rules" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "pool" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "trees" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "browser" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "tms-browser-specif" *gtrepath*))
(ensure-loaded (add-path "contra-specif" *gtrepath*))
(ensure-loaded (add-path "ebg-classes" (add-subdir *pail-path* "ebg")))
(ensure-loaded (add-path "ebl-jtre" *gtrepath*) :source t)
(ensure-loaded (add-path "nmjtms" *nmjtmspath*))
(ensure-loaded (add-path "util" *nmjtmspath*))
(ensure-loaded (add-path "gtre" *gtrepath*))
(ensure-loaded (add-path "nmjinterface" *gtrepath*) :force t)
(ensure-loaded (add-path "tms-browser" *gtrepath*))
(ensure-loaded (add-path "contra-browser" *gtrepath*))
(ensure-loaded (add-path "gtredefs" *gtrepath*))
;(ensure-loaded (add-path "nmjtms-new" *nmjtmspath*))

;;; run sks-shell...

(ensure-loaded (add-path "nmjtms-filemgr.cl" (add-subdir *pail-path* "nmjtms")))
(if *gin-p* 
    (ensure-loaded (add-path "nmjtms-dialog.cl" (add-subdir *pail-path* "nmjtms")))
  (ensure-loaded (add-path "nmjtms-ascii-dialog" (add-subdir *pail-path* "nmjtms"))))

(gtre::tre-init)


;;; =======================================================================
;;; END OF FILE
;;; ======================================================================= 
