;;; -*- Mode: LISP; Package: np; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   np-demo.cl
;;; Short Desc: general dialog handling for DEMOS on neural
;;;             Networks Module 
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   28.9.91 - FB
;;; Author:     Dean Allemang (after atn-demo.cl)
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :np)




;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


(defvar *pause* nil)
(defvar *quit* nil)




;;============================================================================

;; DEMO FUNCTION: Runs the demo numbered nr
;;; ==========================================================================

(defun demo (nr menu-button other-exit-button tool-button maindisp)
  (deactivate-display maindisp)
;  (disable-button menu-button)
;  (disable-button other-exit-button)
;  (disable-button tool-button)
  (let* ((dispwidth (min 400 (round (width *root-window*) 3)))
	 (dispheight (min 350 (round (height *root-window*) 2)))
	 (disp (make-instance 'display :title (concatenate 'string "NP:" (make-title-w nr))
			    :width dispwidth
			    :height dispheight
			    :borders 1
			    :left  (- (width *root-window*) dispwidth 15)
			    :bottom (- (height *root-window*) dispheight 20))))
    (setf demo-exit-button (make-instance 'push-button :label "Exit"
					  :width (round (width disp) 3)))
    (setf demo-help-button 
      (make-instance 'help-button :label "Help" :width (round (width disp) 3) 
		     :subject (concatenate 'string "Demo " (format nil "~A" nr))
		     :technical (add-path "demo-desc.asc" *nppath*)
		     :general (add-path (format nil "np-demo~A-desc.asc" nr ) *nppath*)))
   
    (setf demo-start-button (make-instance 'push-button
			      :label "Start"
			      :width (round (width disp) 3)))
    (setf demo-cont-button (make-instance 'push-button
			     :label "Continue"
			     :width (round (width disp) 3)))
   
   (setf (font disp) (cw:open-font :courier :italic 16.5 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    
    
    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 30))
    
    (setf demo-text-disp (make-instance
			  'scroll-display
			  :title "NP:Comments"
			  :font (findfont (- (width disp) 20) 375 10)
			  :parent disp
			  :width  (- (width disp) 20)
			  :height (round (height disp) 2)
			  :borders 1
			  :left 10
			  :bottom (+ 40 (height demo-cont-button) 5)))
    
    (set-button demo-exit-button disp 
		:left  (- (width disp) (round  (width demo-exit-button) .75))
		:bottom 10
		:action `(lambda ()
			   (setf *quit* t) (sleep 0.2)
			   (setq *demo-in-execution* nil)
;			   (if  *np-tool-window* (my-software-push *np-tool-exit-button* *np-tool-window*))
			   (close-display ,disp)
			   (activate-display ,maindisp)
			   (sleep 0.2)
;			   (enable-button ,menu-button)
;			   (enable-button ,other-exit-button)  
;			   (enable-button ,tool-button)
			   (close-display ,demo-text-disp)
			   
			   ))
    
    (set-button demo-help-button disp 
		:left (- (width disp) (round  (width demo-help-button) .75))
		:bottom 40
		)
    
    (set-button demo-start-button disp 
		:left (round (width demo-start-button) 3)
		:bottom 10		:action
		#'(lambda ()
		    (disable-button  demo-start-button)
		    (reset-button  demo-start-button)
		    (disable-button demo-exit-button)
		    (dialog-handler nr)))
    
    (set-button demo-cont-button disp 
		:left (round (width demo-cont-button) 3)
		:bottom 40
		:action 
		#'(lambda ()
		    (disable-button demo-exit-button)
		    (setf *pause* t)))
      ( disable-button  demo-cont-button)
    
    ))





(defun dialog-handler(nr)
  (labels ((clean-up ()
;	       (close-display demo-text-disp)
	       (unless *quit*
		 (enable-button demo-exit-button)
		 (reset-button demo-cont-button)
		 (disable-button demo-cont-button)
		 (enable-button demo-start-button)
		 (reset-button demo-start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button demo-cont-button)
	  (reset-button demo-cont-button)
	  (enable-button demo-exit-button)
	  (format-display demo-text-disp "~%<Continue>")
	  (mp:process-wait "wait-on-click" (function (lambda () (or *quit* *pause*))))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol (symbol-name (read-from-string (format nil "demo-~a" nr))) :np)))
	(if fun-sym
	    (funcall fun-sym )(progn
				(format t "Demo not implemented")
				(wait)
				(clean-up))))
      (clean-up)))







(defun make-title (nr)
  (format nil "The ~:R Demo of~% Neural~% Networks" nr))

(defun make-title-w (nr)
  (format nil "The ~:R Demo of Neural Networks" nr))





#|  |#


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
