;;; -*- Mode: LISP; Package: np; Syntax: Common-lisp;                    -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   np-exm.cl
;;; Short Desc: Examples on the network simulatior
;;; Version:    1.0
;;; Status:     Experimental (July 1990)
;;; Last Mod:   27.1.92 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;;


(in-package :np)


; ** EXAMPLE 1 *************************

(defvar my-net)

(make-net 'my-net 'net-class '(input-layer hidden-layer output-layer))

(make-node-seq my-net 'node-class  'input-layer  '(a b c d))
(make-node-seq my-net 'node-class  'hidden-layer 2)
(make-node-seq my-net 'node-class  'output-layer 4)

(connect-nodes-to-nodes 'connection-class
			(get-node-seq my-net 'input-layer)
			(get-node-seq my-net 'hidden-layer))
(connect-nodes-to-nodes 'connection-class
			(get-node-seq my-net 'hidden-layer)
			(get-node-seq my-net 'output-layer))

(traverse-node-seq (get-node-seq my-net 'output-layer)
		   n
		   (print (get-from-nodes n)))

(feed-in '(1 1 0 0) (get-node-seq my-net 'input-layer))

(cycle-with-action-each-nth-time
 30  ((synch-update (get-node-seq my-net 'hidden-layer))
      (synch-update (get-node-seq my-net 'output-layer)))
 10  ((print (feed-out (get-node-seq my-net 'output-layer)))))

(print (activation a))
(print (activation b))
(print (activation c))
(print (activation d))


; ** EXAMPLE 2 *************************

(make-net 'a-net 'feed-forward-net-class '(layer1 layer2 layer3))

(make-node-seq a-net 'node-class  'layer1 4)
(make-node-seq a-net 'node-class  'layer2 4)
(make-node-seq a-net 'node-class  'layer3 4)

(make-net 'b-net 'feed-forward-net-class '(layer1 layer2 layer3))

(make-node-seq b-net 'node-class  'layer1 4)
(make-node-seq b-net 'node-class  'layer2 4)
(make-node-seq b-net 'node-class  'layer3 4)

(make-net 'super-net 'net-class '(inlayer outlayer))

(push-nodes-in-node-seq super-net 'inlayer 
			(concatenate-node-seqs
			    (get-node-seq a-net 'layer1)
			    (get-node-seq b-net 'layer1)))

(push-nodes-in-node-seq super-net 'outlayer 
			(concatenate-node-seqs
			    (get-node-seq a-net 'layer3)
			    (get-node-seq b-net 'layer3)))


(print-net a-net)
(print-net b-net)
(print-net super-net)

			 
; ** EXAMPLE 3 *************************

(make-net 'a-net 'feed-forward-net-class '(layer1 layer2 layer3))

(make-node-seq a-net 'node-class  'layer1 4)
(make-node-seq a-net 'node-class  'layer2 4)
(make-node-seq a-net 'node-class  'layer3 4)

(make-net 'b-net 'feed-forward-net-class '(layer1 layer2 layer3))

(make-node-seq b-net 'node-class  'layer1 4)
(make-node-seq b-net 'node-class  'layer2 4)
(make-node-seq b-net 'node-class  'layer3 4)

(connect-nodes-to-nodes 'connection-class
			(get-node-seq a-net 'layer3)
			(get-node-seq b-net 'layer1))


; ** EXAMPLE 4 *************************

(setf a (make-node nil 'node-class nil))
(setf b (make-node nil 'node-class nil))

(make-connection 'connection-class a b)


; ** EXAMPLE 4 *************************

(defvar graphic-test-net)

(make-net 'graphic-test-net 'feed-forward-net-class 
	  '(output-layer hidden-layer input-layer))

(make-node-seq graphic-test-net 'node-class  'input-layer  7)
(make-node-seq graphic-test-net 'node-class  'hidden-layer 4)
(make-node-seq graphic-test-net 'node-class  'output-layer 5)

(connect-nodes-to-nodes 'connection-class
			(get-node-seq graphic-test-net 'input-layer)
			(get-node-seq graphic-test-net 'hidden-layer))
(connect-nodes-to-nodes 'connection-class
			(get-node-seq graphic-test-net 'hidden-layer)
			(get-node-seq graphic-test-net 'output-layer))

(setf graphics (make-instance 'net-graphics))
(init graphics graphic-test-net)
(open-activation-display graphics)
(open-weight-display graphics)

(progn
  (feed-in '(1 0 1 0 1 1 1) (get-node-seq graphic-test-net 'input-layer))
  (show-activities graphics))

(cycle 10
       (dolist (layer (cdr (reverse (get-node-seq-names graphic-test-net))))
	 (synch-update (get-node-seq graphic-test-net layer)))
       (show-activities graphics))
       
(show-weights graphics)

(close-activation-display graphics)
(close-weight-display graphics)

; ** EXAMPLE 5 *************************

(defvar a-bp-net)

(bp-make-net 'a-bp-net '((out 4) (hl 2) (in 4)))

(setf graphics (make-instance 'net-graphics))
(init graphics a-bp-net :max-weight 15)
(open-activation-display graphics)
(open-weight-display graphics)

(setf samples '(((0 0 0 1) (0 0 0 1))
		((0 0 1 0) (0 0 1 0))
		((0 1 0 0) (0 1 0 0))
		((1 0 0 0) (1 0 0 0))))

(learn-till-tolerable a-bp-net samples)

(show-activities graphics :arrows-p t)
(show-weights graphics)

(dolist (train-pair samples)
  (compute-net-output a-bp-net (car train-pair))
  (show-activities graphics)
  (format t "~%[Press Return]")
  (read-char))

; (save-net a-bp-net)
; (load-net a-bp-net)

(close-activation-display graphics)
(close-weight-display graphics)


; ** Example  6 ************************


(defvar test424)

(bp-make-net 'test424 '((out-layer 4)
			(hidden-layer 2)
			(in-layer 4)))

(setf (l-rate test424) 0.5)
(setf (momentum test424) 0.9)

(progn 
  (defvar input)
  (with-open-file (input (add-path "424.wt" *nppath*))
    (traverse-all-weights test424 conn (setf (weight conn) 
                                          (read input)))))

(time
 (learn-till-tolerable test424 
		       '(((1 0 0 0) (1 0 0 0))
			 ((0 1 0 0) (0 1 0 0))
			 ((0 0 1 0) (0 0 1 0))
			 ((0 0 0 1) (0 0 0 1))) 
		       '(out-layer hidden-layer in-layer) 
		       :error-tolerance  0.4
		       :max-count 500))

(cycle-with-action-each-nth-time 1
				 ((learn-till-tolerable test424 
						     '(((1 0 0 0) (1 0 0 0))
						       ((0 1 0 0) (0 1 0 0))
						       ((0 0 1 0) (0 0 1 0))
						       ((0 0 0 1) (0 0 0 1))) 
						     '(out-layer hidden-layer in-layer) 
						     :error-tolerance  0.4
                                                     :max-count 252))
				 1
				 ((print-net test424 :with-connections t)))


(cycle-with-action-each-nth-time 1
				 ((learn-till-tolerable test424 
						     '(((0 0 0 1) (0 0 0 1))
						       ((0 0 1 0) (0 0 1 0))
						       ((0 1 0 0) (0 1 0 0))
						       ((1 0 0 0) (1 0 0 0))) 
						     '(out-layer hidden-layer in-layer) 
						     :error-tolerance  0.2))
				 1
				 ((print-net test424 :with-connections t)))


(print-net test424 :with-connections t)

(dolist (i '((0 0 0 1) (0 0 1 0) (0 1 0 0) (1 0 0 0)))
  (print (compute-net-output test424 i)))

(compute-net-output test424 '(1 0 0 0))


(compute-activation (second (get-node-seq test424 'hidden-layer)))
(output (second (get-node-seq test424 'in-layer)))


; ******************************************************************************