;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   make-scroll-display.cl
;;; Short Desc: example file of the usage of displays that have a
;;; 		scroll-region and a static scrollbar. 
;;; Author:	NA
;;; INTERNAL only
;;; ==========================================================================

(use-package :gin)

;(format t "; Now click any mouse-button...")
(setf disp (make-display :title "This is a scroll-display"
			 :display-type 'scroll-display
			 :button-region t
			 :bottom 400))

;;; ==========================================================================
;;; When you create a SCROLL-DISPLAY with the method make-display you can
;;; specify the following keyword arguments:
;;;
;;;		:display-type 'scroll-display
;;;			This keyword argument is necessary to create a
;;;			scroll-display. You can specify any other
;;;			keyword arguments that are applicable for
;;;			displays (see the file make-display.cl).
;;;			Furthermore you can specify whether you want a
;;;			button region on the bottom of the display. If
;;;		:button-region is T then the scrollable region will be
;;;			31 points up from the bottom of the display.
;;;			Second a button width the label "Close" will
;;;			be set into the display on the right/bottom
;;;			corner of the display (with offset 5). If you
;;;			click into this button the display will be
;;;			closed and the button that was specified with
;;;			the :from-button keyword will be reset.
;;;		:from-button - the button to be reset upon exiting the
;;;			scroll-display (with the close-button).
;;;		:font	- the font for the display that is used for
;;;			anything but buttons. The default is
;;;			*default-font* (Courier bold 13). If you want
;;;			to modify the font of the scrollable region
;;;			you have to use the following command:
;;;			(setf (font (scroll-region *my-scroll-disp*)) *some-other-font*)
;;;			NOTE: Do not change the font while writing
;;;			into the scroll-region. The refresh method will
;;;			not work as expected. You can change the font
;;;			after a clear-scroll of the scroll-display.
;;;			This resets the content of the scrollable
;;;			region.

(dotimes (i 40) (format-display disp "Look, this is the Line Nr. ~a" i))

;;; With the function format-display you can write into the scrollable
;;; region. WARNING: do not write lines that are longer than the
;;; available space (i.e. the condition (> (inner-width *my-scroll-display*) 
;;; (font-string-width (font (scroll-region *my-scroll-display*)))) must
;;; be true) in the scroll-region: the refresh-function will get 
;;; confused otherwise. To prevent unusual behavior, widen the
;;; inner-width of the scroll-display and set x-scrollbar to T. This
;;; will prevent the scroll-region from breaking the lines, and you can
;;; still see the hidden text by scrolling the scroll-display
;;; horizontally. NOTE: the function format-display takes the same
;;; arguments like format, and writes an extra newline at the end of
;;; the line. You can not (YET) turn that off. When the bottom of the
;;; scrollable region is reached, the scroll-extent is enlarged and
;;; the text is scrolled up. No lines will be deleted. You have
;;; explicitly delete ALL lines with the following function:

;;;		(clear-scroll disp)

;;; the function clear-scroll will clear only the scrollable region of
;;; the display. 

(setf disp1 (make-display :title "another scroll-display..."
			  :left 200 :bottom 300 :width 200 :height 100
			  :inner-width 500 :x-scrollbar t
			  :display-type 'scroll-display
			  :button-region nil))

(dotimes (i 40) (format-display disp1 "Look, this is a very LOOOOOONG Line Nr. ~a" i))

;;; NOTE: the function `format-display' and `clear-scroll' work for
;;; scroll-displays in the way it was just demonstrated. If you pass
;;; some other argument than a scroll-display to `format-display' this
;;; function works like the well-known format. 
;;; E.g. (format-display t "Hello") just writes "Hello" to the
;;; standard-output and returns nil. The function `clear-scroll' does
;;; nothing with anything other than a scroll-display.

;;; ==========================================================================
;;; When you create a HELP-DISPLAY with the method make-display you can
;;; specify the following keyword arguments:
;;;
;;;		:display-type 'help-display
;;;			This keyword argument is necessary to create a
;;;			help-display. Since the CLOS object
;;;			help-display is a subclass of scroll-display
;;;			you can specify any other keyword arguments
;;;			that are applicable for displays or
;;;			scroll-displays (see the above paragraph).
;;;			Furthermore you can specify the help-filename
;;;			to be displayed in the scrollable region of
;;;			the display.
;;;		:filename "some-file"
;;;
;;; The formatting characters << and >> that are interpreted in the
;;; help-stream are ignored in the help-display. The (setf filename)
;;; function is also available for help-displays.