;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   radio-button.cl
;;; Short Desc: example file of the usage of radio-buttons
;;; Author:	NA
;;; INTERNAL only
;;; ==========================================================================

(use-package :gin)

(format t "; Now click any mouse-button...")
(setf disp (make-display :title "radio-buttons"))

(setf exit-button (make-instance 'push-button :label "Exit"))
(set-button exit-button disp :left 343 :bottom 5
	    :action `(lambda nil (close-display ,disp)))


(write-display disp "Which movie(s) do you want to see?" 5 257)

(setf children (make-instance 'radio-button :label "Bring the children" :status t))
(setf soap     (make-instance 'radio-button :label "Soap opera"))
(setf porn     (make-instance 'radio-button :label "Porno" :inhibit-buttons (list children)))

;;; The method make-instance of radio-button accepts the following
;;; keyword arguments:
;;;		:width	- the width of the button (default 10)
;;;		:height	- the height of the button (default 10)
;;;		:label	- the label that appears 10 points to the
;;;			right of the box (the default label is
;;;			"select")
;;;	      ( :bitmap	- this option is ignored )
;;;		:action	- a symbol that evaluates to a function that
;;;			must not accept any arguments. You can also
;;;			use lambda functions that are quoted with a
;;;			back-quote to select some arguments with the
;;;			"," to be avaluated. (default is nil - no
;;;			function will be called upon button press)
;;;		:inhibit-buttons - a list of buttons that are disabled
;;;			and cleared (status becomes NIL) whenever this
;;;			button's status is set to T. (the default is
;;;			nil)
;;;		:status	- the status of the Button (the default is
;;;			nil) 
;;;
;;; The status of the buttons that are passed with the keyword
;;; :inhibit-buttons will be set to NIL and and the buttons will
;;; become disabled if one clicks in this button. If you set the
;;; button to NIL later, these (inhibited) buttons are again enabled
;;; but the status is left NIL


(set-button children disp :left 180 :bottom 200)
(set-button soap disp :left 10 :bottom 200)
(set-button porn disp :left 10 :bottom 220)

;;; The method set-button of radio-button accepts the following
;;; keyword arguments:
;;;		:left	- the distance between the left side of the
;;;			button and the left border of the display
;;;			(default is 0)
;;;		:bottom	- the distance between the bottom side of the
;;;			button and the bottom border of the display
;;;			(default is 0) 
;;;		:active	- a flag wether the button will be enabled
;;;			after the set-button. If called with NIL the
;;;			button must later be enabled with the method
;;;			enable-button. (default is T)
;;;		:action	- a symbol that evaluates to a function that
;;;			must not accept any arguments. You can also
;;;			use lambda functions that are quoted with a
;;;			back-quote to select some arguments with the
;;;			"," to be avaluated. (default is nil - no
;;;			function will be called upon button press
;;;			unless a value was specified at make-instance
;;;			of the button) The previous value of the slot
;;;			action that was assigned with the method
;;;			make-instance is discarded.
;;;
;;; NOTE: you can not toggle a radio-button with the method
;;; toggle-button (or set to status NIL with the method clear-button)
;;; if this button is disabled.

(draw-line disp 0 181 (width disp) 181)

;;; ==========================================================================

(write-display disp "Please check your sex" 5 145)
(defvar *sex* :undefined)

(setf girl (make-instance 'radio-button :label "Girl"))
(setf boy (make-instance 'radio-button :label "Boy"))

(set-button girl disp :left 240 :bottom 145 :action '(lambda nil (setf *sex* :feminin)))
(set-button boy disp :left 240 :bottom 125 :action '(lambda nil (setf *sex* :masculine)))

(set-exclusive girl boy)

;;; The function set-exclusive allows only one button of the the given
;;; arguments to become active. Please note that the function
;;; set-exclusive must only be called AFTER the set-button of the
;;; exclusive buttons was performed.

;;; WARNING: The function that is passed with the :action keyword is
;;; called every time the button is clicked (not only if the status is
;;; set to T). Therefore the statement "(setf *sex* :masculine)" is
;;; generally NOT correct. You should write "(setf *sex* (if (status
;;; boy) ':masculine ':feminin))" instead.  In this case however,
;;; the two buttons (girl, boy) are mutually exclusive, all other
;;; buttons in the exclusive-list are first set to NIL - then the
;;; clicked button is set T and the action (setf *sex*  ... ) is
;;; executed.


;;; More possibilities:

;(disable-button girl)
;(enable-button girl)
;(unset-button girl)
;(set-button girl disp)

;(clear-button girl)
;(toggle-button girl)