;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp; -*-
;;;
;;; ************************************************************************
;;; PORTABLE AI LAB - UNI ZH
;;; ************************************************************************
;;;
;;; Filename:   animate.cl
;;; Short Desc: Classes to describe animation world
;;; Version:    0.1
;;; Last Mod:   3.2.92 DTA
;;; Status:     Provisional
;;; Author:     DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; ------------------------------------------------------------------------
;;; Change History:
;;;    
;;; ========================================================================


(in-package :pail-lib)

(export '(world-desc animation-type animation-info))

(defclass world-desc ()
	  ((animation-type :accessor animation-type
			   :initarg :animation-type
			   :initform nil
			   :type string)
	   (animation-info :accessor animation-info
			   :initarg :animation-info
			   :initform nil
			   :type list)))



(defmethod change-type ((a world-desc) (b world-desc)) a)

(defmethod change-type ((wm working-memory) (world world-desc))
  (make-instance 'world-desc
    :animation-type (ask "What sort of world is being animated?")
    :animation-info (assertions wm)))




(defmethod dump-editable ((w world-desc))
  (concatenate 'string
    (format nil "(~%")
    (format nil "    (TYPE   \"~a\")~%" (animation-type w))
    (format nil "    (INFO   ~a)~%)" (animation-info w))))
	       


(defmethod read-instance ((item world-desc) desc name)
  (progn
    (setf (animation-type item) (cadar desc))
    (setf (animation-info item) (cadar (cdr desc)))
    item))


;;; ==========================================================================
;;; * END OF FILE *
;;; ==========================================================================


