;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp;              -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   table-ed.cl
;;; Short Desc: object oriented editor for tables
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   17.7.92 - DTA
;;; Author:     DTA, some code taken from TW version
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;; --------------------------------------------------------------------------
;;; 
;;; --------------------------------------------------------------------------
;;;



;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :pail-lib)

;(export '(make-editor-fcn refresh))


(defclass table-editor ()
	  ((display    :initarg :display
		       :accessor display)
	   (table :initarg :table
		  :accessor table)
	   (font  :initarg :font
		       :accessor font
		       :initform *default-font*)
	   (cell-font  :initarg :cell-font
		       :accessor cell-font
		       :initform *default-font*)
	   (cell-width :initarg :cell-width
		       :accessor cell-width
		       :initform 12)
	   (offset-x   :initarg :offset-x
		       :accessor offset-x
		       :initform (* 10 (font-character-width *default-font*)))
	   (menu-items :initarg :menu-items
		       :accessor menu-items
		       :initform nil)
	   (user-items :initarg :user-items
		       :accessor user-items
		       :initform nil)
	   (close-all  :initarg :close-all
		       :accessor close-all)
	   (data-buttons :accessor data-buttons)
	   (heading-buttons :accessor heading-buttons)
	   (row-buttons :accessor row-buttons)))


(defmethod initialize-instance :after ((editor table-editor) &key
				(left nil)
				(bottom nil)
				(title "Table Editor")
				)
  (with-accessors ((display display)
		   (table table)
		   (cell-font cell-font)
		   (cell-width cell-width)
		   (offset-x offset-x)
		   (menu-items menu-items)
		   (user-items user-items)
		   (data-buttons data-buttons)
		   (heading-buttons heading-buttons)
		   (row-buttons row-buttons)
		   (font font))
      editor
		   
    (let* ((*value-button-border-p* t)
	  (x (length (attributes table)))
	  (y (number-of-rows table))
	  (gab 6)
	  (dist 20)
	  (choice-width 10)
	  (b-width (* cell-width (font-character-width cell-font)))
	  (b-height (if (eq cell-font *small-font*) ; strange behavior with small fonts
			(+ 2 (+ 6 (font-character-height cell-font)))
		      (+ 6 (font-character-height cell-font))))
	  (offset-y (* 2 (+ 6 (font-character-height font))))
	  (help-button (make-instance 'push-button :label "Help"
					      :font font
					      :width (* choice-width (font-character-width font))
					      :height (+ 6 (font-character-height font))))
	  (menu-button (make-instance 'pop-up-button :label "Menu"
					      :font font
					      :width (* choice-width (font-character-width font))
					      :height (+ 6 (font-character-height font))))
	  (refresh-button (make-instance 'push-button :label "Refresh"
						 :font font
						 :width (* choice-width (font-character-width font))
						 :height (+ 6 (font-character-height font))))
	  (exit-button (make-instance 'push-button :label "Exit"
					      :font font
					      :width (* choice-width (font-character-width font))
					      :height (+ 6 (font-character-height font))))
	  (names (let ((l nil))
			   (dotimes (i y (reverse l))
			     (setf l (cons (1+ i) l)))))
	  menu)

  
      (setf menu-items `(
			 (
			  "Add Attribute"
			  (lambda ()
			    (let ((attr (intern-all
					 (read-from-string (ask "Please enter the attribute.~%=> ")) :dump)))
			      (if (member attr (attributes ,table) :test #'equal)
				  (display-error "Attribute already exists!")
				(progn
				  (setf (attributes ,table)
				    (append
				     (attributes ,table)
				     (list attr)))
				  (loop
				      for drow in (data-buttons ,editor)
				      as trow in (rows ,table)
				      as nr from 1
				      do

					(progn (nconc trow
						      (list
						       (intern-all
							(read-from-string
							 (ask 
							  (format nil "Enter value for example ~a.~%=> " nr)))
							:dump)))

					       (nconc drow
						      (list (make-instance 'value-button
							      :numeric nil
							      :font ,cell-font
							      :width ,b-width
							      :value (all-symbol-names (car (last trow))))
							    )
						      )
					       )
				    )
				  (nconc (heading-buttons ,editor)
					 (list (make-instance 'value-button
							 :numeric nil
							 :font ,cell-font
							 :width ,b-width
							 :value (all-symbol-names
								 (car (last (attributes ,table)))))))
				  ))
			      (refresh ,editor)))
			  "Add a new attribute and it's values to the table")
			 (
			  "Delete Attribute"
			  (lambda ()
			    (unless (null (attributes ,table))
			      (let* ((attr (accept-items (make-instance 'menu
							   :items
							   (mapcar (function (lambda (attr)
									       (list (all-symbol-names attr)
										     (write-to-string attr))))
								   (attributes ,table)))))
				     (pos (search
					   (list attr)
					   (attributes ,table)
					   :test #'(lambda (y x ) (equal x (write-to-string y))))))
				(when pos
				  (progn
				    (setf (attributes ,table)
				      (remove-nth pos (attributes ,table)))
				    (setf (rows ,table)
				      (mapcar (function (lambda (row)
							  (remove-nth pos row)))
					      (rows ,table)))
				    (loop for i from pos to (1- (length (heading-buttons ,editor)))
					do (unset-button (nth i (heading-buttons ,editor))))
				    (loop for row in (data-buttons ,editor) do
					  (loop for i from pos to (1- (length row))
					      do (unset-button (nth i row))))
				    (setf (data-buttons ,editor)
				      (mapcar (function (lambda (row)
							  (remove-nth pos row)))
					      (data-buttons ,editor)))
				    (setf (heading-buttons ,editor)
				      (remove-nth pos (heading-buttons ,editor)))
				    (refresh ,editor))))))
			  "Delete an attribute and it's values")
			 (
			  "Add Example"
			  (lambda ()
				      (setf (rows ,table)
					(append
					 (rows ,table)
					 (list
					  (mapcar (function (lambda (attr)
							      (intern-all
							       (read-from-string
								(ask (format nil "Enter value for attribute ~a.~%=> " attr))) :dump)))
						  (attributes ,table)))))
				      (refresh ,editor))
			  "Add a new example (a row) to the table")
			 ( "Delete Example"
			       (lambda ()
					   (let ((pos nil))
					     (setf pos
					       (read-from-string
						(ask "Please enter the number of the example.~%=> "
						     :condition 
						     (function (lambda (string)
								 (let ((x (read-from-string string nil)))
								   (and (numberp x) (integerp x) (>= x 0)))))
						     :error-message "The example has to be identified with a number.")))
					     (if (and (plusp pos) (<= pos (number-of-rows ,table)))
						 (progn
						   (setf (rows ,table)
						     (remove-nth (1- pos) (rows ,table)))
						   (refresh ,editor))
					       (display-error "Example does not exist!"))))
			       "Delete an example (a row)")))
      (setf menu (make-instance 'menu
		   :items (if menu-items menu-items '(("No menu" (function (lambda ())))))))
      (setf display (make-instance 'display
		      :title title
		      :width (max
			      (+ offset-x 1 (* x b-width))
			      (+ (* 4 (* choice-width (font-character-width font)))
				 (* 5 dist)))
		      :height (+ offset-y 1 (* (1+ y) b-height) gab 1)
		      :font font
		      :left (if left left 10)
		      :bottom (if bottom bottom
				(- 574 (+ offset-y 1 (* (1+ y) b-height) gab 1)))))
      (setf heading-buttons (loop for i from 0 to (1- x)
				collect
				  (let ((button (make-instance 'value-button
						  :numeric nil
						  :font cell-font
						  :width b-width
						  :value (all-symbol-names
							  (nth i (attributes table))))))
				    (set-button button display
						:left (+ offset-x (* i b-width))
						:bottom (- (height display)
							   offset-y 1 b-height 1)
						:action 
						`(lambda ()
						   (let ((new-val (intern-all (read-from-string (button-value ,button) nil) :dump)))
						     (if (and (member new-val (attributes ,table) :test #'equal)
							      (not (equal new-val (nth ,i (attributes ,table)))))
							 (progn
							   (display-error "Attribute already exists!")
							   (setf (button-value ,button) (nth ,i (attributes ,table))))
						       (setf (nth ,i (attributes ,table)) 
							 new-val))))))))
      (setf data-buttons
	(loop for j from 0 to (1- y) collect
	      (loop for i from 0 to (1- x) collect
		    (let ((button (make-instance 'value-button
				    :numeric nil
				    :font cell-font
				    :width b-width
				    :value (all-symbol-names (get-xy-value i j table)))))
		      (set-button button display
				  :left (+ offset-x (* i b-width))
				  :bottom (- (height display)
					     offset-y 1
					     (* (1+ j) b-height)
					     b-height gab 1)
				  :action 
				  `(lambda ()
				     (set-xy-value ,i ,j ,table
						   (intern-all
						    (read-from-string
						     (button-value ,button) nil)
						    :dump))))))))

      (when (plusp offset-x)
	       (write-display display "Examples" 8 (- (height display)
						   offset-y
						   b-height -5) :font cell-font)

	       (dotimes (j y)
		 (write-display display
				(format nil "~6@a" (nth j names))
				10 (- (height display) offset-y  1 (* (+ j 2) b-height) 1) :font cell-font))

	       (draw-line display
			  (- offset-x 3)
			  0
			  (- offset-x 3)
			  (- (height display) offset-y)))
      (draw-line display
			0
			(- (height display)
			   offset-y -1)
			(width display)
			(- (height display)
			   offset-y -1))
      (draw-line display 
			0
			(- (height display)
			   offset-y 1
			   (+ b-height (/ gab 2)) 1)
			(width display)
			(- (height display)
			   offset-y 1
			   (+ b-height (/ gab 2)) 1))
      
      (set-button help-button display
			 :left (+ (* 0 (+ (* choice-width (font-character-width font)) dist)) dist)
			 :bottom (- (height display)
				    (round (/ (- offset-y b-height) 2))
				    b-height)
			 :action #'(lambda nil 
				     (make-instance 'help-stream
				       :filename (add-path
						  "table-ed.asc"
						  (add-subdir *pail-path* "pail-lib"))
				       :from-button help-button)))
      (setf (menu menu-button) menu)
      (set-button menu-button display
			 :left (+ (* 1 (+ (* choice-width (font-character-width font)) dist)) dist)
			 :bottom (- (height display)
				    (round (/ (- offset-y b-height) 2))
				    b-height)
			 :action #'(lambda nil))
      (set-button refresh-button display 
			 :left (+ (* 2 (+ (* choice-width (font-character-width font)) dist)) dist)
			 :bottom (- (height display)
				    (round (/ (- offset-y b-height) 2))
				    b-height)
			 :action `(lambda () (refresh ,editor) (reset-button ',refresh-button)))
      (set-button exit-button display 
			 :left (+ (* 3 (+ (* choice-width (font-character-width font)) dist)) dist)
			 :bottom (- (height display)
				    (round (/ (- offset-y b-height) 2))
				    b-height)
			 :action #'(lambda ()
				     (close-display display)
				     ))
      table
      
      )))
  
  
(defmethod refresh ((ed table-editor))
  (let* ((y (length (data-buttons ed)))
	 (x (length (car (data-buttons ed))))
	 (cell-font (cell-font ed))
	 (display (display ed))
	 (table (table ed))
	 (dist 20)
	 (choice-width 10)
	 (font (font ed))
	 (offset-x (offset-x ed))
	 (gab 6)
	 (b-width (* (cell-width ed) (font-character-width cell-font)))
	 (b-height (if (eq cell-font *small-font*) ; strange behavior with small fonts
		       (+ 2 (+ 6 (font-character-height cell-font)))
		     (+ 6 (font-character-height cell-font))))
	 (offset-y (* 2 (+ 6 (font-character-height font))))
	 )
					;    (inspect ed)
    (setf (width display) (max
			   (+ offset-x 1 (* x b-width))
			   (+ (* 4 (* choice-width (font-character-width font)))
			      (* 5 dist))))
    (setf (height display) (+ offset-y 1 (* (1+ y) b-height) gab 1))
    (draw-line display
	       0
	       (- (height display)
		  offset-y -1)
	       (width display)
	       (- (height display)
		  offset-y -1))
    (draw-line display 
	       0
	       (- (height display)
		  offset-y 1
		  (+ b-height (/ gab 2)) 1)
	       (width display)
	       (- (height display)
		  offset-y 1
		  (+ b-height (/ gab 2)) 1))
      
    (loop for i from 0 to (1- x)
	collect
	  (let ((button (nth i (heading-buttons ed))))
	    (unless (status button)
	      (set-button button display
			  :left (+ offset-x (* i b-width))
			  :bottom (- (height display)
				     offset-y 1 b-height 1)
			  :border 1
			  :action 
			  `(lambda ()
			     (let ((new-val (intern-all (read-from-string (button-value ,button) nil) :dump)))
			       (if (and (member new-val (attributes ,table) :test #'equal)
					(not (equal new-val (nth ,i (attributes ,table)))))
				   (progn
				     (display-error "Attribute already exists!")
				     (setf (button-value ,button) (nth ,i (attributes ,table))))
				 (setf (nth ,i (attributes ,table)) 
				   new-val))))))))
    
    
    (loop for j from 0 to (1- y) collect
	  (loop for i from 0 to (1- x) collect
		(let ((button (nth i (nth j (data-buttons ed)))))
		  (unless (status button)
		    (set-button button (display ed)
				:left (+ offset-x (* i b-width))
				:bottom (- (height display)
					   offset-y 1
					   (* (1+ j) b-height)
					   b-height gab 1)
				:border 1
				:action 
				`(lambda ()
				   (set-xy-value ,i ,j ,table
						 (intern-all
						  (read-from-string
						   (button-value ,button) nil)
						  :dump))))))))))




;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
