;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   blocks.cl
;;; Short Desc: Description of blocks world
;;; Version:    0.1
;;; Status:     Provisional
;;; Last Mod:   14.1.92 DTA
;;; Author:     Wan, Allemang
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
;;;  Only blocks world descriptions can be animated, so the main
;;;  animation functions appear here. 
;;;
;;; blocks world domain
;;; for PAIL planners

(in-package :planning)

(export '(animate-plan))

(defparameter *blocks-world-ops* nil)
(defparameter *plain-ops* nil)

(load-file-no-questions (add-path "plain-ops" (add-subdir *pail-path* "pool")))

(setf *plain-ops* (pool-find-object *pail-pool* "plain-ops"))

(setf *a-b-c* (pool-find-object *pail-pool* "a-b-c"))

(setf *b/a-on-c* (pool-find-object *pail-pool* "a-on-c"))

(setf *sussf* (pool-find-object *pail-pool* "sussf"))

(setf *final* (pool-find-object *pail-pool* "final"))

(setf *abcblocks* (pool-find-object *pail-pool* "abcblocks"))

(setf *blocks-world-ops* (pool-find-object *pail-pool* "how-to-put"))

(setf *b-a-c* (pool-find-object *pail-pool* "b-a-c"))

(setf *a-b-c-start* (pool-find-object *pail-pool* "a-b-cstart"))

(setf *ab* (pool-find-object *pail-pool* "a-b"))

(setf *abba* (pool-find-object *pail-pool* "abba"))



(defun b-test0 ()
  (use-ops *blocks-world-ops*)
  (use-world *abcblocks*)
  (solve (assertions *a-b-c*) (assertions *final*)))


(defun b-test1 ()
  "This is the Sussman Anomaly"
  (use-ops *blocks-world-ops*)
  (use-world *abcblocks*)
  (solve (assertions *b/a-on-c*) (assertions *sussf*)))

(defun b-test2 ()
  (use-ops *blocks-world-ops*)
  (use-world *abcblocks*)
  (solve (assertions *a-b-cstart*)
	 (assertions *b-a-c*)))

(defun b-test3 ()
  (use-ops *blocks-world-ops*)
  (use-world *abcblocks*)
  (solve (assertions *ab*)
	 (assertions *abba*)))


(defmethod animate-plan (world start plan display)
  (when *animate* (display-error "No animation possible." :wait nil)))

(defmethod animate-plan ((world world-desc) start plan (display block-display))
;;; start is the starting state from which the plan begins, specified
;;; as other states are, lists like ((on x y)).  In order
;;; to set this up on the screen, I use tweak from a very easy
;;; starting state.  plan is a set of steps to be executed, from one
;;; of the planners.  It must be consistent with the given world.  
  
  (when *animate*
    (let (cover
	  (lstart (loop for goal in start
			      when (equal (string-upcase (format nil "~a" (car  goal))) "ON")
			      collect goal))
	  (no-tables 1)
	  (current-planner planning::*current-planner*)
	  (current-ops planning::*ops*))
      (use-planner snlp::*tweak-planner*)
      (use-ops *plain-ops*)

      (clear-display display)
      (draw (hand display))
      (setf cover (make-instance 'display :parent display
					   :height (height display)
					   :width (width display)
					   :left 0 :bottom 0))
      (write-display cover "Please wait: the animation is being prepared"
				(truncate (- (width cover)
					  (font-string-width
					   *default-font*
					   "Please wait: the animation is being prepared"
					   )) 2)
				(truncate (height  cover) 2))

    
      (when (or (null (init-plan display)) (not (equal (start-state display) lstart)))
	(setf (init-plan display) (snlp:plan-steps (solve (virgin world) lstart)))
	(setf (start-state display) lstart)
	) 


      (if (init-plan display)
	  (progn (loop for object in (animation-info world) do
		       (if  (equal (string-downcase (format nil "~a" (cadr object))) "table")
			   (progn
			     (setf (cddr object) (make-instance 'support-table
						   :name (car object)
						   :position (list  1 (* 5
									 *blocksize* (1- no-tables)))
						   :display display))
			     (setf no-tables (1+ no-tables)))
			 (setf (cddr object) (make-instance 'brick
					       :name (car object)
					       :position (list 0 0)
					       :display display)
			       )))
		 (setf (height *movie-window*) (+ 5 (* 5 *blocksize* (1- no-tables))))
		 (setf (hand-home *movie-window*) (list 0 (- (height *movie-window*) 6)))
		 (let ((*handwait* 0.0))
		   (playback (init-plan display) world display))
		 (close-display cover)
		 (sleep 5)
		 (playback plan world display))
	(progn (write-display display "Animation unavailable."
				(truncate (- (width cover)
					  (font-string-width
					   *default-font*
					   "Animation unavailable"
					   )) 2)
				(truncate (height  cover) 2))
	       (close-display cover)))
      (use-planner current-planner)
      (use-ops current-ops)
      ))
  )



(defmethod virgin ((world world-desc))
  (loop for object in (animation-info world) append `((dump::on ,(car object) dump::x) (dump::clear ,(car object)))))

(defmethod playback (plan (world world-desc) (display block-display))
  (loop for action in plan do
	(when (not (equal (string-downcase (format nil "~a" action)) "begin"))
	  (format t "~a" `(put-on ,(cddr (assoc (cadr action) (animation-info world)))
				  ,(cddr (assoc (caddr action) (animation-info world)))))
	  (put-on (cddr (assoc (cadr action) (animation-info world)))
		  (cddr (assoc (caddr action) (animation-info world)))))))



;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
