;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   planning-ex2.cl
;;; Short Desc: first planning demo
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   24.1.92 DTA
;;; Author:     DTA, after TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :planning)

(defun dialog-2 (text-disp table-disp problem-disp)
  (let (node top graph
	answer
	)
    (setf *animate* t)

    
    
    (format-display problem-disp " Initial State:" )
    (loop for assertion in (assertions *a-b-c*)
	 do (format-display problem-disp "   ~a" assertion))
    (format-display problem-disp " Operators:~%~a~%"  (dump-editable *blocks-world-ops*))
    (format-display problem-disp " Final State:~%~a~%" (assertions *final*))

    
    (format-display text-disp " We can use the same operators and state")
    (format-display text-disp "~& descriptions for non-linear planning, only")
    (format-display text-disp "~& the internal representation of the  states")
    (format-display text-disp "~& differ. ")
    (when (wait)
      (use-planner snlp::*tweak-planner*)
      (use-ops *blocks-world-ops*)
      (multiple-value-bind (plan planning-tree) (b-test0)
	(draw-tree planning-tree )
	(setf answer plan)
	 )
      (init-movie-window "blocks"
		       (assertions *a-b-c*))
      (activate-display *movie-window*)

      (format-display text-disp " Use non-linear plans to solve the problem.")
      (format-display text-disp "~& In the Search Tree window is a graph of")
      (format-display text-disp "~& all the intermediate states that the planner")
      (format-display text-disp "~& went through to solve the problem. ")      
      
      (when (wait)
	(format-display text-disp " The solution to the problem is shown")
	(format-display text-disp "~& graphically in the Node Info window.  This")
	(format-display text-disp "~& is a non-linear plan;  ordering between")
	(format-display text-disp "~& operators is specified by the arcs in the")
	(format-display text-disp "~& graph.  See Help for more information.")

	(setf *current-node* node)
	(setf graph (when (planner-graph-fn *current-planner*)
		      (funcall (planner-graph-fn *current-planner*)
			       answer *node-info-window* )))
	(setf top (loop for goal in (assertions *a-b-c*)
		      when (equal (string-upcase (symbol-name (car goal))) "ON") collect goal))
	(setf (start-state *movie-window*) top)
	(setf (init-plan *movie-window*) '((put dump::a dump::support-table)
					   (put dump::b dump::support-table)
					   (put dump::c dump::support-table)))
	(animate-plan *world* top
		      (snlp:plan-steps answer)
		      *movie-window*)
	
	
	(when (wait)
	  
	  (format-display text-disp "~& The non-linear planner determined the")
	  (format-display text-disp "~& appropriate order for the two steps. ")
	  (format-display text-disp "~& End of demo.")
	  ))))) 


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
