;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   planning-ex3.cl
;;; Short Desc: first planning demo
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   24.1.92 DTA
;;; Author:     DTA, after TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :planning)

(defun dialog-3 (text-disp table-disp problem-disp)
  (let (node top graph
	answer
	)
    (setf *animate* t)

    
    (format-display problem-disp " Initial State:" )
    (loop for assertion in (assertions *b/a-on-c*)
	 do (format-display problem-disp "   ~a" assertion))
    (format-display problem-disp " Operators:~%~a~%"  (dump-editable *blocks-world-ops*))
    (format-display problem-disp " Final State:~%~a~%" (assertions *sussf*))

    
    (format-display text-disp " The major shortcoming of linear planning is")
    (format-display text-disp "~& the inability to postpone decisions about")
    (format-display text-disp "~& step ordering.  STRIPS makes a fatal mistake. ")


    (when (wait)
      (use-planner strips::*strips-planner*)
      (use-ops *blocks-world-ops*)
      (multiple-value-bind (plan planning-tree) (b-test1)
	(draw-tree planning-tree )
	(setf answer plan)
	 )
      (init-movie-window "blocks"
		       (assertions *b/a-on-c*))
      (activate-display *movie-window*)

      (format-display text-disp " STRIPS has achieved the two goals in this")
      (format-display text-disp "~& problem, (on b a) and (on c b).")
      (format-display text-disp "~& Unfortunately, when it accomplished the")
      (format-display text-disp "~& second, it invalidated the first")
      
      (when (wait)

	(setf *current-node* node)
	(setf graph (when (planner-graph-fn *current-planner*)
		      (funcall (planner-graph-fn *current-planner*)
			       answer *node-info-window* )))
	(setf top (loop for goal in (assertions *b/a-on-c*)
		      when (equal (string-upcase (symbol-name (car goal))) "ON") collect goal))
	(setf (start-state *movie-window*) top)
	(setf (init-plan *movie-window*) '(
					   (put dump::b dump::support-table)
					   (put dump::c dump::support-table)
					   (put dump::a dump::c)))
	(protect-display *movie-window* t)
	(animate-plan *world* top
		      (reverse (strips::plan-steps-taken-stack answer))
		      *movie-window*)
	(protect-display *movie-window* nil)
	(sleep 1)
	(when (wait)
	  
	  (format-display text-disp " The solution for the problem found by")
	  (format-display text-disp "~& STRIPS is inadequate.  What went wrong? ")
	  (format-display text-disp "~& End of demo.")
	  ))))) 


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
