;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   planning-ex4.cl
;;; Short Desc: first planning demo
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   24.1.92 DTA
;;; Author:     DTA, after TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :planning)


(defun dialog-4 (text-disp table-disp problem-disp)
  (let (node top graph
	answer
	)
    (setf *animate* t)
    
    (format-display problem-disp " Initial State:" )
    (loop for assertion in (assertions *b/a-on-c*)
	 do (format-display problem-disp "   ~a" assertion))
    (format-display problem-disp " Operators:~%~a~%"  (dump-editable *blocks-world-ops*))
    (format-display problem-disp " Final State:~%~a~%" (assertions *sussf*))

    (format-display text-disp " Use a non-linear plan representation for")
    (format-display text-disp "~& the same problem.  The operators, starting")
    (format-display text-disp "~& and intial states are the same.")


    (when (wait)
      (use-planner snlp::*tweak-planner*)
      (use-ops *blocks-world-ops*)
      (use-ranker 'snlp::rank2)
      (multiple-value-bind (plan planning-tree) (b-test1)
	(draw-tree planning-tree )
	(setf answer plan)
	)
      (init-movie-window "blocks"
			 (assertions *b/a-on-c*))
      (activate-display *movie-window*)
      
      (format-display text-disp " A non-linear plan representation does not")
      (format-display text-disp "~& commit to the order of the plan steps,")
      (format-display text-disp "~& until it sees that one endangers the other.")
      
      




      (setf *current-node* node)
      (setf graph (when (planner-graph-fn *current-planner*)
		    (funcall (planner-graph-fn *current-planner*)
			     answer *node-info-window* )))
      (setf top (loop for goal in (assertions *b/a-on-c*)
		    when (equal (string-upcase (symbol-name (car goal))) "ON") collect goal))
      (setf (start-state *movie-window*) top)
      (setf (init-plan *movie-window*) '(
					 (put dump::b dump::support-table)
					 (put dump::c dump::support-table)
					 (put dump::a dump::c)))
      
	
	
      (when (wait)
	
	(format-display text-disp " The non-linear planner resolves the")
	(format-display text-disp "~& conflict, producing a correct plan.")

	(animate-plan *world* top
		      (snlp:plan-steps answer)
		      *movie-window*)

	(format-display text-disp "~& End of demo.")
	))))

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
