;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   planning-make.cl
;;; Short Desc: Compile & load code & documentation
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   31.10.91 - MR
;;; Author(s):     Hank Wan (core algorithms)
;;;                Mike Rosner, Fabio Baj (user interface)
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; Build planning module
;;;

(in-package :planning)


(defparameter *planning-path* (add-subdir *pail-path* "planning"))
(defparameter *libpath* (add-subdir *pail-path* "pail-lib"))


(setf *planner-files*
  '(
    "unify"
    "search"
    "planner"
    "strips"
    "snlp/snlp-pail"
    "snlp/structs"
    "snlp/unif"
    "snlp/snlp"
    "gin-back"
    "graphics"
    "planning-dialog"
    "demo"))

(setf *domain-files*
  '("domains/bworld"
    "domains/blocks"
    "domains/robot"
    "domains/maze"
    "domains/fuel"
    ))

(ensure-loaded (add-path "sftw-push" *libpath*))

(ensure-loaded (add-path "rules" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "operators" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "animate" (add-subdir *pail-path* "pail-lib")))

(dolist (f *planner-files*)
  (ensure-loaded (add-path f *planning-path*)))
(dolist (f *domain-files*)
  (ensure-loaded (add-path f *planning-path*)))
  
(defparameter *number-of-demos*
	  (do* ((i 1 (1+ i))
		(name (make-pathname :name (format nil "planning-ex~a" i)
				     :type *sourcefile-type*)
		      (make-pathname :name (format nil "planning-ex~a" i)
				     :type *sourcefile-type*)))
	      ((not (probe-file (add-path name *planning-path*))) (1- i))
	    (ensure-loaded (add-path name *planning-path*))))

(defun compile-all-files ()
  (dolist (f *planner-files*)
    (compile-file f)
    (load f)))


(format *standard-output* "~%Planner loaded")



