;;; -*- Mode: LISP; Package: GTRE-EXAMPLE; Syntax: Common-lisp; -*-
;;;
;;; *******************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; *******************************************************
;;;
;;; Filename:   raining-ex.cl
;;; Short Desc: Simple example to show non-monotonicity
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   19.12.91 - Fatma FEKIH-AHMED
;;; Author:    Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log: raining-ex.cl,v $
;;; Revision 1.2  1992/02/20  16:35:10  fekih
;;; reamenage le traitement graphique de la contradiction.
;;;
;;; -------------------------------------------------------


;;; =======================================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================================

(in-package common-lisp-user)
(EVAL-WHEN (COMPILE LOAD EVAL)
                       (DATABASE:MAKESYMS '.%%symbol-label%%. 0 4 "common-lisp-user"))

;;; =======================================================================
;;; ASSERTIONS AND RULES
;;; =======================================================================

(setq database:*db-input* 
  (setq .%%symbol-label%%.4 
    (make-instance 'pail-lib::poolfile 
      :real-contents 
      (list (setq .%%symbol-label%%.5 
	      (make-instance 'pail-lib:pool-item 
		:from-button nil 
		:start-object (setq .%%symbol-label%%.6 
				(make-instance 'pail-lib::tre-example 
				  :contradiction nil 
				  :assertions 
				  (list 
				   (list 'gtre::assert! 
					 (list 'quote 
					       (list 'gtre-example::raining)))
				   (list 'gtre::assert! 
					 (list 'quote
					       (list 'gtre-example::week-end)))) 
				  :rule-set 
				  (list
				   (list 'gtre::rule 
					 (list 
					  (list :in 
						(list 'gtre-example::week-end) 
						:var 'gtre-example::?v1) 
					  (list :out 
						(list 'gtre-example::raining) 
						:var 'gtre-example::?v2))
					 (list 'gtre::rassert! 
					       (list 'go 'gtre-example::out-doors) 
					       (list 'gtre-example::justif 
						     (list :in 'gtre-example::?v1) 
						     (list :out 'gtre-example::?v2))))) 
				  :name-part nil)) 
		:name-part "raining?"))) 
      :contents (list (setq .%%symbol-label%%.7 
			(make-instance 'pail-lib::filentry 
			  :classname "tre-example"
			  :poolname "raining?"))) 
      :filename "nmjtms-ex1.cl")))


;;; =======================================================================
;;; END OF FILE
;;; ======================================================================= 
