;;; -*- Mode: LISP; Package: GTRE-EXAMPLE; Syntax: Common-lisp; -*-
;;;
;;; *******************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; *******************************************************
;;;
;;; Filename:   raining-ex.lisp
;;; Short Desc: simple example to show non-monotonicity.
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   19.12.91 - Fatma FEKIH-AHMED
;;; Author:     Fatma FEKIH-AHMED
;;;
;;; -------------------------------------------------------


;;; =======================================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================================

(in-package :gtre-example)

(import '(pail-lib::tre-example
	  gtre::rule
	  gtre::assert!
	  gtre::rassert!))
	
(let ((rain (make-instance 'tre-example
	      :rule-set '((rule ((:in (week-end) :var ?V1)
				 (:out (raining) :var ?V2))
				(rassert! (go out-doors) (justif (:in ?V1) 
								 (:out ?V2)))))
	      :assertions '((assert! '(raining))
			    (assert! '(week-end))))))
  (pail-lib::put-pool pail-lib:*pail-pool* rain :name "raining?"))

;;; =======================================================================
;;; END OF FILE
;;; ======================================================================= 
