;;; -*- Mode: LISP; Package: GTRE-EXAMPLE; Syntax: Common-lisp; -*-
;;;
;;; *******************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; *******************************************************
;;;
;;; Filename:   right-trains-ex.lisp
;;; Short Desc: Simple example to show that temporal features 
;;;             are not straightforward using TMS.
;;;             (Please refer to wrong-trains-ex.lisp)
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   10.02.91 - Fatma FEKIH-AHMED
;;; Author:     Fatma FEKIH-AHMED
;;;
;;; -------------------------------------------------------


;;; =======================================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================================

(in-package common-lisp-user)

(let ((right-trains (make-instance 'pail-lib:tre-example 
		      
		      :contradiction '((gtre::contradiction 'contradiction-found))
		      
		      :assertions '((gtre::assert! '(passage 1 12))
				    (gtre::assert! '(passage 1 14))
				    
				    (gtre::assert! '(passage 2 12))
				    (gtre::assert! '(passage 2 13))
				    
				    (gtre::assert! '(passage 3 12))
				    
				    (gtre::assert! '(voie-libre 1 12))
				    (gtre::assert! '(voie-libre 1 13))
				    (gtre::assert! '(voie-libre 1 14))
				    
				    (gtre::assert! '(voie-libre 2 12))
				    (gtre::assert! '(voie-libre 2 13))
				    (gtre::assert! '(voie-libre 2 14)))

		      :rule-set '((gtre::rule ((:in (passage ?t ?h) :var ?J1)
					       (:in (voie-libre ?v ?h) :var ?J2))
					      (gtre::rassert! (arrivee ?t ?v ?h)
							      (justif (:in ?J1) 
								      (:in ?J2))))
				  
				  (gtre::rule ((:in (arrivee ?t1 ?v ?h) :var ?J1)
					       (:in (arrivee ?t2 ?v ?h) :var ?J2
						:test (neq ?t1 ?t2)))
				   (gtre::rassert! contradiction-found
				    (justif (:in ?J1) (:in ?J2)))) ))))
  (pail-lib::put-pool pail-lib:*pail-pool* right-trains :name "right-trains"))


(defun neq (x1 x2)
  (not (eq x1 x2)))


;;; =======================================================================
;;; END OF FILE
;;; ======================================================================= 
