;;; -*- Mode: LISP; Package: RPG; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rpg-browser
;;; Short Desc: Browsing facilities for Clusters
;;; Version:    1.0b
;;; Status:     Review
;;; Author:     ThE 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; --------------------------------------------------------------------------
;;; Last Modified By: Thomas E. Rothenfluh
;;; Last Modified On: Tue Feb 18 19:01:58 1992
;;; Update Count    : 3
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO
;;; ==========================================================================
;;;
;;; make the browser useful (eg. add functionality to browser menu)
;;; make tree-display height (ie. merge-distance) sensitive


;;; ==========================================================================
;;; PACKAGE and EXPORT DECLARATIONS
;;; ==========================================================================


(in-package :rpg)

(eval-when (load compile)
  (export '(rpg-browser  close-rpg-browse
	    *cluster-browser* *cluster-tree*)))

(defvar *cluster-browser* nil "Global var to hold cluster BROWSER display")
(defvar *cluster-tree*    nil "Global var to hold cluster TREE")



;;; ==========================================================================
;;; Create a cluster tree for later browsing
;;; ==========================================================================


(defun walk-cluster (lookup all)
  "Generate a browsable tree for the cluster"
  (flet ((one-element (l) 
	   (and (listp l)(not (listp (car l)))(null (cdr l)))))
    (let* ((step (find lookup all :test #'(lambda (x y)(equal x (car y)))))
	   ;; (dist (second step))
	   (left (third step))
	   (right (fourth step)))
      (cond ((null step)
	     nil)
	    ((and (one-element left)(one-element right))
	     (list (make-instance 'cluster-tree
		     :content (car (translate-index-to-list left)))
		   (make-instance 'cluster-tree
		     :content (car (translate-index-to-list  right)))))
	    ((one-element left)
	     (list (make-instance 'cluster-tree
		     :content (car (translate-index-to-list left)))
		   (make-instance 'cluster-tree
		     :content (gentemp '*) ; (intern (format nil "~a" right))
		     :descendants (walk-cluster right all))))
	    (t
	     (list (make-instance 'cluster-tree
		     :content (gentemp '*) ; (intern (format nil "~a" left))
		     :descendants (walk-cluster left all))
		   (make-instance 'cluster-tree
		     :content (gentemp '*) ; (intern (format nil "~a" right))
		     :descendants (walk-cluster right all)))
	     )))))


(defun rpg-browse (cluster)
  "Generate a tree and a browser for a cluster"
  (declare (special *cluster-browser*))
  (let* ((*rpg-tree* (make-instance 'cluster-tree 
		       :content 'root 
		       :descendants (walk-cluster 
				     (first (first cluster)) cluster))))
    (setf *cluster-browser*  
      (make-instance 'browser 
	:starting-tree *rpg-tree*
	:title "RPG:Cluster output" :left 200 :bottom 200))))


(defun close-rpg-browser ()
  "Closes Cluster-browser display"	
  (declare (special *cluster-browser*))
  (close-display *cluster-browser*)
  (setq *cluster-browser* nil))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================


