;;; -*- Mode: LISP; Package: RPG; Syntax: Common-lisp;                     -*-
;;;
;;; **************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; **************************************************************************
;;;
;;; Filename:   rpg-da1
;;; Short Desc: Data for RPG
;;; Version:    1.0b
;;; Status:     Beta testing
;;; Author:     ThE 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; --------------------------------------------------------------------------
;;; Last Modified By: Thomas E. Rothenfluh
;;; Last Modified On: Wed Feb 19 23:45:14 1992
;;; Update Count    : 4
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO
;;; ==========================================================================
;;;
;;; Fully define the examples (with constructs)


;;; ==========================================================================
;;; Pre-canned data structures to play with 
;;; ==========================================================================


(in-package :rpg)

(eval-when (load eval compile)
 (export '(make-car-elements
	 make-people-elements
	 make-number-elements)))

(defun make-car-elements ()
 "Set up the car example for repgrid."
 (declare (special table *output-button*))
 (setf table
   (make-instance 'elements
     :attributes 
     '(construct alfa golf manta merz porsche rolls ) 
     :rows 
     '((speed medium slow slow medium fast medium )
       (pricing 3.5 2.2 0.5 5.5 7.0 9.9 )
       (cabrio  yes yes no  yes yes yes )
       (stereo  yes no  yes yes no  yes )
       (automat no  no  no  yes no  yes ))))
 (setf (start-object (button-value *output-button*)) table))


(defun make-people-elements ()
 "Set up the people example for repgrid."
 (declare (special table *output-button*))
 (setf table
   (make-instance 
       'elements
     :attributes '(construct andreas dean laura lucia markus 
		   matthias nick paul stefan tom-r tom-w)
     :rows       '((sex     0 0 1 1 0 0 0 0 0 0 0)
		   (glasses 0 0 0 0 0 1 0 0 0 1 0)
		   (tall    1 0 0 0 1 0 1 1 0 0 0))))
(setf (start-object (button-value *output-button*)) table))


(defun make-number-elements ()
  "Set up the number-word example for repgrid."
  (declare (special table *output-button*))
  (setf table
    (make-instance 'elements
      :attributes '(construct one two three four five six 
		    seven eight nine ten eleven twelve)
      :rows '((prime    1 1 1 0 1 0 1 0 0 0 1 0)
	      (odd-even 0 1 0 1 0 1 0 1 0 1 0 1)
	      (chars 3.0 3.0 5.0 4.0 4.0 3.0 5.0 5.0 4.0 3.0 6.0 6.0))))
  (setf (start-object (button-value *output-button*)) table))


(defun make-mushroom-elements ()
 "Set up the mushroom example for repgrid."
 (declare (special table *output-button*))
 (setf table
   (make-instance 
       'elements
     :attributes '(construct phalloides brunnescens rubescens citrina 
		   bisporigera virosa tenuifolia verna)
     :rows       '((potassium-hydroxide no  no  no  no  yes yes yes no)
		   (bruises-red         yes yes no  yes yes yes yes yes)
		   (color               yes yes yes yes no  no  no  no))))
 (setf (start-object (button-value *output-button*)) table))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
