;;; -*- Mode: LISP; Package: RPG; Syntax: Common-lisp;                     -*-
;;;
;;; **************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; **************************************************************************
;;;
;;; Filename:   rpg-dialog
;;; Short Desc: dialog handling for RPG
;;; Version:    1.0b
;;; Status:     Beta testing
;;; Author:     ThE 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; --------------------------------------------------------------------------
;;; Last Modified By: Thomas E. Rothenfluh
;;; Last Modified On: Thu Feb 20 01:01:12 1992
;;; Update Count    : 9
;;; --------------------------------------------------------------------------
;;; Modification History
;;; 24.07.91 dta - pool buttons
;;; 27.09.91 ThE - major redesign
;;; 20.10.91 ThE - rearrange triad-classification; browser for cluster trees
;;;                more robust behavior (button-sequences, no input to ASKs)
;;; 21.10.91 ThE - new triad functions now in file rpg-triad
;;; 19.11.91 ThE - Elicited constructs get lables, not numbers
;;;                Cluster analysis is smart about those labels
;;;                Unclassified elements get an ID3-asteriks - have fun, Dean
;;;
;;; ==========================================================================
;;; TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO
;;; ==========================================================================
;;;
;;; Include height=distance information in browser-display
;;;
;;; make-xxx-elements could load their data here (avoid preloading)?
;;;


;;; ==========================================================================
;;; PACKAGE and EXPORT DECLARATIONS
;;; ==========================================================================

(in-package :rpg)

(eval-when (load compile)
  (export '(start-rpg-dialog *verbose-disp* *output-button*)))


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


(defvar *text-disp*       nil "Stream to route user interactions.")
(defvar *verbose-disp*    nil "Stream to route verbose messages.")
(defvar *output-button*   nil "Pool button holds current element table.")
;;; Access its value with:
;;; (start-object (button-value *output-button*))

(defvar *current-construct* nil)
(defvar *all-constructs* nil)

(defvar *rpg-left* 
    (+ 10
       (left  pail-lib::*main-window*)
       (width pail-lib::*main-window*))
  "Left position to place RPG main window, depends on pAILab:Main")

(defvar *rpg-bottom-offset* 
    (bottom  pail-lib::*main-window*)
  "Bottom position to place RPG main window, depends on pAILab:Main")

(defvar *triad-displays* nil "A list of all triad windows for clean-up")


;;; ==========================================================================
;;; DEFINE THE FEATURES (WINDOWS, MENUS, ETC.) FOR ALL DIALOGS
;;; ==========================================================================


;;; Define the table editor for RepGrids 
;;; (see pail-lib/ed-table for definition)

;;; KNOWN BUG: This does NOT generate close-rpg-table in all cases!
(make-editor-fcn 
 rpg-table-edit
 :obj-var tab
 :default-menu-entries t
 :menu nil)

(defun oops ()
  "Dummy function to recover from errors")

(defvar *rpg-main* nil)

(defclass rpg-main-dialog (display)
	  ((help-button    :initarg :help-button
			   :accessor help-button
			   :initform nil)
	   (tool-button    :initarg :tool-button
			   :accessor tool-button
			   :initform nil)
	   (exit-button    :initarg :exit-button
			   :accessor exit-button
			   :initform nil)))

(defmethod initialize-instance ((r rpg-main-dialog)
				&key (from-button nil))
  (declare (special *RPGPATH*))
  (call-next-method)
  (setq gin::*default-display-border* 1)
  (setf (help-button r)
    (make-instance 'help-button 
      :technical (add-path "rpg-desc.tec" *rpgpath*)
      :general   (add-path "rpg-desc.gen" *rpgpath*)
      :subject "RPG:Main Menu Help"))
  (setf (tool-button r)	
    (make-instance 'push-button 
      :label "Tool"
      :width 70))
  (setf (exit-button r)
    (make-instance 'push-button 
      :label "Exit"
      :width 70)))

(defmethod initialize-instance :after ((r rpg-main-dialog)
				       &key (from-button nil))
  (protect-display r t)
  (setf (title r) "RPG:Main Window")
;;  (setf (height r) 150)
;;  (setf (width r) 300)
  (copy-mask *pail-logo* 0 0 r
	     (- (width r) (cw:bitmap-width *pail-logo*) 15)
	     (- (height r) (cw:bitmap-height *pail-logo*) 15))
  (write-display r "Welcome to ThE" 
		 15 (- (height r) 
		       (* 3 (font-ascent (font r)))))
  (write-display r "Repertory Grid Module" 
		 15 (- (height r) 
		       (* 5 (font-ascent (font r)))))
  (setf (font r) *default-font*)
  (position-buttons r from-button)
  (protect-display r nil))

(defmethod position-buttons ((r rpg-main-dialog) from-button)
  (set-button (help-button r)
	      r 
	      :left 15 
	      :bottom 15)
  (set-button (tool-button r)
	      r
	      :left   100;; (/ (- (width r) (width (tool-button r)) 2))
	      :bottom 15)
    (set-button (exit-button r)
		r
		:left 185 ;;(- (width r) (width (exit-button r)) 15)
		:bottom 15)
  (setf (action (tool-button r))
    (function 
     (lambda nil
       (disable-button (exit-button r))
       (deactivate-display r)
       (rpg-tool)
       (enable-button (exit-button r)))))
    (setf (action (exit-button r))
      (function
       (lambda nil
	 (when *triad-displays*
	   (dolist (x *triad-displays*)
	     (close-display x)))
	 (close-display *verbose-disp*)
	 (close-display r)
	 (if from-button 
	     (reset-button from-button))))))


(defun start-rpg-dialog (&optional (from-button nil))
  (declare (special *RPGPATH*))
  (setq *rpg-main* (make-instance 'rpg-main-dialog
		     :from-button from-button
		     :left *rpg-left*
		     :bottom *rpg-bottom-offset*
		     :height 150
		     :width 300))
  (setf *verbose-disp*
    (make-instance 'scroll-display
      :title "RPG:Verbose Comments"
      :width (round (width *root-window*) 3)
      :height (round (height *root-window*) 3)
      :borders 1
      :active nil
      :left (round (width *root-window*) 2)
      :bottom (round (height *root-window*) 3)))
  (if *verbose*
      (progn (activate-display *verbose-disp*)
             (setf *verbose* *verbose-disp*))
    (deactivate-display *verbose-disp*)))

(defun comment (disp string &rest args)
  "COMMENT outputs a string to a DISPLAY."
  (when (displayp disp)
    (activate-display disp)
    (clear-display disp)
    (format-display disp string args)))


(defun typein ()
  "Pop up a typein window and return a list."
  (let* ((typein-window 
	  (make-instance 'display :title "RPG:Typein Window"
			:active t
			:width 700
			:height 100
			:borders 1
			:left 10
			:bottom 575))
	 (return nil))
    (setf return 
      (with-input-from-string (in (read-display typein-window 80 10))
	(do ((x (read in nil nil)(read in nil nil)) result)
	    ((null x) result)
	  (setf result (cons x result)))))
    (close-display typein-window)
    (reverse return)))


;;; ==========================================================================
;;; TOOLBOX
;;; ==========================================================================


;;; RPG TOOL is the main interaction facility to use RepGrid.
;;; It is a display which provides several options 
;;; (through buttons, displays and menus)
;;;
;;; (0) RPG:Tool:Main		Main window
;;; (1) RPG:Tool:Comments	Displays comments on how to use the Tool
;;; (2) RPG:Tool:Help		Get access to general RepGrid-Tool help
;;; (3) RPG:Tool:Elements	Define the elements to be used
;;; (4) RPG:Tool:Triads		Apply the triads method to the elements
;;; (5) RPG:Tool:Cluster	Make statistical analysis of the grid
;;; (6) RPG:Tool:Exit		Quit the RepGrid tool 
;;;

(defun rpg-tool (&optional (menu-button nil) (exit-button nil))
  "Main user interaction function is provided by calling RPG-TOOL"
  (declare (special *text-disp* pail-lib::*main-window* *rpg-browser*)
	   (ignore exit-button))
  (when (displayp menu-button) (disable-button menu-button))
  ;; (when (displayp exit-button) (disable-button exit-button))
  (documentation-print 
   "Welcome to the Repertory Grid Toolbox, Version 1.0b
                                                 ")
  (clear-scroll *verbose-disp*)
  ;; (setf *elements* nil)
  (let* ((*value-button-border-p* t)
	 ;; ========== DISPLAYS 
	 (dispwidth 800)
	 (dispheight 260)
	 (tool-disp (make-instance 'display 
		      :title "RPG:Tool:Main - A RepGrid tool"
		      :width (min (width *root-window*) dispwidth)
		      :height (min (height *root-window*) dispheight)
		      :borders 1
		      :left (round (- (width *root-window*)
				      (min (width *root-window*)
					   dispwidth)) 2)
		      :bottom (- (height *root-window*)
				 (min (height *root-window*)
				      (+ dispheight 30)))))
	 (tool-comment-disp (make-instance 'scroll-display
			      :title "RPG:Tool:Comments"
			      :font (findfont (width tool-disp) 800 10)
			      :parent tool-disp
			      :width (round (* 3 (width tool-disp)) 8)
			      :height (round (*  2 (height tool-disp)) 3)
			      :borders 1
			      :left (+ 10 (round (width tool-disp) 5) (round (width tool-disp) 4))
			      :bottom (round (height tool-disp) 5)))
	 ;; Prepare the dendrogram display
	 (dendro-disp
	  (make-instance 'scroll-display
	    :width  (- (min (width *root-window*) 1000) 20) 
	    :height (- (min (height *root-window*) 500) 20)  
	    :left 10 :bottom 10
	    :inner-width (+ (min (width *root-window*) 1000) 200)
	    :x-scrollbar t
	    :button-region t
	    :active nil			; close later
	    :title "RPG:Cluster Dendrogram"))
	 ;; And how about an interpretation help?
	 (dendro-help-button     
	  (make-instance 'help-button 
	    :technical (add-path "rpg-dend.tec" *rpgpath*)
	    :general   (add-path "rpg-dend.gen" *rpgpath*)
	    :subject "RPG:Cluster Dendrogram Help"
	    :width (round (width tool-disp) 8)))
	 ;; More tool buttons
	 (tool-help-button     
	  (make-instance 'help-button 
	    :technical (add-path "rpg-tool.tec" *rpgpath*)
	    :general   (add-path "rpg-tool.gen" *rpgpath*)
	    :subject "RPG:Tool Display Help"
	    :width (round (width tool-disp) 8)))
	 (tool-elements-button 
	  (make-instance 'value-button
	    :value "Elements"
	    :width (round (width tool-disp) 8)))
	 (tool-triad-button    
	  (make-instance 'push-button
	    :label "Triads"
	    :width (round (width tool-disp) 8)))
	 (tool-cluster-button  
	  (make-instance 'value-button
	    :value "Cluster"
	    :width (round (width tool-disp) 8)))
	 (tool-exit-button     
	  (make-instance 'push-button
	    :label "Exit"
	    :width (round (width tool-disp) 8)))
	 ;; ========== MENUS
	 ;; ---------- table-menu options to define elements
	 (table-menu        
	  (make-instance 'menu
	    :items 
	    `(("Define new elements" 
	       (progn 
		 ()
		 (define-new-elements)	
		 (format-display 
		  *text-disp* 
		  "~%Your elements are now available.~
                   ~&Proceed with classifying them~
                   ~&by clicking the < Triads > Button.")
		 (reset-button  ,tool-elements-button)
		 (reset-button  ,tool-exit-button))
	       "Define the elements yourself.")
	      ("Edit elements and ratings" 
	       (progn 
		 ()
		 (setf (start-object (button-value *output-button*))
		   (rpg-table-edit 
		    (start-object (button-value *output-button*))
		    :title "RPG:Rep Grid Table" :left 10
		    :offset-x 0 :cell-font *small-font*))
		 (reset-button ,tool-elements-button))
	       "Use the table editor to inspect and modify the data.")
	      
	      
	      
	      )))
	 ;; ---------- Cluster menu
	 (cluster-menu        
	  (make-instance 'menu
	    :items 
	    `(("Analyze current grid" 
	       (progn
		 ()
		 (format-display 
		  *text-disp* 
		  "~%Analyzing your elements with ~
                   ~&single-linkage Cluster Analysis.~
                   ~&Please be patient ...~
                   ~&(until the cluster button is active again)")
		 (cond 
		  ((start-object (button-value *output-button*))
		   (cluster-it  
		    (fulltable-to-cleanarray
		     (start-object (button-value *output-button*)))))
		  ((display-error 
		    "No elements and constructs defined yet"
		    :from-button ,tool-cluster-button)))
		 (format-display *text-disp* "Cluster output now available.")
		 (reset-button  ,tool-cluster-button)) ;here
	       "Run a single-linkage cluster analysis over the grid's data")
	      ("Show the cluster dendrogram" 
	       (progn 
		 ()
		 (if *cluster-tree* 
		     (cluster-print *cluster-display* ,dendro-disp)
		   (display-error "No cluster analysis output available."
				  :button-label "Click here to continue"))
		 (reset-button ,tool-cluster-button))
	       "Display the cluster analysis results as a dendrogram")
	      ("Browse the cluster tree" 
	       (progn 
		 ()
		 (if *cluster-tree* 
		     (setf *rpg-browser* (rpg-browse *cluster-tree*))
		   (display-error "No cluster analysis output available."
				  :button-label "Click here to continue"))
		 (reset-button ,tool-cluster-button))
	       "Display the cluster analysis results as a browsable tree")
	      )))
	 ;; ---------- Verbose option toggle
	 (verb (make-instance 'radio-button 
		 :label "Verbose Mode"
		 :status *verbose*
		 :action 
		 #'(lambda ()
		     (if *verbose*
			 (progn
			   (setf *verbose* nil)
			   (deactivate-display *verbose-disp*))
		       (progn
			 (setf *verbose* *verbose-disp*)
			 (activate-display *verbose-disp*))))))
	 (file-button (make-instance 'file-button
			:w-directory *rpgpath*)))
    ;; ---------- the table-editor really is a large button 
    (setf *output-button* 
      (make-instance 'pool-button
	:name "Repertory Grid "
	:value ""
	:width (round (width tool-disp) 5)
	:target-class 'rpg::elements
	:pool *pail-pool*
	:border  t))
    
    ;; ---------- Global accessible variables
    (setf *cluster-tree* nil)
    (setf *cluster-display* nil)
    (setf *cluster-history* nil)
    (setf *cluster-to-element* nil)
    ;; ---------- Global accessible displays
    (setf *text-disp* tool-comment-disp) ; For other functions
    ;; ---------- The fancy pAIL-logo is a must!
    (copy-mask *pail-logo* 0 0 tool-disp 
	       (- (width tool-disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height tool-disp) (cw:bitmap-height *pail-logo*) 15))
    (set-button file-button tool-disp
		:left (- (width tool-disp) (width file-button) 7)
		:bottom (- (height tool-disp) (height file-button)
			   (cw:bitmap-height *pail-logo*) 20))
    ;; ---------- EXIT gracefully
    (set-button tool-exit-button tool-disp 
		:left (- (width tool-disp) (width tool-exit-button) 15) 
		:bottom 15
		:action 
		#'(lambda ()
		    (declare (special browse))
		    (close-display *text-disp*)
		    ;;; THOMAS WEHRLE: DAS FUNKTIONIERT JETZT! (manchmal)
		    (when (fboundp 'rpg::close-rpg-table-edit)
		      (close-rpg-table-edit 'bla :close-all t))
		    (when (and (boundp '*rpg-browser*) *rpg-browser*)
		      (close-rpg-browser))
		    (when *triad-displays*
		      (dolist (x *triad-displays*)
			(close-display x)))
		    (close-display dendro-disp)
		    (close-display tool-disp)
		    (activate-display *rpg-main*)
		    (sleep 1)
		    (reset-button (tool-button *rpg-main*))
		    (enable-button (exit-button *rpg-main*))
		    ))
    ;; ---------- RPG:TOOL:Help
    (set-button tool-help-button tool-disp :left 15 :bottom 15)
    ;; ---------- RPG:TOOL:Elements
    (set-button tool-elements-button tool-disp 
		:left 
		(round (+ 15
			  (* 1 (width tool-elements-button))
			  (* 1 (round (- (width tool-disp)
					 30
					 (* 6 (width tool-elements-button)))
				      5))))
		:bottom 15)
    ;; ---------- RPG:TOOL:Triad
    (set-button tool-triad-button tool-disp 
		:left (round 
		       (+ 15
			  (* 2 (width tool-triad-button))
			  (* 2 (round (- (width tool-disp)
					 30
					 (* 6 (width tool-triad-button)))
				      5))))
		:bottom 15
		:action
		#'(lambda ()
		    (if (start-object (button-value *output-button*))
			(progn 
			  (let* 
			      ((table 
				(start-object (button-value *output-button*)))
			       (elements (cdr (attributes table))))
			    (cond 
			     (table
			      (format-display 
			       *text-disp* 
			       "~%Using TRIAD method to elicit new constructs.")
			      ;; ---------- Initialize triads
			      (triples :init elements) 
			      (triad-select elements 
					    :from-button tool-triad-button
					    :from-window tool-disp))
			     (t
			      (display-error "No elements specified."
					     :button-label "Click here to continue"
					     :from-button tool-triad-button)
			      (enable-button tool-triad-button)))))
		      (reset-button tool-triad-button))))
    ;; ---------- RPG:TOOL:Cluster
    (set-button tool-cluster-button tool-disp 
		:left (round (+ 15
				(* 3 (width tool-triad-button))
				(* 3 (round (- (width tool-disp)
					       30
					       (* 6 (width tool-triad-button)))
					    5))))
		:bottom 15)
    (set-button *output-button* tool-disp 
		:left (round (width tool-disp) 4) :bottom 90)
    (set-button verb tool-disp 
		:left (round (width tool-disp) 4) :bottom 180)
    (setf (menu tool-elements-button) table-menu)
    (setf (menu tool-cluster-button)  cluster-menu)
    ;; ---------- RPG:Dendrogram:Help
    (set-button dendro-help-button dendro-disp :left 10 :bottom 5)
    (deactivate-display dendro-disp)
    ;; We are through...
    (format-display *text-disp* 
		    "~&Welcome to the RepGrid tool. ~
                     ~&First you should define elements. ~
                     ~&~%Click on the < Elements > Button, or ~
                     ~&the Repertory Grid button to do so.")))


(defun define-new-elements ()
  "Define new elements."
  (setf (button-value *output-button*) 
    (make-instance 'pool-item
      :start-object nil
      :name-part "no name"
      :from-button *output-button*))
  (setf (start-object (button-value *output-button*))
    (input-elements (start-object (button-value *output-button*)) 
		    *text-disp* *verbose-disp*))
  ;; --- dump:: is new
  (push 'dump::construct (attributes (start-object (button-value *output-button*))))
  (setf (start-object (button-value *output-button*)) 
    (start-object (button-value *output-button*))))


;;; ==========================================================================
;;; GIN-compatible I/O functions
;;; ==========================================================================


(defun y-or-n-query (query &key (title nil))
  "Prompts for a y/n answer (uses GIN when possible)."
  (cond ((and (boundp *gin-p*) *gin-p*)
	 (eq :yes (y-or-n-dialog query 
				 :title title
				 :left 50 :bottom 150 )))
	(t
	 (when title 
	   (format t "~&~a~%" title))
	 (y-or-n-p (format t "~a ~%>>>> (Type y or n) " query)))))


(defun input-list (query &key (title nil))
  "Allows the entering of a list of items (uses GIN when possible)."
  (cond ((and (boundp *gin-p*) *gin-p*)
	 (string-to-list
	  (ask query
	       :title title
	       :error-message "Enter a list of items"
	       :left 50   :bottom 150
	       :width 600 :height 150)))
	(t
	 (when title 
	   (format t title))
	 (format 
	  t 
	  "~&>>>> Enter an asteriks * as last item to end your input: ")
	 (read-delimited-list #\*))))


(defun renew-scroll (disp)
  "Activate and clear a scroll window."
  (when (displayp disp)
    (activate-display disp)
    (clear-scroll disp)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
