;;; -*- Mode: LISP; Package: RULES; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rules-dialog.cl
;;; Short Desc: dialog handling for both rule engines
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   22.8.91 - FFA
;;; Author:     DTA FFA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; Taken from the tms-dialog.cl
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rules)
#| (import '(pail-lib::pool-button
	  pail-lib::pool-item
	  pail-lib::tms-tree
	  pail-lib::name-part
	  pail-lib::get-from-pool
	  pail-lib::ruledefs
	  pail-lib::asserts
	  pail-lib::construct-tms-tree
	  pail-lib::tms-browser
	  pail-lib::help-button
	  pail-lib::*pail-path*
	  pail-lib::add-subdir
	  pail-lib::add-path
	  pail-lib::ensure-loaded
	  )) |#


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defvar *display-list* nil)

(defun start-rules-dialog (&optional (from-button nil))
  (let* ((disp (make-instance 'rule-display :title "RULES: Main Window"
			      :width 450
			      :height 200
			      :borders 1
			      :bottom (bottom pail-lib::*main-window*)
			      :left (+ (width pail-lib::*main-window*) 
			               (left pail-lib::*main-window*))))
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (setf  (help-button disp)
			(make-instance 'help-button
			  :technical (add-path "rules-doc.tec"
					       (add-subdir *pail-path* "rules"))
			  :general (add-path "rules-doc.gen"
					     (add-subdir *pail-path* "rules"))
			  :subject "RULES")))
	 (forward-rules-button   (make-instance 'push-button :label "Forward Chaining" :width 200))
	 (backward-rules-button   (make-instance 'push-button :label "Backward Chaining" :width 200))
	 (*default-push-button-size-p* nil)
	 left-side)

    (push disp *display-list*)
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))
  
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (cw:open-font :courier :italic 18 :weight :bold))
    (write-display disp
		   "Rule Chaining Engines"
		   (/ (- (width disp) (font-string-width (font disp) "Truth Maintenance Systems")) 2)
		   (- (height disp) 40 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)

    (set-button help-button disp :left 15 :bottom 15)
    
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda () (exit-function ,exit-button ,from-button)))
    (setf left-side (floor (- (width disp) (width forward-rules-button)) 2))
    (set-button forward-rules-button disp
		:left left-side
		:bottom (* 2 (height exit-button))
		:action `(lambda nil (start-forward-rules :from-button ,forward-rules-button)))
    (set-button backward-rules-button disp
		:left left-side
		:bottom (* 3 (height exit-button))
		:action `(lambda () (start-backward-rules :from-button ,backward-rules-button)))
    disp))


(defun start-forward-rules (&key (from-button nil))
  (when (not pail-lib::*runtime*)
    (ensure-loaded (add-path "forward-rules-make" (add-subdir *pail-path* "forward-rules")) 
		 :source t :force t))
  (start-forward-rules-dialog from-button))


(defun start-backward-rules (&key (from-button nil))
  (when (not pail-lib::*runtime*)
    (ensure-loaded (add-path "backward-rules-make" (add-subdir *pail-path* "backward-rules")) 
		 :source t :force t))
  (start-backward-rules-dialog from-button))


(defun exit-function (exit-button from-button)
  #| (if (yes-or-no-dialog "Really Exit? ")
      (progn (dolist (d *display-list*)
	       (close-display (eval d)))
	     (reset-button from-button))
    (reset-button exit-button)) |#
  (progn (dolist (d *display-list*)
	   (close-display (eval d)))
	 (reset-button from-button)))

(defun yes-or-no-dialog (q &key (title "Please Click"))
  (let ((dw (make-instance 'menu
	     :left 500
	     :bottom 500
	     :query q
	     :items '(("Yes" t) ("No" nil)))))
    (accept-items dw)))



;;; ========================================================================
;;; END OF FILE
;;; ========================================================================

