/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#define	NAME_SIZE	32
#define	BP_SYM		100			/* For nametable entry */
#define	BP_NO_FIRE	-1			/* is there a fire unit? */
#define	ICMP		-1			/* module not finished */
#define	CMP		1			/* module finished */

#define	QUIET		1			/* control u quiet state */
#define	FWD		2			/* control u forward state */
#define	REV		3			/* control u reverse state */

#define NINPUT		(bp_flag & 01)		/* can't call bpinput? */
#define	NHIDDEN		(bp_flag & 02)		/* can't call bphidden? */
#define FIRE		(bp_flag & 04)		/* bpfire called? */
#define	MODULE		(bp_flag & 010)		/* okay to issue bp commands?*/
#define SNINPUT		bp_flag |= 01		/* can't call bpinput */
#define	SNHIDDEN	bp_flag |= 02		/* can't call bphidden */
#define SFIRE		bp_flag |= 04		/* bpfire called */
#define	SMODULE		bp_flag = 010		/* okay to issue bp commands */

#define	BP_FORWARD_FLAG	12			/* bit number in flag, watch
						   out for conflicts !!!! */

char	*name_mem,			/* contains |prefix-name-suffix| */
	*mod_num,			/* e.g. "(42)" */
	*mod_name;			/* points after prefixes */

int	layer_t,			/* total number of layers */
	layer_c;			/* current layer */
int	cu_index,			/* global index of control unit */
	bu_index,			/* global index of bias unit */
	fu_index;			/* global index of fire unit */
int	lastu;				/* index of last unit made */

extern char	*BPname();
extern Site	*BPGetSite();
extern FLINT	UFone(), UFfire(), UFcontrol(), UFh_o(),
		SFerror(), SFbpsigmoid();
/*** FLINT is defined in either sim.h or fsim.h, depending...***/

extern float	BPmomentum;
extern float    BPlearn;
extern float    BPtemperature;

