%%%%%%%%%%%%%%%%%%%%%%%%% io etc. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- use_module(library(lists), [ nth/3 ]).

%%%% check_and_display_result/1 is called by the parser	  

%check_and_display_result(t(Sign,Ds)) :-
%	startsymbol(Sign),
%	display_tree(t(Sign,Ds),0),
%	display_semantics(Sign),
%	ttyflush.

:- del_graphic(gp,gl,gd).

gp(syn,Obj,Obj).

gl(syn,t(Sign,_),Label) :-
	cat_symbol(Sign,Label).
gl(syn,w(Word),Word).

gd(syn,No,t(_,[H|T]),D) :-
	nth(No,[H|T],D).
gd(syn,1,t(_,w(Word)),w(Word)).

%

gp(sem,Obj,Obj).
gl(sem,t(Sign,_),Label) :-
	semantics(t(Sign,_),Label).
gl(sem,w(Word),Word).

gd(sem,No,t(_,[H|T]),D) :-
	nth(No,[H|T],D).
gd(sem,1,t(_,w(Word)),w(Word)).

:- add_graphic(gp,gl,gd).

/*
display_tree(t(Sign,w(Word)),Indent) :-
	cat_symbol(Sign,Sym),
	nl, tab(Indent), write(Sym), write(' -- '), write(Word).
display_tree(t(Sign,[D|Ds]),Indent) :-
	cat_symbol(Sign,Sym),
	nl, tab(Indent), write(Sym), 
	NewIndent is Indent + 3,
	display_ds([D|Ds],NewIndent).

display_ds([],_).
display_ds([D|Ds],Indent) :-
	display_tree(D,Indent),
	display_ds(Ds,Indent).
	
*/

cat_symbol(Sign,Sym) :-
	( Sign:gap <=> empty -> cat_symbol0(Sign,Sym)
	; cat_symbol0(Sign,Sym0),
	  Sign:gap <=> Gap,
	  cat_symbol0(Gap,GapSym),
	  Sym = Sym0-GapSym
	).
	
cat_symbol0(Sign,Cat) :-
	Sign:cat <=> Var,
	var(Var),!,
	Var = Cat.
cat_symbol0(Sign,Cat) :-
	( Sign:cat <=> n
        ; Sign:cat <=> np
	; Sign:cat <=> pref
	; Sign:cat <=> pp
	; Sign:cat <=> adj
	),
	Sign:cat <=> Cat.
cat_symbol0(Sign,s) :-
	Sign:cat <=> sent.
cat_symbol0(Sign,Symbol) :-
	( Sign <=> Val/Arg -> Symbol = ValSym/ArgSym
	; Sign <=> Arg\Val,
	  Symbol = ArgSym\ValSym
	),
	cat_symbol0(Val,ValSym),
	cat_symbol0(Arg,ArgSym).


%display_semantics(Sign) :-
%	Sign:sem <=> Sem,
%	\+ \+ ( prolog:prettyvars(Sem),
%		nl, write(Sem)
%	      ).
	      
	 
/*portray(fvt(F,V,T)) :-
	cat_symbol(fvt(F,V,T),Cat),
	write(Cat).	      
portray(t(Sign,_Ds)) :-
	portray(Sign).
*/	

%%%%%%%%%%%%%%%% grammar compilation (for efficiency only) %%%%%%%%%%%%%%%%
:- dynamic lex/2, rule0/4.

compile_lexicon :-
	retractall(lex(_,_)),
	( lexic(Word,Sign), assert(lex(Word,Sign)), 
	  write(Word), write(', '), ttyflush, fail
	; true
	).

compile_rules :-
	retractall(rule0(_,_,_,_)),
	( rule(Name,Lhs,Rhs,Head), assert(rule0(Name,Lhs,Rhs,Head)), fail
	; true
	).

