:- module(lc,[]).


:- use_module([library(flags)]).

:- add_flag(parser_mode,lc).

clean.
count.
count(0).

parse(o(Obj,Str,_)):-
	length(Str,P),
	goal(Obj,0,P).

goals([],P,P).
goals([First|Rest],P0,P):-
	goal(First,P0,P1),
	goals(Rest,P1,P).

goal(Node,P0,P):- 
	user:lex(P0,P1,SmallNode,_Name),
	check_p_link(SmallNode,Node),
	lc(SmallNode,Node,P1,P).

goal(Node,P,P):- 
	user:gap(Node,_Name).

lc(X,X,P,P).
lc(SmallNode,Node,P0,P):-
  	user:l_rule(SmallNode,MidNode,OtherNodes,_Rule),
	check_p_link(MidNode,Node),
	goals(OtherNodes,P0,P1),
	lc(MidNode,Node,P1,P).


check_p_link(A,B):-
	\+ \+ user:l_link(A,B).






