%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (c) 1992, 1993 Gertjan van Noord RUG %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- use_module([	library(feature),
	        library(show),
	        library(latex),
	        library(p_tree),
		library(tk_tree),
		library(partial)
	      ]).

:- compile(ops).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% declarations needed by Env: %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

extern_sem([S],S).

semantics(tree(S,_,_),Sem):-
	user_sem(S,Sem).

phonology(_,_).

top(Name,tree(Cat,_,_)):-
	user_top_category(Name,Cat).

:- ensure_loaded([ pretty,
	           compile,
		   parse
	         ]).

compile_parsers :-
	compile([ 
		  'PG/mm',
		  'PG/mm_d',
		  'PG/mm_tree',
		  'PG/pack',
		  'PG/pack_d',
		  'PG/pack_tree',
		  'PG/bt',
	          'PG/bt_d',
		  'PG/bt_tree'
	        ] ).


:- compile(gram).
% grammar first, because that allows partial evaluation for
% some of the predicates in the parser..

:- compile_parsers.

:- prolog_flag(redefine_warnings,Old,off),
   compile(overwrite),
   prolog_flag(redefine_warnings,_,Old).


:- version('Tree Adjoining Grammar v1').

gram_dir(Path) :-
	source_file(gram_dir(_),File),
	concat(Path,'start.pl',File).

gram_startup_hook_end :-
	gram_dir(Path),
	concat(Path,'tag.tcl',File),
	concat('source ',File,Cmd),
	tcl_eval(Cmd).

:- ensure_loaded(suite).
