# all optional, so I don't set any default-defaults:
loadAppDefaults {Hdrug} 100

wm title . "Hdrug"
wm iconname . "Hdrug"

# initialize variables

set parser_exists 0
set generator_exists 0
set type_exists 0
set types {}
set preds {}
set sents {}
set objs 0
set lfs {}

# get info from Prolog (possibly re-initializing previous variables)
prolog hdrug_startup_hook_begin

label .t.topt -text Top
entry .t.top -relief sunken -width 10 -textvariable flag(top_features)
pack .t.topt .t.top -side left
bind .t.top <Return> \
       {prolog "receive_flag top_features $flag(top_features)" }

if $parser_exists then {
    label .t.parsert -text Parser
    entry .t.parser -relief sunken -width 10 -textvariable flag(parser)
    pack .t.parsert .t.parser -side left
    bind .t.parser <Return> \
           {prolog "receive_flag parser $flag(parser)"}}

if $generator_exists then {
    label .t.generatort -text Generator
    entry .t.generator -relief sunken -width 10 \
       -textvariable flag(generator)
    pack .t.generatort .t.generator -side left
    bind .t.generator <Return> \
           {prolog "receive_flag generator $flag(generator)"}
}

menubutton .menu.options -text "Options" -underline 0 -menu .menu.options.m
menu .menu.options.m
.menu.options.m add cascade -label "Top Category" \
    -menu .menu.options.top
if $parser_exists then {
    .menu.options.m add cascade -label "Parser" \
        -menu .menu.options.parser 
}
if $generator_exists then {
    .menu.options.m add cascade -label "Generator" \
    -menu .menu.options.generator 
}

menu .menu.options.top -postcommand TopMenu
menu .menu.options.parser -postcommand ParserMenu
menu .menu.options.generator -postcommand GeneratorMenu

pack .menu.options -side left

menubutton .menu.run -text "Run" -underline 0 -menu .menu.run.m
menu .menu.run.m

if $parser_exists then {
    .menu.run.m add command -label "Parse sentence" -command {
         if [SP_send_sent] {prolog parse_sent}
      }  -underline 0
    .menu.run.m add command -label "Compare Parsers" -command {
        if [SP_send_sent] {prolog parse_sent_comp}
      }  -underline 8
}

if $generator_exists then {
    .menu.run.m add command -label "Generate lf" -command {
      #  global lfs
      #  global lfs
        set lf [SP_qbox .l lfs "Select" "     Select a logical form:     "]
        update
        if {$lf == 0} {return 0}
        prolog "generate_atom $lf"
  } -underline 0
    .menu.run.m add command -label "Generate object" -command {
        set m [SP_select_obj]
        if {$m == 0} {return 0}
        prolog "generate_object $m"
      } -underline 9
    .menu.run.m add command -label "Compare Generators on lf" \
        -command {
        set lf [SP_qbox .l lfs \
                 "Select" "          Select a logical form:          "]
        update
        if {$lf == 0} {return 0}
        prolog "generate_atom_comp $lf"
    } -underline 8

    .menu.run.m add command -label "Compare Generators on object" \
        -command {
	    set m [SP_select_obj]
            if {$m == 0} {return 0}
            prolog "generate_object_comp $m"
                 } -underline 17
}

pack .menu.run -side left

menubutton .menu.test -text "Test-Suite" -underline 0 -menu .menu.test.m
menu .menu.test.m -postcommand fillTestSuiteMenu

proc fillTestSuiteMenu {} {
    global test_suite_exists
    global test_result_exists
    global parser_exists
    global generator_exists
    catch {.menu.test.m delete 0 last}
    prolog test_suite_exists
    if $test_suite_exists then {
        .menu.test.m add command -label "Run test suite" \
                -command {prolog go} -underline 0
        .menu.test.m add command -label "Reload test suite" -underline 2\
           -command {
            prolog {compile suite} 
            prolog update_sents
        } 
    }
    if !$test_suite_exists then {
            .menu.test.m add command -label "Load test suite" -underline 0\
           -command {
            prolog {compile suite} 
            prolog update_sents
            }
    }
    prolog test_result_exists
    if $test_result_exists then {

	 .menu.test.m add cascade -label "View test results"\
                -menu .menu.test.view
        .menu.test.m add command -label "Destroy test results"\
            -command {prolog rt} -underline 0
    }
    if $parser_exists then {
        .menu.test.m add cascade -label "Parser Selection" \
             -menu .menu.test.m.parsers 
    }
    if $generator_exists then {
        .menu.test.m add cascade -label "Generator Selection" \
             -menu .menu.test.m.generators 
    }
}

menu .menu.test.view
.menu.test.view add command -label "Individual (Tk)"\
    -command {prolog sts}
.menu.test.view add command -label "Totals per #words (Tk)"\
    -command {prolog sts_add}
.menu.test.view add command -label "Totals per #words (LaTeX)"\
    -command {prolog p_tt}
.menu.test.view add command -label "Totals per #readings (LaTeX)"\
    -command {prolog p_tt_amb}
.menu.test.view add command -label "Individual (Prolog)"\
    -command {prolog print_table}
.menu.test.view add command -label "Totals per #words (Prolog)"\
    -command {prolog print_table_add}

menu .menu.test.m.parsers -postcommand fillParserMenu
menu .menu.test.m.generators -postcommand fillGeneratorMenu

pack .menu.test -side left

menubutton .menu.grammar -text "Grammar" -underline 0 -menu .menu.grammar.m
menu .menu.grammar.m
.menu.grammar.m add command -label "Compile grammar" \
  -command {
     prolog compile_grammar
     prolog update_types
     prolog update_preds
           } -underline 0
.menu.grammar.m add command -label "Reconsult grammar" \
  -command {
     prolog reconsult_grammar
     prolog update_types
     prolog update_preds
	} -underline 0
.menu.grammar.m add command -label "Compile grammar file"\
  -command {
       global fsBox
       FSBox {} {} {
           prolog "compile_grammar_file $fsBox(path)/$fsBox(name)" 
	   prolog update_types
           prolog update_preds
                   }
       }
.menu.grammar.m add command -label "Reconsult grammar file" \
  -command {
       global fsBox
       FSBox {} {} {
           prolog "reconsult_grammar_file $fsBox(path)/$fsBox(name)" 
           prolog update_types
           prolog update_preds
                   }
       }

pack .menu.grammar -side left

# Viewing Objects, Predicates and Type definitions
menubutton .menu.show -text "View" -menu .menu.show.m -underline 0
menu .menu.show.m -postcommand View

proc View {} {
    global object_exists
    global predicate_exists
    global type_exists
    catch {.menu.show.m delete 0 last}
    prolog object_exists
    prolog predicate_exists
    prolog type_exists
    if $object_exists then {
        .menu.show.m add cascade -label Object -menu .menu.show.m.object
    }
    if $predicate_exists then {
        .menu.show.m add cascade -label Predicate \
           -menu .menu.show.m.predicate
    }
    if $type_exists then {
        .menu.show.m add cascade -label Type -menu .menu.show.m.type
    }
}


# Viewing objects
menu .menu.show.m.object
.menu.show.m.object add cascade -label "Tk" \
      -menu .menu.show.m.object.canvas
.menu.show.m.object add cascade -label "Prolog" \
      -menu .menu.show.m.object.prolog
.menu.show.m.object add cascade -label "LaTeX" \
      -menu .menu.show.m.object.latex

menu .menu.show.m.object.canvas -postcommand fillShowObjectCanvas
menu .menu.show.m.object.prolog -postcommand fillShowObjectProlog
menu .menu.show.m.object.latex -postcommand fillShowObjectLatex

proc fillShowObjectCanvas {} {
    global treedefs
    prolog send_treedefs
    catch {.menu.show.m.object.canvas delete 0 last}
    foreach i $treedefs {
            .menu.show.m.object.canvas add command -label Tree($i) \
              -command "show_object_canvas_tree $i"
    }
}

proc fillShowObjectProlog {} {
    global treedefs
    global type_exists
    prolog send_treedefs
    prolog type_exists
    catch {.menu.show.m.object.prolog delete 0 last}
    foreach i $treedefs {
            .menu.show.m.object.prolog add command -label Tree($i) \
              -command "show_object_prolog_tree $i"
    }
    .menu.show.m.object.prolog add command -label Semantics \
              -command show_object_prolog_semantics
    if $type_exists then {
        .menu.show.m.object.prolog add command -label Matrix \
                  -command show_object_prolog_matrix
    }
    .menu.show.m.object.prolog add command -label Text \
              -command show_object_prolog_text
}

proc fillShowObjectLatex {} {
    global treedefs
    global type_exists
    prolog send_treedefs
    global type_exists
    catch {.menu.show.m.object.latex delete 0 last}
    foreach i $treedefs {
            .menu.show.m.object.latex add command -label Tree($i) \
              -command "show_object_latex_tree $i"
    }
    if $type_exists then {
        .menu.show.m.object.latex add command -label Matrix \
                  -command show_object_latex_matrix
    }
    .menu.show.m.object.latex add command -label Semantics \
              -command show_object_latex_semantics
    .menu.show.m.object.latex add command -label Text \
              -command show_object_latex_text
}

# Viewing Predicates
menu .menu.show.m.predicate

.menu.show.m.predicate add cascade -label "Prolog" \
      -menu .menu.show.m.predicate.prolog
.menu.show.m.predicate add cascade -label "LaTeX" \
      -menu .menu.show.m.predicate.latex

menu .menu.show.m.predicate.latex
.menu.show.m.predicate.latex add command -label "Text" \
      -command show_predicate_latex_text

if $type_exists then {
    .menu.show.m.predicate.latex add command -label "Matrix" \
          -command show_predicate_latex_matrix
}

menu .menu.show.m.predicate.prolog
.menu.show.m.predicate.prolog add command -label "Text" \
      -command show_predicate_prolog_text
if $type_exists then {
    .menu.show.m.predicate.prolog add command -label "Matrix" \
          -command show_predicate_prolog_matrix
}

# Viewing type definitions
menu .menu.show.m.type
.menu.show.m.type add command -label "Tk" -command show_type_canvas
.menu.show.m.type add cascade -label "Prolog" -menu .menu.show.m.type.prolog
.menu.show.m.type add command -label "LaTeX"     -command show_type_latex


menu .menu.show.m.type.prolog
.menu.show.m.type.prolog add command -label "Tree" -command show_type_prolog_tree
.menu.show.m.type.prolog add command -label "Text" -command show_type_prolog_text

pack .menu.show -side left

bind . <Any-FocusIn> {
    if {("%d" == "NotifyVirtual") && ("%m" == "NotifyNormal")} {
	focus .menu
    }
}

tk_menuBar .menu .menu.help .menu.file .menu.debug .menu.options \
                 .menu.run .menu.test .menu.grammar .menu.show

# Alt or Control does not work!!!
# bind .menu <Key> {tk_traverseToMenu %W %A}

#proc send_length {flag string} {
#    prolog "receive_flag $flag [string length $string]"
#}

proc SP_send_sent {} {
    global sents
    set sent [SP_qbox .p sents Question "         Select a Sentence         "]
    if {$sent == 0} {return 0}
    prolog start_sent
    foreach i $sent {
       prolog "next_word $i"
    }
    update
    return 1
}

proc SP_select_obj {} {
    global flag
    prolog {send_flag current_no}
    if {$flag(current_no) == 1} {return 0}
    if {$flag(current_no) == 2} {return 1}
    set i 1
    set j {tk_dialog .d Select Object {} 1 cancel}
    while {$i < $flag(current_no)} {
          lappend j $i
          incr i
    }
    return [eval $j]
}

proc fillParserMenu {} {
    global parsers
    global parser
    prolog send_parsers
    catch {.menu.test.m.parsers delete 0 last}
    foreach i $parsers {
        .menu.test.m.parsers add check -label $i -variable parser($i)\
           -command "change_parser $i"
    } 
}

proc fillGeneratorMenu {} {
    global generators
    global generator
    prolog send_generators
    catch {.menu.test.m.generators delete 0 last}
    foreach i $generators {
        .menu.test.m.generators add check -label $i -variable generator($i)\
           -command "change_generator $i"
    } 
}

proc change_parser {prs} {
	global parser
	prolog "change_pm $parser($prs) $prs parser_mode"
}
 
proc change_generator {prs} {
    global generator
    prolog "change_pm $generator($prs) $prs generator_mode"
}

proc change_boolean_flag {kind} {
    global flag
    prolog "receive_boolean_flag $flag($kind) $kind"
}

# show type
## canvas

proc show_type_canvas {} {
    global types
    set type [SP_qbox .w types Type "Type to show" ]
    if {$type == 0} {return 0}
    prolog "show_type_canvas $type"
}

## latex
proc show_type_latex {} {
    global types
    set type [SP_qbox .w types Type "Type to show" ]
    if {$type == 0} {return 0}
    prolog "show_type_latex $type"
}

## prolog
### tree
proc show_type_prolog_tree {} {
    global types
    set type [SP_qbox .w types Type "Type to show"]
    if {$type == 0} {return 0}
    prolog "show_type_prolog_tree $type"
}

### text
proc show_type_prolog_text {} {
    global types
    set type [SP_qbox .w types Type "Type to show"]
    if {$type == 0} {return 0}
    prolog "show_type_prolog_text $type"
}

# show objects
## canvas
proc show_object_canvas_tree {type} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_canvas_tree $type $obj"
}

## prolog
### tree
proc show_object_prolog_tree {type} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_prolog_tree $type $obj"
}

### semantics
proc show_object_prolog_semantics {} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_prolog_semantics $obj"
}

### matrix
proc show_object_prolog_matrix {} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_prolog_matrix $obj"
}

### text
proc show_object_prolog_text {} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_prolog_text $obj"
}

## latex
### tree
proc show_object_latex_tree {type} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_latex_tree $type $obj"
}

### matrix
proc show_object_latex_matrix {} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_latex_matrix $obj"
}

### text
proc show_object_latex_text {} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_latex_text $obj"
}

proc show_object_latex_semantics {} {
    set obj [SP_select_obj]
    if {$obj == 0} {return 0}
    prolog "show_object_latex_semantics $obj"
}

# Show predicates
## prolog
### text

proc show_predicate_prolog_text {} {
    global preds
    set pred [SP_qbox .w preds Pred "Pred to show" ]
    if {$pred == 0} {return 0}
    prolog "show_predicate_prolog_text $pred"
}

### matrix
proc show_predicate_prolog_matrix {} {
    global preds
    set pred [SP_qbox .w preds Pred "Pred to show:" ]
    if {$pred == 0} {return 0}
    prolog "show_predicate_prolog_matrix $pred"
}

## latex
### text
proc show_predicate_latex_text {} {
    global preds
    set pred [SP_qbox .w preds Pred "Pred to show:" ]
    if {$pred == 0} {return 0}
    prolog "show_predicate_latex_text $pred"
}

### matrix
proc show_predicate_latex_matrix {} {
    global preds
    set pred [SP_qbox .w preds Pred "Pred to show:" ]
    if {$pred == 0} {return 0}
    prolog "show_predicate_latex_matrix $pred"
}


proc SP_delete_objects {i} {
     while {$i > 1} {
     incr i -1
     catch "destroy .bb.obj$i"
    }
	update
}

proc SP_object {no} {
    # should not be necc:
    catch "destroy .bb.obj$no"

    global treedefs
    global type_exists
    global generator_exists
    prolog send_treedefs
    prolog type_exists

    menubutton .bb.obj$no -menu .bb.obj$no.a -text "$no" -bg yellow -relief raised
    pack .bb.obj$no -side left
    menu .bb.obj$no.a
    .bb.obj$no.a add cascade -label "View" \
	            -menu .bb.obj$no.a.show
    menu .bb.obj$no.a.show
    .bb.obj$no.a.show add cascade -label "Tk" \
                    -menu .bb.obj$no.a.show.canvas
      menu .bb.obj$no.a.show.canvas
      catch {.bb.obj$no.a.show.canvas delete 0 last}
      foreach i $treedefs {
              .bb.obj$no.a.show.canvas add command -label Tree($i) \
                -command "prolog_show_object_canvas_tree $i $no"
      }
      .bb.obj$no.a.show add cascade -label "Prolog" \
        -menu .bb.obj$no.a.show.prolog
      menu .bb.obj$no.a.show.prolog
      catch {.bb.obj$no.a.show.prolog delete 0 last}
      foreach i $treedefs {
              .bb.obj$no.a.show.prolog add command -label Tree($i) \
                -command "prolog_show_object_prolog_tree $i $no"
      }
      .bb.obj$no.a.show.prolog add command -label Semantics \
                -command "prolog_show_object_prolog_semantics $no"
      if $type_exists then {
          .bb.obj$no.a.show.prolog add command -label Matrix \
                    -command "prolog_show_object_prolog_matrix $no"
      }
      .bb.obj$no.a.show.prolog add command -label Text \
                -command "prolog_show_object_prolog_text $no"
      
      .bb.obj$no.a.show add cascade -label "LaTeX" \
                             -menu .bb.obj$no.a.show.latex
      catch {.bb.obj$no.a.show.latex delete 0 last}
      menu .bb.obj$no.a.show.latex
      foreach i $treedefs {
              .bb.obj$no.a.show.latex add command -label Tree($i) \
                         -command "prolog_show_object_latex_tree $i $no"
      }
      if $type_exists then {
          .bb.obj$no.a.show.latex add command -label Matrix \
                    -command "prolog_show_object_latex_matrix $no"
      }
      .bb.obj$no.a.show.latex add command -label Text \
                -command "prolog_show_object_latex_text $no"
      .bb.obj$no.a.show.latex add command -label Semantics \
                -command "prolog_show_object_latex_semantics $no"
      if $generator_exists then {
          .bb.obj$no.a add command -label Generate \
                    -command "prolog_generate_object $no"
          .bb.obj$no.a add command -label "Compare Generators" \
                    -command "prolog_generate_object_comp $no"
           }
    update
}


set i 1
while {$i < $objs} {
        SP_object $i
        incr i +1
}
unset i

proc TopMenu {} {
    global topcats
    prolog send_topcats
    catch {.menu.options.top delete 0 last}
    foreach i $topcats {
        .menu.options.top add command -label $i \
               -command "SP_receive_flag top_features $i"
    }
    .menu.options.top add command -label "<No Top>" \
               -command "SP_receive_flag top_features undefined"
}

proc ParserMenu {} {
    global parsers
    prolog {send_list parser_mode parsers}
    catch {.menu.options.parser delete 0 last}
    foreach i $parsers {
        .menu.options.parser add command -label $i \
               -command "SP_receive_flag parser $i"
    }
}

proc GeneratorMenu {} {
    global generators
    prolog {send_list generator_mode generators}
    catch {.menu.options.generator delete 0 last}
    foreach i $generators {
        .menu.options.generator add command -label $i \
               -command "SP_receive_flag generator $i"
    }
}

proc SP_receive_flag {att val} {
	global flag
	set flag($att) $val
	prolog "receive_flag $att $val"
}

proc prolog_show_object_canvas_tree {i no} {
	prolog "show_object_canvas_tree $i $no"
}

proc prolog_show_object_prolog_tree {i no} {
	prolog "show_object_prolog_tree $i $no"
}

proc prolog_show_object_prolog_semantics {no} {
	prolog "show_object_prolog_semantics $no"
}

proc prolog_show_object_prolog_matrix {no} {
	prolog "show_object_prolog_matrix $no"
}

proc prolog_show_object_prolog_text {no} {
	prolog "show_object_prolog_text $no"
}

proc prolog_show_object_latex_tree {i no} {
	prolog "show_object_latex_tree $i $no"
}

proc prolog_show_object_latex_matrix {no} {
	prolog "show_object_latex_matrix $no"
}

proc prolog_show_object_latex_text {no} {
	prolog "show_object_latex_text $no"
}

proc prolog_show_object_latex_semantics {no} {
    prolog "show_object_latex_semantics $no"
}

proc prolog_generate_object {no} {
#	global sents
	prolog "generate_object $no"
}

proc prolog_generate_object_comp {no} {
#	global sents
	prolog "generate_object_comp $no"
}

# obtain some more info from prolog
prolog hdrug_startup_hook_end
