:- use_module( library(flags) ).
:- use_module( library(lists), [ member/2,
	                         append/3 ]).

parser_mode(P) :-
	member_flag(parser_mode,P).

generator_mode(P) :-
	member_flag(generator_mode,P).


available :-
	write('currently supports:'),nl,
	( write(parsers),nl,
	  parser_mode(P),
	  tab(5),write(P),nl,
	  fail
        ; true
        ),
	( write(generators),nl,
          generator_mode(P),
          tab(5),write(P), nl,
	  fail
        ; true
        ),
	write('currently disabled:'),nl,
	( write(parsers),nl,
          flag(off(parser_mode),Val),
	  member(P,Val),
	  tab(5),write(P), nl,
	  fail
        ; true
        ),
	( write(generators),nl,
	  flag(off(generator_mode),Val),
	  member(P,Val),
	  tab(5),write(P),nl,
	  fail
        ; true
        ).

% general parse-predicate which selects appropriate parser
%
%
start_parse(Obj) :-
	flag(parser,P),
	start_parse(Obj,P).

start_parse(Obj,P) :-
	wr_flag(parser,P),
	P:clean,
	start_parse_hook(Obj,P),
	remember_string(before,Obj),
	call_residue(P:parse(Obj),Cons), 
	( Cons = [_|_] -> write('pending constraints: '),nl,print(Cons),nl;true),
	end_parse_hook(Obj,P),
	remember_semantics(after,Obj).

start_parse(_Obj,P) :-
	P:count,
	wr_flag(parser,P),
	fail.

start_generate(Obj) :-
	flag(generator,P),
	start_generate(Obj,P).

start_generate(Obj,P) :-
	wr_flag(generator,P),
	P:clean,
	start_generate_hook(Obj,P),
	remember_semantics(before,Obj),
	call_residue(P:generate(Obj),Cons),
	( Cons = [_|_] -> write('pending constraints: '),nl,write(Cons),nl;true),
	end_generate_hook(Obj,P),
	remember_string(after,Obj).

start_generate(_Obj,P) :-
	P:count,
	wr_flag(generator,P),
	fail.

start_parse_hook(o(_Obj,Str,_Sem),_):-
	retractall(lex(_,_,_,_)),
	retractall(ign_lex(_,_,_,_)),
	assert_lex(Str,0),
	check_covered(Str).

start_generate_hook(_,_).

end_parse_hook(_,_).

end_generate_hook(_,_).

remember_string(before,_).
remember_string(after,o(_,String,_)):-
	tk_send_a_sentence(String).

remember_semantics(before,_).
remember_semantics(after,o(_,_,Lf)):-
	tk_send_a_lf(Lf).

assert_lex([],_P).
assert_lex([H|T],P0):-
	P2 is P0 + 1,
	( user:lexicon([H|T0],Small,N),
	  append(T0,_,T),
	  length([H|T0],L),
	  P1 is P0 + L,
	  assertz(lex(P0,P1,Small,N)),
	  fail
        ; user:ign_lexicon([H|T0],Small,N),
	  append(T0,_,T),
	  length([H|T0],L),
	  P1 is P0 + L,
	  assertz(ign_lex(P0,P1,Small,N)),
	  fail
        ; assert_lex(T,P2)
        ).

check_covered(Str) :-
	check_covered(Str,0,true,Call),
	Call.

check_covered([],_,T,T).
check_covered([H|T],P0,T0,Tr) :-
	P is P0 + 1,
	check_covered0(H,P0,P,T0,T1),
	check_covered(T,P,T1,Tr).

check_covered0(Word,P0,P,T0,T) :-
	(  call_residue(lex(Q0,Q,_,_),_),
	   Q0 =< P0, P =< Q
        -> T0 = T
        ;  format("ERROR: ~w is unknown~n",[Word]),
	   T = raise_exception(restart)
        ).


