% this produces TeX output on the basis of statistical parse information.

% table_entry(Name,Length,Amb,Parser,Time,Edges)

:- use_module( library(lists), [ member/2,
                                 select/3 ]).
:- use_module( library(concat),[ concat/3,
	                         concat_all/3,
				 term_atom/2] ).
:- use_module( library(flags)).
:- use_module( library(count_edges), [count_edges/2]).
:- use_module( library(latex) ).

go_and_table(Parser) :-
	( setof(Nr,X^Y^a_sentence(Nr,X,Y),Nrs),
	  member(N,Nrs),
	  go(N),
	  p_tt(Parser),
	  fail
        ; true 
        ).

p_tt(Parser):-
	latex:files(TexFile,_,_,_,_),
	print_table_tex(TexFile,Parser),
	latex:latex_and_xdvi.

p_tt :-
	parser_mode(P),
	!,
	p_tt(P).

print_table_tex(File,Parser) :-
	telling(Old),
	tell(File),
	print_table_tex_core(length,Parser),!,
	told,
	tell(Old).

print_table_tex_core(LengthAmb,Parser) :-
	print_starters,
	setof(P,a_parser_mode(P),Parsers),
	setof(L,a_la(LengthAmb,L),Length),
	select(Parser,Parsers,Parsers2),
	begin_table([Parser|Parsers2]),
	do_table(Length,[Parser|Parsers2],LengthAmb),
	end_table,
	print_enders.

a_la(length,L):-
	table_entry(_,L,_,_,_,_).

a_la(amb,L):-
	table_entry(_,_,L,_,_,_),
	integer(L).

go_and_table_amb(Parser) :-
	( setof(Nr,X^Y^a_sentence(Nr,X,Y),Nrs),
	  member(N,Nrs),
	  go(N),
	  p_tt_amb(Parser),
	  fail
        ; true 
        ).

p_tt_amb(Parser):-
	latex:files(TexFile,_,_,_,_),
	print_table_tex_amb(TexFile,Parser),
	latex:latex_and_xdvi.

p_tt_amb :-
	parser_mode(P),
	!,
	p_tt_amb(P).

print_table_tex_amb(File,Parser) :-
	telling(Old),
	tell(File),
	print_table_tex_core(amb,Parser),!,
	told,
	tell(Old).

a_parser_mode(P):-
	table_entry(_,_,_,_,P,_).

print_parsers(P):-
	p_par(P),
	write('\\ \hline '),nl.

p_par([]).
p_par([H|T]):-
	escape_chars(H,H1),
	write(' & '),
	write(H1),
	p_par(T).

do_table([],_,_).
do_table([N1|T],Ps,LA):-
	write(N1),
	write(' & '),
	give_number_of_readings(LA,N1,Ps),
	write_e_first(Ps,N1,LA),
	write('\\'),nl,
	do_table(T,Ps,LA).


give_number_of_readings(length,Length,[P|_]):-
	compute_readings(Length,P,Total),
	write(Total).
give_number_of_readings(amb,Amb,[P|_]):-
	compute_lengths(Amb,P,Total),
	write(Total).

write_e_first([Ph|Pt],L,LA):-
	write_first(Ph,L,Factor,LA),
	write_e(Pt,L,Factor,LA,Ph).

write_e([],_,_,_,_).
write_e([H|T],N,F,LA,Ph):-
	write(' & '),
	write_e1(N,H,F,LA,Ph),
	write_e(T,N,F,LA,Ph).

write_first(Parser,Length,Factor,LA):-
	write(' & '),
	bagof(Time,one(LA,Length,Parser,Time),Times),!,
	write(100),
	length(Times,Number),
	sum_list(Times,0,AllTime),
	NewTime is AllTime/Number,
	Factor is 100/NewTime,
	Extra is NewTime//1,   %afronding
	write('='), write(Extra).
write_first(_,_,1,_):-
	write(' & ').

/* wrong: if time-out occurred you are not comparing in a fair way..
write_e1(Length,Parser,F,LA):-
	bagof(Time,one(LA,Length,Parser,Time),Times),!,
	length(Times,Number),
	sum_list(Times,0,AllTime),
	NewTime is (F*(AllTime/Number))//1,  %afronding
	write(NewTime).
write_e1(_,_,_,_).
*/

write_e1(Key,Parser,Factor,ChooseKey,NormParser):-
	bagof(Time,one(ChooseKey,Key,Parser,Time),Times),
	(  one_time_out(ChooseKey,Key,Parser)
        -> recompute_factor(Key,Parser,Factor2,ChooseKey,NormParser)
        ;  Factor2 = Factor
        ),
	length(Times,Number),
	sum_list(Times,0,AllTime),
	NewTime is (Factor2*(AllTime/Number))//1, % afronding
	write(NewTime).
write_e1(_,_,_,_,_).

one_time_out(length,Length,Parser):-
	( table_entry(_,Length,time_out,_,Parser,_)
        ; table_entry(_,Length,space_out,_,Parser,_)).
%one_time_out(amb,_,Parser):-
%	table_entry(_,_,time_out,_,Parser,_).

recompute_factor(Key,Parser,Factor,ChooseKey,NormParser):-
	% find those Times (Amb) such that they are not timeout for Parser
	setof(Time,rec_one(ChooseKey,Key,NormParser,Parser,Time),Times),!,
	length(Times,Number),
	sum_list(Times,0,AllTime),
	NewTime is AllTime/Number,
	Factor is 100/NewTime.

rec_one(length,Length,Parser,Other,Time):-
	table_entry(Name,Length,To1,Time,Parser,_),
	\+ To1 = time_out,
	\+ To1 = space_out,
	table_entry(Name,Length,To2,_,Other,_),
	\+ To2 = time_out,
	\+ To2 = space_out.

rec_one(amb,Length,Parser,Other,Time):-
	table_entry(Name,_,Length,Time,Parser,_),
	table_entry(Name,_,Length2,_,Other,_),
	\+ Length2 = time_out,
	\+ Length2 = space_out.

one(length,Length,Parser,Time):-
	table_entry(_,Length,Amb,Time,Parser,_),
	\+ Amb = time_out,
	\+ Amb = space_out.

one(amb,Length,Parser,Time):-
	table_entry(_,_,Length,Time,Parser,_).

end_table :-
	write('\hline\end{tabular}\end{center}'),nl.

begin_table(Parsers) :-
	write('\begin{center}'),nl,
	write('\begin{tabular}'),
	write('{||r|r|'),
	once_r(Parsers),
	write('|}\hline '),nl,
	write(' n & \# '),
	print_parsers(Parsers).

escape_chars(A,A2):-
	term_atom(A,A1),
	name(A1,Chars),
	escape_l(Chars,Chars2),
	name(A2,Chars2).

escape_l([],[]).
escape_l([H|T],Out):-
	escape_c(H,Rest,Out),
	escape_l(T,Rest).

% 38: &
% 95: _
% 36: $

% 92: \
escape_c(36,R,[92,36|R]) :- !.
escape_c(38,R,[92,38|R]) :- !.
escape_c(95,R,[92,95|R]) :- !.

% catch all:
escape_c(C,R,[C|R]).



once_r([]).
once_r([_|T]):-
	write('r|'),
	once_r(T).

print_starters :-
	write('\documentstyle[a4wide]{article}'),nl,
	write('\begin{document}'),nl,
	write('\small'),nl,nl.   % change this to tiny if you have large tables


print_enders :-
	nl,write('\end{document}'),nl,nl.

compute_readings(Length,Parser,Total) :-
	bagof(Amb,Time^Name^Edges^table_entry(Name,Length,Amb,Time,Parser,Edges),Ambs),
	count_edges(table_entry(_,Length,_,_,Parser,_),L2),
	sum_list(Ambs,0,Total1),
	Total is Total1//L2.

compute_lengths(Amb,Parser,Total):-
	bagof(Length,Amb^Time^Name^Edges^table_entry(Name,Length,Amb,Time,Parser,Edges),Ambs),
	count_edges(table_entry(_,_,Amb,_,Parser,_),L2),
	sum_list(Ambs,0,Total1),
	Total is Total1//L2.
