:- use_module( library(tk_draw) ).
:- use_module( library(lists),       [ member/2,
	                               append/3 ]).

sts :-
	findall(P,parser_mode(P),Parsers),
	sts(Parsers).

sts(Parsers):-
	findall(L,(member(P,Parsers),get_table(P,L)),List),
	find_maxs(List,Maxs),
	show_tables(List,Parsers,Maxs).

get_table(Parser,List):-
	setof(Len/Time,
              Name^Amb^Edges^(table_entry(Name,Len,Amb,Time,Parser,Edges),
                              \+Amb=space_out),
              List).

sts_add :-
	findall(P,parser_mode(P),Parsers),
	sts_add(Parsers).

sts_add(Parsers):-
	findall(L,(member(P,Parsers),get_table_add(P,L)),List),
	show_tables(List,Parsers,[]).

get_table_add(Parser,List):-
	setof(X/Y,table_element_add(Parser,X/Y),List).

table_element_add(Parser,X/Y):-
	setof(T,add_info(T),Table),          % add_info is defined in statistics.pl
	member(t(X,Y,Parser),Table).

find_maxs([H|_],Maxs):-
	maximum_length(H,0,L),
	find_maxs(1,L,Maxs,[]).

find_maxs(P,Q,L,L):-
	P > Q, !.
find_maxs(P0,P,[P0/Y|L0],L):-
	maximum_per_word(P0,Y),
	P1 is P0 + 1,
	find_maxs(P1,P,L0,L).

maximum_length([],M,M).
maximum_length([L/_|T],M,N):-
	L >= M,!,
	maximum_length(T,L,N).
maximum_length([_|T],M,N):-
	maximum_length(T,M,N).

sum_list([],T,T).
sum_list([H|T],C0,C):-
	C1 is H + C0,
	sum_list(T,C1,C).

show_tables(Tlist):-
	show_tables(Tlist,[],[]).

show_tables(Tlist,Nlist,Line):-
	append_all(Tlist,List),
	range(Xrange,Yrange,List,Xmax,Ymax),
	show_tables(Xrange,Yrange,Tlist,Nlist,Line,Xmax,Ymax).

append_all([],[]).
append_all([H|T],All):-
	append(H,Rest,All),
	append_all(T,Rest).

show_table(Table):-
	range(X,Y,Table,Xmax,Ymax),
	show_tables(X,Y,[Table],[],[],Xmax,Ymax).

show_table(Table,Name):-
	range(X,Y,Table,Xmax,Ymax),
	show_tables(X,Y,[Table],[Name],[],Xmax,Ymax).

show_table(Table,Name,Line):-
	range(X,Y,Table,Xmax,Ymax),
	show_tables(X,Y,[Table],[Name],Line,Xmax,Ymax).

range(Xrange,Yrange,[X/Y|Table],Xr,Yr):-
	xmax(Table,X,Xr),
	ymax(Table,Y,Yr),
	Xrange is Xr + (Xr/10),
	Yrange is Yr + (Yr/10).

% 
% should be defined in Makefile or some such place..
y_depth(280).
x_width(700).
x_start(70).
y_end(30).


show_tables(Xrange,Yrange,Tables0,Names,Line0,Xmax,Ymax) :-
	show_tables(Xrange,Yrange,Tables0,Names,Line0,Xmax,Ymax,
              'Word length','Milli seconds').


show_tables(Xrange,Yrange,Tables0,Names,Line0,Xmax,Ymax,Xmsg,Ymsg) :-
	tk_clear,
	y_depth(Dy),
	x_width(Dx),
	x_start(Xs),
	y_end(Ys),
	Xr is Dx/Xrange,
	Yr is Dy/Yrange,
	tk_line(Xs,Dy,Dx+Xs,Dy),
	tk_line(Xs,Dy,Xs,Ys),
	tk_string(Xs,Ys-20,Ymsg),
	tk_string(Xs+(Dx/2),Dy+40,Xmsg),
	axes(Xmax,Ymax,Xr,Yr),
	convert_table(Line0,Line,Xr,Yr),
	convert_tables(Tables0,Tables,Xr,Yr),
	show_line(Line),
	show_names(Names,1,Ys),
	show_tabs(Tables,1).

axes(Xmax,Ymax,Xr,Yr) :-
	Xscale is 10*exp(10,log(10,Xmax)//1),
	X1 is Xscale/5,
	X2 is 2*X1,
	X3 is 3*X1,
	X4 is 4*X1,
	convert_table([0/0,X1/0,X2/0,X3/0,X4/0,Xscale/0],XPoints,Xr,Yr),
	show_ax(x,XPoints,[0,X1,X2,X3,X4,Xscale]),
	Yscale is 10*exp(10,log(10,Ymax)//1),
	Y1 is Yscale/5,
	Y2 is 2*Y1,
	Y3 is 3*Y1,
	Y4 is 4*Y1,
	convert_table([0/0,0/Y1,0/Y2,0/Y3,0/Y4,0/Yscale],YPoints,Xr,Yr),
	show_ax(y,YPoints,[0,Y1,Y2,Y3,Y4,Yscale]).

show_ax(_,[],[]).
show_ax(XY,[X/Y|T0],[Str|T]) :-
	tk_string(XY,X,Y,Str),
	show_ax(XY,T0,T).

tk_string(x,X,Y,Str) :-
	tk_string(X,Y+20,Str).

tk_string(y,X,Y,Str) :-
	tk_string(X-30,Y,Str).

convert_tables([],[],_,_).
convert_tables([H0|T0],[H|T],Xr,Yr) :-
	convert_table(H0,H,Xr,Yr),
	convert_tables(T0,T,Xr,Yr).

convert_table([],[],_,_).
convert_table([X/Y|T0],[Nx/Ny|T],Xr,Yr) :-
	y_depth(D),
	x_start(Xs),
	Nx is Xs + Xr*X,
	Ny is D - Yr*Y,
	convert_table(T0,T,Xr,Yr).

show_line([]).
show_line([H|T]):-
	show_line(T,H).

show_line([],_).
show_line([X1/Y1|T],X/Y):-
        tk_line(X,Y,X1,Y1),
	show_line(T,X1/Y1).

show_names([],_,_).
show_names([H|T],No,Y):-
	x_start(Xs),
	show_t(No,Xs+50,Y),
%%	View => string(20,Y+10,H),
        tk_string(Xs+50,Y+10,H),
	Y2 is Y + 30,
	No2 is No + 1,
	show_names(T,No2,Y2).

show_tabs([],_).
show_tabs([H|T],No):-
	show_tab(H,No),
	No2 is No + 1,
	show_tabs(T,No2).

show_tab([],_).
show_tab([X/Y|T],No):-
	show_t(No,X,Y),
	show_tab(T,No).

show_t(1,X,Y) :-
	tk_fill_circle(X,Y,3).

show_t(2,X,Y) :-
	tk_circle(X,Y,3).

show_t(3,X,Y) :-
	tk_rect(X-2,Y-2,X+2,Y+2).

show_t(4,X,Y) :-
	tk_fill_rect(X-2,Y-2,X+2,Y+2).

show_t(5,X,Y):-
	tk_polygon([X-3,X,X+3],[Y-3,Y+3,Y-3]).

show_t(6,X,Y):-
	tk_fill_polygon([X-3,X,X+3],[Y-3,Y+3,Y-3]).

show_t(7,X,Y):-
	tk_polygon([X-3,X+3,X],[Y+3,Y+3,Y-3]).

show_t(8,X,Y):-
	tk_fill_polygon([X-3,X+3,X],[Y+3,Y+3,Y-3]).

show_t(9,X,Y):-
	tk_polygon([X-3,X,X+3,X],[Y,Y+3,Y,Y-3]).

show_t(10,X,Y):-
	tk_fill_polygon([X-3,X,X+3,X],[Y,Y+3,Y,Y-3]).

show_t(N,X,Y):-
	N > 10,
	tk_string(X,Y,N).

test :-
	show_table(10,50,[7/20,8/30,9/40]).


xmax([],X,X).
xmax([X/_|Tail],Med,Max):-
	(  X >= Med
        -> xmax(Tail,X,Max)
        ;  xmax(Tail,Med,Max)
        ).

ymax([],X,X).
ymax([_/X|Tail],Med,Max):-
	(  X >= Med
        -> ymax(Tail,X,Max)
        ;  ymax(Tail,Med,Max)
        ).

